<?php

$course      = get_post( $course_id);
$course_link = get_permalink( $course_id );

$progress = learndash_course_progress( array(
    'user_id'   => $user_id,
    'course_id' => $course_id,
    'array'     => true
) );

$status = ( $progress['percentage'] == 100 ) ? 'completed' : 'notcompleted';
$status = ( $progress['percentage'] > 0 && $progress['percentage'] !== 100 ? 'progress' : $status );
$since = learndash_user_group_enrolled_to_course_from( $user_id, $course_id );
if( empty($since) ) {
    $since = ld_course_access_from( $course_id,  $user_id );
}

$course_class = apply_filters( 'learndash-course-row-class',
                                'ld-item-list-item ld-item-list-item-course ld-expandable ' . ( $progress['percentage'] == 100 ? 'learndash-complete' : 'learndash-incomplete' ), $course, $user_id );

$course_icon_class = apply_filters( 'learndash-course-icon-class',
                                    'ld-status-icon ' . ( $progress['percentage'] == 100 ? 'ld-status-complete' : 'ld-status-incomplete' ), $course, $user_id ); ?>

<div class="<?php echo esc_attr($course_class); ?>" id="<?php echo esc_attr( 'ld-course-list-item-' . $course_id ); ?>">
    <div class="ld-item-list-item-preview">

        <a href="<?php echo esc_url( get_the_permalink($course_id) ); ?>" class="ld-item-name">
            <?php learndash_status_icon( $status, get_post_type('sfwd-courses'), null, true ); ?>
            <span class="ld-item-title">
                <?php
                echo esc_html( get_the_title($course_id) );

                $components = array(
                    'progress'  => sprintf( esc_html_x( '%s%% Complete', 'User Status Course Progress', 'learndash' ),  $progress['percentage'] ),
                    'steps'     => sprintf( esc_html_x( '%1$d/%2$d Steps', 'User Status Course Steps', 'learndash' ), $progress['completed'], $progress['total'] )
                );

                if( !empty($since) ) {
                    $components['since'] = sprintf( esc_html_x( 'Since %s', 'User Status Course Since', 'learndash' ), learndash_adjust_date_time_display($since) );
                }

                $components = apply_filters( 'learndash_user_status_course_components', $components ); ?>
                <span class="ld-item-components">
                    <?php $i = 1; foreach( $components as $slug => $markup ): ?>
                        <span class="<?php echo esc_attr( 'ld-item-component-' . $slug ); ?>">
                            <?php echo wp_kses_post($markup); ?>
                        </span>
                        <?php
                        if( $i != count($components) ): ?>
                            <span class="ld-sep">|</span>
                        <?php
                        endif;
                    $i++; endforeach; ?>
                </span>
            </span>
        </a> <!--/.ld-course-name-->

    </div> <!--/.ld-course-preview-->
</div> <!--/.ld-course-list-item-->
