<?php

/**
 * LearnDash Related Backward/Forward Compatibility Functions
 *
 */

if ( ! function_exists( 'learndash_get_course_meta_setting' ) ) {

	/**
	 * Function added in `v2.6.4` (released January 23rd, 2019)
	 *
	 * @param  integer $course_id
	 * @param  string  $setting_key
	 */
	function learndash_get_course_meta_setting( $course_id = 0, $setting_key = '' ) {
		$course_settings = array();

		if ( empty( $course_id ) ) return $course_settings;

		$meta = get_post_meta( $course_id, '_sfwd-courses', true );
		if ( ( is_null( $meta ) ) || ( !is_array( $meta ) ) ) $meta = array();

		// we only want/need to reformat the access list of we are returning ALL setting or just the access list
		if ( ( empty( $setting_key ) ) || ( $setting_key == 'course_access_list' ) ) {
			if ( !isset( $meta['sfwd-courses_course_access_list'] ) ) {
				$meta['sfwd-courses_course_access_list'] = '';
			}
			$meta['sfwd-courses_course_access_list'] = array_map( 'intVal', explode( ',', $meta['sfwd-courses_course_access_list'] ) );

			// Need to remove the empty '0' items
			$meta['sfwd-courses_course_access_list'] = array_diff($meta['sfwd-courses_course_access_list'], array(0, ''));
		}

		if ( empty( $setting_key ) ) {
			return $meta;
		} else if ( isset( $meta['sfwd-courses_'. $setting_key] ) ) {
			return $meta['sfwd-courses_'. $setting_key];
		}
	}
}
