<?php
$show_search = buddyboss_theme_get_option( 'header_search' );
$show_messages = buddyboss_theme_get_option( 'messages' );
$show_notifications = buddyboss_theme_get_option( 'notifications' );
$show_shopping_cart = buddyboss_theme_get_option( 'shopping_cart' );
?>

<div id="header-aside" class="header-aside">
	<div class="header-aside-inner">
		<?php if ( is_user_logged_in() ) { ?>
			<div class="user-wrap user-wrap-container menu-item-has-children">
				<?php
				$user_link		 = function_exists( 'bp_core_get_user_domain' ) ? bp_core_get_user_domain( get_current_user_id() ) : get_author_posts_url( get_current_user_id() );
				$current_user	 = wp_get_current_user();
				?>
				<a class="user-link" href="<?php echo $user_link; ?>">
					<span class="user-name"><?php echo $current_user->display_name; ?></span><i class="bb-icon-angle-down"></i>
					<?php echo get_avatar( get_current_user_id(), 100 ); ?>
				</a>

				<ul class="sub-menu">
					<li>
						<a class="user-link" href="<?php echo $user_link; ?>">
							<?php echo get_avatar( get_current_user_id(), 100 ); ?>
							<span>
								<span class="user-name"><?php echo $current_user->display_name; ?></span>
								<?php if (function_exists( 'bp_is_active' )): ?>
									<span class="user-mention"><?php echo '@' . bp_activity_get_user_mentionname( $current_user->ID ); ?></span>
								<?php else: ?>
									<span class="user-mention"><?php echo '@' . $current_user->user_login; ?></span>
								<?php endif; ?>
							</span>
						</a>
					</li>

					<?php do_action( THEME_HOOK_PREFIX . 'header_user_menu_items' ); ?>
				</ul>
			</div>
            
            <?php
            if ( class_exists( 'SFWD_LMS' ) && buddyboss_is_learndash_inner() ) { ?>
            
                <span class="bb-separator"></span>
                <a href="#" id="bb-toggle-theme">
                    <span class="sfwd-dark-mode" data-balloon-pos="down" data-balloon="<?php _e( 'Dark Mode', 'buddyboss-theme' ); ?>"><i class="bb-icon-moon-circle"></i></span>
                    <span class="sfwd-light-mode" data-balloon-pos="down" data-balloon="<?php _e( 'Light Mode', 'buddyboss-theme' ); ?>"><i class="bb-icon-sun"></i></span>
                </a>
                <a href="#" class="header-maximize-link course-toggle-view" data-balloon-pos="down" data-balloon="<?php _e( 'Maximize', 'buddyboss-theme' ); ?>"><i class="bb-icon-maximize"></i></a>
                <a href="#" class="header-minimize-link course-toggle-view" data-balloon-pos="down" data-balloon="<?php _e( 'Minimize', 'buddyboss-theme' ); ?>"><i class="bb-icon-minimize"></i></a>
                
            <?php } else { ?>
            
                <?php if( $show_search || $show_messages || $show_notifications || $show_shopping_cart ) { ?>
    				<span class="bb-separator"></span>
    			<?php } ?>
    
    			<?php if( $show_search ) { ?>
    				<a href="#" class="header-search-link" data-balloon-pos="down" data-balloon="<?php _e( 'Search', 'buddyboss-theme' ); ?>"><i class="bb-icon-search"></i></a>
    			<?php } ?>
    
    			<?php if( $show_messages && function_exists( 'bp_is_active' ) && bp_is_active( 'messages' ) && bp_loggedin_user_id()  ) { ?>
    				<?php get_template_part( 'template-parts/messages-dropdown' ); ?>
    			<?php } ?>
    
    			<?php if( $show_notifications && function_exists( 'bp_is_active' ) && bp_is_active( 'notifications' ) && bp_loggedin_user_id() ) { ?>
    					<?php get_template_part( 'template-parts/notification-dropdown' ); ?>
    			<?php } ?>
    
    			<?php if( $show_shopping_cart && function_exists( 'wc' ) ) { ?>
                    <?php get_template_part( 'template-parts/cart-dropdown' ); ?>
    			<?php } ?>
                
            <?php } ?>

		<?php } else { ?>

			<a href="#" class="header-search-link" data-balloon-pos="down" data-balloon="<?php _e( 'Search', 'buddyboss-theme' ); ?>"><i class="bb-icon-search"></i></a>
			<span class="search-separator bb-separator"></span>
			<div class="bb-header-buttons">
				<a href="<?php echo wp_login_url(); ?>" class="button small outline signin-button link"><?php _e( 'Sign in', 'buddyboss-theme' ); ?></a>
				<?php if ( get_option( 'users_can_register' ) ) { ?>
					<a href="<?php echo wp_registration_url(); ?>" class="button small singup"><?php _e( 'Sign up', 'buddyboss-theme' ); ?></a>
				<?php } ?>
			</div>

		<?php } ?>
        <?php
            $header = buddyboss_theme_get_option( 'buddyboss_header' );
    
            if ( $header == '3' || ( class_exists( 'SFWD_LMS' ) && buddyboss_is_learndash_inner() ) ) {
                echo buddypanel_position_right();	
    		}  
        ?>
	</div>
</div>
