<?php
global $messages_template;
$menu_link            = trailingslashit( bp_loggedin_user_domain() . bp_get_messages_slug() );
$unread_message_count = messages_get_unread_count();
?>
<div id="header-messages-dropdown-elem" class="dropdown-passive dropdown-right notification-wrap messages-wrap menu-item-has-children">
    <a href="<?php echo $menu_link ?>"
       ref="notification_bell"
       class="notification-link">
       <span data-balloon-pos="down" data-balloon="<?php _e( 'Messages', 'buddyboss-theme' ); ?>">
            <i class="bb-icon-inbox-small"></i>
			<?php if ( $unread_message_count > 0 ): ?>
                <span class="count"><?php echo $unread_message_count; ?></span>
			<?php endif; ?>
        </span>
    </a>
    <section class="notification-dropdown">
        <header class="notification-header">
            <h2 class="title"><?php _e( 'Messages', 'buddyboss-theme' ); ?></h2>
        </header>

        <ul class="notification-list">
			<?php if ( bp_has_message_threads( bp_ajax_querystring( 'messages' ) . '&user_id=' . get_current_user_id() ) ) : ?>
				<?php while ( bp_message_threads() ) : bp_message_thread(); ?>

                    <?php $last_message_id = (int) $messages_template->thread->last_message_id; ?>

                    <li class="read-item">
					<span class="bb-full-link">
						<a href="<?php bp_message_thread_view_link( bp_get_message_thread_id() ); ?>">
							<?php bp_message_thread_subject(); ?>
						</a>
					</span>
                        <div class="notification-avatar">
                            <a href="<?php echo bp_core_get_user_domain( $messages_template->thread->last_sender_id ); ?>">
								<?php bp_message_thread_avatar(); ?>
                            </a>
                        </div>
                        <div class="notification-content">
						<span class="bb-full-link">
							<a href="<?php bp_message_thread_view_link( bp_get_message_thread_id() ); ?>">
								<?php bp_message_thread_subject(); ?>
							</a>
						</span>
                            <span>
							<a href="<?php bp_message_thread_view_link( bp_get_message_thread_id() ); ?>">
								<?php
								$recipients = (array) $messages_template->thread->recipients;
								$recipient_names = array();
								foreach ( $recipients as $recipient ) {
									if ( (int) $recipient->user_id !== bp_loggedin_user_id() ) {
										$recipient_name = bp_core_get_user_displayname( $recipient->user_id );

										if ( empty( $recipient_name ) ) {
											$recipient_name = __( 'Deleted User', 'buddyboss-theme' );
										}

										$recipient_names[] = $recipient_name;
									} else {
										$recipient_names[] = __( 'you', 'buddyboss-theme' );
									}
								}

								// Concatenate to natural language string.
								echo wp_sprintf_l( '%l', $recipient_names );
                                ?>
							</a>
						</span>
                            <span class="posted">
                                <?php
                                $exerpt = strip_tags( bp_create_excerpt( $messages_template->thread->last_message_content, 50, array( 'ending' => '&hellip;' ) ) );
                                if ( function_exists( 'buddypress' ) && bp_is_active( 'media' ) ) {
	                                if ( bp_is_messages_media_support_enabled() ) {
		                                $media_ids = bp_messages_get_meta( $last_message_id, 'bp_media_ids', true );

		                                if ( ! empty( $media_ids ) ) {
			                                $media_ids = explode( ',', $media_ids );
			                                if ( sizeof( $media_ids ) < 2 ) {
				                                $exerpt = __( 'sent a photo', 'buddyboss-theme' );
			                                } else {
				                                $exerpt = __( 'sent some photos', 'buddyboss-theme' );
			                                }
		                                }
	                                }

	                                if ( bp_is_messages_gif_support_enabled() ) {
		                                $gif_data = bp_messages_get_meta( $last_message_id, '_gif_data', true );

		                                if ( ! empty( $gif_data ) ) {
			                                $exerpt = __( 'sent a gif', 'buddyboss-theme' );
		                                }
	                                }
                                }
                                ?>
                                <?php echo bp_core_get_user_displayname( $messages_template->thread->last_sender_id ); ?>: <?php echo $exerpt; ?></span>
                        </div>
                    </li>
				<?php endwhile; ?>
			<?php else : ?>
                <li class="bs-item-wrap">
                    <div class="notification-content"><?php _e( 'No new messages', 'buddyboss-theme' ); ?>!</div>
                </li>
			<?php
			endif;
			?>
        </ul>

		<footer class="notification-footer">
			<a href="<?php echo $menu_link ?>" class="delete-all">
				<?php _e( 'View Inbox', 'buddyboss-theme' ); ?>
				<i class="bb-icon-angle-right"></i>
			</a>
		</footer>
    </section>
</div>