<?php
$menu_link                 = trailingslashit( bp_loggedin_user_domain() . bp_get_notifications_slug() );
$notifications             = bp_notifications_get_unread_notification_count( bp_loggedin_user_id() );
$unread_notification_count = ! empty( $notifications ) ? $notifications : 0;
?>
<div class="notification-wrap menu-item-has-children">
    <a href="<?php echo $menu_link ?>"
       ref="notification_bell"
       class="notification-link">
       <span data-balloon-pos="down" data-balloon="<?php _e( 'Notifications', 'buddyboss-theme' ); ?>">
            <i class="bb-icon-bell-small"></i>
    		<?php if ( $unread_notification_count > 0 ): ?>
                <span class="count"><?php echo $unread_notification_count; ?></span>
    		<?php endif; ?>
        </span>
    </a>
    <section class="notification-dropdown">
        <header class="notification-header">
            <h2 class="title"><?php _e( 'Notifications', 'buddyboss-theme' ); ?></h2>
        </header>

        <ul class="notification-list">
			<?php if ( bp_has_notifications( bp_ajax_querystring( 'notifications' ) ) ) : ?>
				<?php while ( bp_the_notifications() ) : bp_the_notification(); ?>

					<?php
					$bp      = buddypress();
					$user_id = $bp->notifications->query_loop->notification->secondary_item_id;
					?>
                    <li class="read-item">
						<span class="bb-full-link">
							<?php bp_the_notification_description(); ?>
						</span>
                        <div class="notification-avatar">
							<?php buddyboss_notification_avatar(); ?>
                        </div>
                        <div class="notification-content">
							<span class="bb-full-link">
								<?php bp_the_notification_description(); ?>
							</span>
                            <span><?php bp_the_notification_description(); ?></span>
                            <span class="posted"><?php bp_the_notification_time_since(); ?></span>
                        </div>
                    </li>
				<?php endwhile; ?>
			<?php else : ?>
                <li class="bs-item-wrap">
                    <div class="notification-content"><?php _e( 'No new notifications', 'buddyboss-theme' ); ?>!</div>
                </li>
			<?php
			endif;
			?>
        </ul>

		<footer class="notification-footer">
			<a href="<?php echo $menu_link ?>" class="delete-all">
				<?php _e( 'View Notifications', 'buddyboss-theme' ); ?>
				<i class="bb-icon-angle-right"></i>
			</a>
		</footer>
    </section>
</div>