<?php

$elements = [
    'content-elements'  => [
        'title' => __( 'Content Elements', 'essential-addons-elementor' ),
        'elements'  => [
            [
                'key'   => 'creative-btn',
                'title' => __( 'Creative Button', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/creative-buttons/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/creative-buttons/',
            ],
            [
                'key'   => 'team-members',
                'title' => __( 'Team Member', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/team-members/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/team-members/',
            ],
            [
                'key'   => 'testimonials',
                'title' => __( 'Testimonial', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/testimonials/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/testimonials/',
            ],
            [
                'key'   => 'flip-box',
                'title' => __( 'Flip Box', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/flip-box/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/flip-box/',
            ],
            [
                'key'   => 'info-box',
                'title' => __( 'Info Box', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/info-box/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/info-box/',
            ],
            [
                'key'   => 'dual-header',
                'title' => __( 'Dual Color Heading', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/dual-color-headline/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/dual-color-headline/',
            ],
            [
                'key'   => 'tooltip',
                'title' => __( 'Tooltip', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/tooltip/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/tooltip/',
            ],
            [
                'key'   => 'adv-accordion',
                'title' => __( 'Advanced Accordion', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/advanced-accordion/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/advanced-accordion/',
            ],
            [
                'key'   => 'adv-tabs',
                'title' => __( 'Advanced Tabs', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/advanced-tabs/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/advanced-tabs/',
            ],
            [
                'key'   => 'feature-list',
                'title' => __( 'Feature List', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/feature-list/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/ea-feature-list/',
            ],
            [
                'key'    => 'offcanvas',
                'title'  => __( 'Offcanvas', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/offcanvas-content/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/essential-addons-elementor-offcanvas/',
                'is_pro' => true
            ],
            [
                'key'    => 'advanced-menu',
                'title'  => __( 'Advanced Menu', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/advanced-menu/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/ea-advanced-menu/',
                'is_pro' => true
            ],
            [
                'key'    => 'toggle',
                'title'  => __( 'Toggle', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/content-toggle/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/content-toggle/',
                'is_pro' => true
            ],
            [
                'key'    => 'testimonial-slider',
                'title'  => __( 'Testimonial Slider', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/testimonial-slider/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/testimonial-slider/',
                'is_pro' => true
            ],
            [
                'key'    => 'static-product',
                'title'  => __( 'Static Product', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/static-product/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/static-product/',
                'is_pro' => true
            ],
            [
                'key'    => 'team-member-carousel',
                'title'  => __( 'Team Member Carousel', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/team-member-carousel/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/team-member-carousel/',
                'is_pro' => true
            ]
        ]
    ],
    'dynamic-content-elements'  => [
        'title' => __( 'Dynamic Content Elements', 'essential-addons-elementor' ),
        'elements'  => [
            [
                'key'   => 'post-grid',
                'title' => __( 'Post Grid', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/post-grid/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/post-grid/',
            ],
            [
                'key'   => 'post-timeline',
                'title' => __( 'Post Timeline', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/post-timeline/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/post-timeline/',
            ],
            [
                'key'   => 'data-table',
                'title' => __( 'Data Table', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/table/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/data-table/',
            ],
            [
                'key'   => 'content-ticker',
                'title' => __( 'Content Ticker', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/content-ticker/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/content-ticker/',
            ],
            [
                'key'    => 'product-grid',
                'title'  => __( 'Product Grid', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/woo-product-grid/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/woocommerce-product-grid/',
            ],
            [
                'key'   => 'adv-google-map',
                'title' => __( 'Advanced Google Map', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/advanced-google-map/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/advanced-google-map/',
                'is_pro' => true
            ],
            [
                'key'    => 'post-block',
                'title'  => __( 'Post Block', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/post-block/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/post-block/',
                'is_pro' => true
            ],
            [
                'key'    => 'post-carousel',
                'title'  => __( 'Post Carousel', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/post-carousel/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/post-carousel/',
                'is_pro' => true
            ],
            [
                'key'    => 'post-list',
                'title'  => __( 'Smart Post List', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/post-list/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/smart-post-list/',
                'is_pro' => true
            ],
            [
                'key'    => 'woo-collections',
                'title'  => __( 'Woo Product Collections', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/woocommerce-product-collections/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/ea-woo-product-collections/',
                'is_pro' => true
            ],
            [
                'key'    => 'content-timeline',
                'title'  => __( 'Content Timeline', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/content-timeline/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/content-timeline/',
                'is_pro' => true
            ],
            [
                'key'    => 'dynamic-filter-gallery',
                'title'  => __( 'Dynamic Gallery', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/filterable-gallery/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/dynamic-filterable-gallery/',
                'is_pro' => true
            ]
        ]
    ],
    'creative-elements' => [
        'title' => __( 'Creative Elements', 'essential-addons-elementor' ),
        'elements'  => [
            [
                'key'   => 'count-down',
                'title' => __( 'Count Down', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/countdown/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/countdown/',
            ],
            [
                'key'   => 'fancy-text',
                'title' => __( 'Fancy Text', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/fancy-text/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/fancy-text/',
            ],
            [
                'key'   => 'filter-gallery',
                'title' => __( 'Filterable Gallery', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/filterable-gallery/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/filterable-gallery/',
            ],
            [
                'key'    => 'image-accordion',
                'title'  => __( 'Image Accordion', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/image-accordion/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/image-accordion/',
            ],
            [
                'key'   => 'progress-bar',
                'title' => __( 'Progress Bar', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/progress-bar/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/progress-bar/',
            ],
            [
                'key'    => 'interactive-promo',
                'title'  => __( 'Interactive Promo', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/interactive-promo/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/interactive-promo/',
                'is_pro' => true
            ],
            [
                'key'    => 'counter',
                'title'  => __( 'Counter', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/counter/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/counter/',
                'is_pro' => true
            ],
            [
                'key'    => 'lightbox',
                'title'  => __( 'Lightbox & Modal', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/lightbox-modal/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/lightbox-modal/',
                'is_pro' => true
            ],
            [
                'key'    => 'protected-content',
                'title'  => __( 'Protected Content', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/protected-content/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/ea-protected-content/',
                'is_pro' => true
            ],
            [
                'key'    => 'img-comparison',
                'title'  => __( 'Image Comparison', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/image-comparison/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/image-comparison/',
                'is_pro' => true
            ],
            [
                'key'    => 'flip-carousel',
                'title'  => __( 'Flip Carousel', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/flip-carousel/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/flip-carousel/',
                'is_pro' => true
            ],
            [
                'key'    => 'logo-carousel',
                'title'  => __( 'Logo Carousel', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/logo-carousel/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/logo-carousel/',
                'is_pro' => true
            ],
            [
                'key'    => 'interactive-cards',
                'title'  => __( 'Interactive Cards', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/interactive-cards/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/interactive-cards/',
                'is_pro' => true
            ],
            [
                'key'    => 'one-page-navigation',
                'title'  => __( 'One Page Navigation', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/one-page-nav/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/one-page-navigation/',
                'is_pro' => true
            ],
            [
                'key'    => 'image-hotspots',
                'title'  => __( 'Image Hotspots', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/image-hotspots/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/image-hotspots/',
                'is_pro' => true
            ],
            [
                'key'    => 'divider',
                'title'  => __( 'Divider', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/divider/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/divider/',
                'is_pro' => true
            ],
            [
                'key'    => 'image-scroller',
                'title'  => __( 'Image Scroller', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/image-scroller/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/ea-image-scroller/',
                'is_pro' => true
            ]
        ]
    ],
    'marketing-elements'    => [
        'title' => __( 'Marketing Elements', 'essential-addons-elementor' ),
        'elements'  => [
            [
                'key'   => 'call-to-action',
                'title' => __( 'Call To Action', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/call-to-action/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/call-to-action/',
            ],
            [
                'key'   => 'price-table',
                'title' => __( 'Pricing Table', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/pricing-table/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/pricing-table/',
            ],
            [
                'key'    => 'price-menu',
                'title'  => __( 'Price menu', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/price-menu/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/price-menu/',
                'is_pro' => true
            ]
        ]
    ],
    'form-styler-elements'  => [
        'title' => __( 'Form Styler Elements', 'essential-addons-elementor' ),
        'elements'  => [
            [
                'key'   => 'contact-form-7',
                'title' => __( 'Contact Form 7', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/contact-form-7/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/contact-form-7/',
            ],
            [
                'key'   => 'weforms',
                'title' => __( 'weForms', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/weforms/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/weforms/',
            ],
            [
                'key'   => 'ninja-form',
                'title' => __( 'Ninja Form', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/ninja-forms/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/ninja-forms/',
            ],
            [
                'key'   => 'gravity-form',
                'title' => __( 'Gravity Form', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/gravity-forms/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/gravity-forms/',
            ],
            [
                'key'   => 'caldera-form',
                'title' => __( 'Caldera Form', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/caldera-forms/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/caldera-forms/',
            ],
            [
                'key'   => 'wpforms',
                'title' => __( 'WPForms', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/wpforms/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/wpforms/',
            ],
            [
                'key'   => 'fluentform',
                'title' => __( 'FluentForm', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/fluentform/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/fluentform/',
            ],
            [
                'key'    => 'mailchimp',
                'title'  => __( 'Mailchimp', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/mailchimp/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/mailchimp/',
                'is_pro' => true
            ]
        ]
    ],
    'social-feed-elements'  => [
        'title' => __( 'Social Feed Elemens', 'essential-addons-elementor' ),
        'elements'  => [
            [
                'key'   => 'twitter-feed',
                'title' => __( 'Twitter Feed', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/twitter-feed/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/twitter-feed/',
            ],
            [
                'key'    => 'twitter-feed-carousel',
                'title'  => __( 'Twitter Feed Carousel', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/twitter-feed/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/twitter-feed-carousel/',
                'is_pro' => true
            ],
            [
                'key'    => 'instagram-gallery',
                'title'  => __( 'Instagram Feed', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/instagram-feed/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/instagram-feed/',
                'is_pro' => true
            ],
        ]
    ],
    'learn-dash-elements'   => [
        'title' => __( 'LearnDash Elements', 'essential-addons-elementor' ),
        'elements'  => [
            [
                'key'   => 'learn-dash-course-list',
                'title' => __( 'LearnDash Course List', 'essential-addons-elementor' ),
                'demo_link' => 'https://essential-addons.com/elementor/learndash-course-list/',
                'doc_link' => 'https://essential-addons.com/elementor/docs/learndash-course-list/',
                'is_pro' => true
            ]
        ]
    ]
];

$elements = apply_filters( 'add_eael_elementor_addons', $elements );

?>
<div id="elements" class="eael-settings-tab eael-elements-list">
    <div class="row">
        <div class="col-full">
            <div class="elements-global-control-wrap">
                <h4><?php _e('Global Control') ?></h4>
                <p><?php _e('Use the Buttons to Activate or Deactivate all the Elements of Essential Addons at once.') ?></p>

                <div class="eael-btn-group">
                    <button type="button" class="eael-btn eael-global-control-enable"><?php _e('Enable All') ?></button>
                    <button type="button" class="eael-btn eael-global-control-disable"><?php _e('Disable All') ?></button>
                </div>
            </div>
            <?php foreach($elements as $element) : ?>
                <?php echo !empty($element['title']) ? '<h4>'.$element['title'].'</h4>' : ''; ?>

                <div class="eael-checkbox-container">
                    <?php
                        foreach($element['elements'] as $item) {
                            $status = isset($item['is_pro']) && !$this->pro_enabled ? 'disabled' : checked( 1, $this->get_settings($item['key']), false );
                            $label_class = isset($item['is_pro']) && !$this->pro_enabled ? 'eael-get-pro' : '';
                            $class = isset($item['class']) ? ' '.$item['class'] : '';
                        ?>
                        <div class="eael-checkbox<?php echo $class; ?>">
                            <div class="eael-elements-info">
                                <p class="eael-el-title">
                                    <?php _e( $item['title'], 'essential-addons-elementor' ) ?>
                                    <?php echo isset( $item['is_pro'] ) && !$this->pro_enabled ? '<sup class="pro-label">'.__('Pro', 'essential-addons-elementor').'</sup>' : ''; ?>
                                    <?php
                                        if ($item['key'] === 'mailchimp' && $this->pro_enabled) {
                                            echo '<span style="font-size: 12px; font-style:italic;"><a href="#" class="eael-admin-settings-popup" data-title="Mailchimp API Key" data-placeholder="Set API Key" data-target="#mailchimp-api">'.__('Settings', 'essential-addons-elementor').'</a></span>
                                            <input type="hidden" name="mailchimp-api" id="mailchimp-api" class="mailchimp-api" placeholder="Set API Key" value="' . get_option('eael_save_mailchimp_api') . '">';
                                        } elseif($item['key'] === 'adv-google-map' && $this->pro_enabled) {
                                            echo '<span style="font-size: 12px; font-style:italic;"><a href="#" class="eael-admin-settings-popup" data-title="Google Map API Key" data-placeholder="Set API Key" data-target="#google-map-api">'.__('Settings', 'essential-addons-elementor').'</a></span>
                                            <input type="hidden" name="google-map-api" id="google-map-api" class="google-map-api" value="' . get_option('eael_save_google_map_api') . '">';
                                        }
                                    ?>
                                </p>
                                <a  class="eael-element-info-link" href="<?php echo ($item['demo_link']);?>" target="_blank">
                                    <span class="dashicons dashicons-welcome-view-site"></span>
                                    <span class="eael-info-tooltip"><?php _e('Demo', 'essential-addons-elementor'); ?></span>
                                </a>
                                <a class="eael-element-info-link" href="<?php echo ($item['doc_link']);?>" target="_blank">
                                    <span class="dashicons dashicons-editor-help"></span>
                                    <span class="eael-info-tooltip"><?php _e('Documentation', 'essential-addons-elementor'); ?></span>
                                </a>
                            </div>
                            <input type="checkbox" id="<?php echo esc_attr($item['key']); ?>" name="<?php echo esc_attr($item['key']); ?>" <?php echo $status; ?>>
                            <label for="<?php echo esc_attr($item['key']); ?>" class="<?php echo $label_class; ?>"></label>
                        </div>
                    <?php } ?>
                </div>
            <?php endforeach; ?>

            <div class="eael-save-btn-wrap">
                <button type="submit" class="button eael-btn js-eael-settings-save"><?php _e('Save settings', 'essential-addons-elementor'); ?></button>
            </div>
        </div>
    </div>
</div>