<?php
if (!defined('ABSPATH'))
    exit;
/**
 * Main class
 *
 */
if (!class_exists('gpls_woo_rfq_plus_product_email_message_meta')) {

    class gpls_woo_rfq_plus_product_email_message_meta
    {
        public static function init()
        {



            add_action( 'woocommerce_product_options_advanced', array(__CLASS__, 'gpls_woo_rfq_plus_add_custom_general_fields' ),10,0);

// Save Fields
            add_action( 'woocommerce_process_product_meta', array(__CLASS__,'gpls_woo_rfq_plus_add_custom_general_fields_save' ),10,1);

        }



        public static function gpls_woo_rfq_plus_add_custom_general_fields() {

            global $woocommerce, $post;



            woocommerce_wp_checkbox(
                array(
                    'id' => '_gpls_woo_rfq_no_add_to_cart',
                    'label' => __( 'Hide Add To Cart for this product. Normal Checkout', 'rfqtk' ),
                    'placeholder' => 'Hide Add To Cart Button for this product',
                    'desc_tip' => 'true',
                    'description' => __( "Use when prices are showing in normal checkout and you want to restrict to adding to quote only.", 'rfqtk' ),

                ));

            woocommerce_wp_checkbox(
                array(
                    'id' => '_gpls_woo_rfq_hide_price',
                    'label' => __( 'Hide price for this product.', 'rfqtk' ),
                    'placeholder' => 'Hide price for this product',
                    'desc_tip' => 'true',
                    'description' => __( "Use when prices are showing in normal checkout and prices are zero.", 'rfqtk' ),

                ));


            woocommerce_wp_checkbox(
                array(
                    'id' => '_gpls_woo_rfq_plus_show_product_email_message',
                    'label' => __( 'Show the message below in confirmation email.', 'rfqtk' ),
                    'placeholder' => '',
                    'desc_tip' => 'true',
                    'class'       =>'gpls_woo_plus_no_wrap',
                    'description' => __( "Include this message in email messages after submitting quote request.", 'rfqtk' ),


                ));



            gpls_woo_rfq_plus_wp_html_editor_input(
                array(
                    'id'          => '_gpls_woo_rfq_plus_product_email_message',
                    'label'       => __( 'Product specific Email message', 'rfqtk' ),
                    'placeholder' => 'Get More Info',
                    'desc_tip'    => 'true',
                    'class'       =>'gpls_woo_plus_htm_editor_product',
                    'description' => __('Product specific message to be sent to the customer in confirmation emails to customers. It is appended to the end of the email.', 'rfqtk')
                )
            );


        }

        public static function gpls_woo_rfq_plus_add_custom_general_fields_save( $post_id ){



            if(isset($_POST['_gpls_woo_rfq_plus_product_email_message'])) {

                    update_post_meta($post_id, '_gpls_woo_rfq_plus_product_email_message', $_POST['_gpls_woo_rfq_plus_product_email_message']);

            }

            if(isset($_POST['_gpls_woo_rfq_plus_show_product_email_message'])) {

                update_post_meta($post_id, '_gpls_woo_rfq_plus_show_product_email_message', 'yes');

            }else{
                update_post_meta($post_id, '_gpls_woo_rfq_plus_show_product_email_message', 'no');
            }



            if(isset($_POST['_gpls_woo_rfq_no_add_to_cart'])) {

                update_post_meta($post_id, '_gpls_woo_rfq_no_add_to_cart', 'yes');

            }else{
                update_post_meta($post_id, '_gpls_woo_rfq_no_add_to_cart', 'no');
            }

            if(isset($_POST['_gpls_woo_rfq_hide_price'])) {

                update_post_meta($post_id, '_gpls_woo_rfq_hide_price', 'yes');

            }else{
                update_post_meta($post_id, '_gpls_woo_rfq_hide_price', 'no');
            }




        }


    }
}
