<?php
if (!defined('ABSPATH'))
    exit;

/**
 * Created by PhpStorm.
 * Author: GPLSAVER
 * Date: 1/27/2016
 * Time: 4:07 PM
 */
class GPLS_Woo_RFQ_PLUS_Settings
{

    /**
     * Constructor for the settings.
     */

    /**
     * Bootstraps the class and hooks required actions & filters.
     *
     */
    public static function init()
    {
        add_filter('woocommerce_get_sections_settings_gpls_woo_rfq', array(__CLASS__, 'gpls_woo_rfq_plus_get_sections'), 100, 1);

        add_filter('wc_settings_gpls_woo_rfq_settings', array(__CLASS__, 'gpls_woo_rfq_plus_get_settings'), 100, 2);


        add_action('woocommerce_admin_field_gpls_woo_html_editor', array(__CLASS__, 'gpls_woo_rfq_plus_admin_field_html_editor'), 10, 1);

        add_action('woocommerce_admin_field_gpls_woo_text_area', array(__CLASS__, 'gpls_woo_rfq_plus_admin_text_area_field'), 10, 1);

        add_action('woocommerce_admin_field_gpls_woo_chkbox_list', array(__CLASS__, 'gpls_woo_rfq_plus_admin_chkbox_list_field'), 10, 1);

        add_action('woocommerce_admin_field_gpls_woo_chkbox_roles', array(__CLASS__, 'gpls_woo_rfq_plus_admin_chkbox_roles'), 10, 1);

        add_action('woocommerce_admin_field_gpls_woo_chkbox_prod_marketing_list', array(__CLASS__, 'gpls_woo_rfq_plus_admin_chkbox_prod_marketing_list'), 10, 1);

        add_action('woocommerce_admin_field_gpls_woo_chkbox_prod_marketing_content_list', array(__CLASS__, 'gpls_woo_chkbox_prod_marketing_content_list'), 10, 1);


        add_filter('woocommerce_admin_settings_sanitize_option', array(__CLASS__, 'gpls_woo_rfq_plus_admin_field_validator'), 10, 3);

        add_filter('woocommerce_settings_tabs_array', array(__CLASS__, 'add_settings_tab'), 1000);

        add_action('woocommerce_admin_field_auction_gpls_woo_html_editor', array(__CLASS__, 'gpls_woo_rfq_plus_admin_field_html_editor'), 10, 1);

        add_action('woocommerce_admin_field_gpls_woo_prod_marketing_by_category', array(__CLASS__, 'gpls_woo_rfq_gpls_woo_prod_marketing_by_category'), 10, 1);


    }


    public static function add_settings_tab($settings_tabs)
    {
        $settings_tabs['settings_gpls_woo_rfq'] = 'RFQ-ToolKit';
        return $settings_tabs;
    }

    public static function gpls_woo_rfq_get_cats()
    {


        $orderby = 'name';
        $order = 'asc';
        $hide_empty = false;
        $cat_args = array(
            'orderby' => $orderby,
            'order' => $order,
            'hide_empty' => $hide_empty,
        );

        $cats = get_terms('product_cat', $cat_args);

        //  d($cats);

        $option = array();

        $first_option = '';

        $home = '';


        $option[$home] = $first_option;

        foreach ($cats as $key => $pagg) {
            $label = $pagg->name;
            if (trim($label) == '') continue;
            $option[$label] = $label;
        }

        return $option;

    }

    public static function gpls_woo_rfq_get_roles()
    {


        $orderby = 'name';
        $order = 'asc';
        $hide_empty = false;
        $cat_args = array(
            'orderby' => $orderby,
            'order' => $order,
            'hide_empty' => $hide_empty,
        );

        // $cats = get_terms('product_cat', $cat_args);


        global $wp_roles;

        $all_roles = $wp_roles->roles;
        $cats = apply_filters('editable_roles', $all_roles);

        $option = array();

        $first_option = '';

        $home = '';


        $option[$home] = $first_option;

        foreach ($cats as $key => $pagg) {

            $option[$key] = $key;
        }

        return $option;

    }

    public static function gpls_woo_rfq_plus_admin_field_validator($value, $option, $raw_value)
    {
        if ($option['type'] == 'gpls_woo_html_editor') {
            $value = $raw_value;
        }

        if ($option['id'] == 'settings_gpls_woo_rfq_plus_normal_checkout') {

            if (!isset($_POST['settings_gpls_woo_rfq_show_prices']) && !isset($_POST['settings_gpls_woo_rfq_show_prices_everywhere'])
                && isset($_POST['settings_gpls_woo_rfq_plus_normal_checkout'])) {

                add_action('admin_notices', gpls_woo_rfq_plus_admin_functions::gpls_woo_rfq_plus_error_notice("price_hidden_with_normal_gateways"));

                $value = 'no';
            }

        }

        if ($option['id'] == 'settings_gpls_woo_rfq_bulk_rfq_enable') {

            if ($value == 'no') {
                $args = array(
                    'post_type' => array('product', 'product_variation'),
                    'post_status' => 'publish',
                    'posts_per_page' => -1,


                );

                $the_query = new WP_Query($args);

                while ($the_query->have_posts()) : $the_query->the_post();

                    delete_post_meta(get_the_ID(), "_gpls_woo_rfq_rfq_enable", 'yes');
                    delete_post_meta(get_the_ID(), "_gpls_woo_rfq_rfq_enable", 'no');

                endwhile;

                wp_reset_query();
                add_action('admin_notices', gpls_woo_rfq_plus_admin_functions::gpls_woo_rfq_plus_error_notice("gpls_woo_rfq_rfq_enable_reset"));

            }


            if ($value == 'yes') {
                $args = array(
                    'post_type' => array('product', 'product_variation'),
                    'post_status' => 'publish',
                    'posts_per_page' => -1,

                );

                $the_query = new WP_Query($args);

                while ($the_query->have_posts()) : $the_query->the_post();

                    update_post_meta(get_the_ID(), "_gpls_woo_rfq_rfq_enable", 'yes');

                endwhile;

                wp_reset_query();

                add_action('admin_notices', gpls_woo_rfq_plus_admin_functions::gpls_woo_rfq_plus_error_notice("gpls_woo_rfq_rfq_enable_reset"));
            }


            $value = '';
        }


        if ($option['id'] == 'settings_gpls_woo_rfq_bulk_rfq_enable_in_cat') {


            if (isset($_POST['cats'])) {
                $cats = (array)$_POST['cats'];
            } else {
                $cats = array();
            }


            if ($value == 'yes') {

                $args = array(
                    'post_type' => array('product', 'product_variation'),
                    'post_status' => 'publish',
                    'posts_per_page' => -1,


                );

                $the_query = new WP_Query($args);

                while ($the_query->have_posts()) : $the_query->the_post();

                    delete_post_meta(get_the_ID(), "_gpls_woo_rfq_rfq_enable", 'yes');
                    delete_post_meta(get_the_ID(), "_gpls_woo_rfq_rfq_enable", 'no');

                endwhile;

                wp_reset_query();

                foreach ($cats as $cat) {

                    $args = array(
                        'post_type' => array('product', 'product_variation'),
                        'post_status' => 'publish',
                        'posts_per_page' => -1,
                        'product_cat' => $cat
                    );

                    $the_query = new WP_Query($args);

                    while ($the_query->have_posts()) : $the_query->the_post();

                        update_post_meta(get_the_ID(), "_gpls_woo_rfq_rfq_enable", 'yes');

                    endwhile;

                    wp_reset_query();
                }

                add_action('admin_notices', gpls_woo_rfq_plus_admin_functions::gpls_woo_rfq_plus_error_notice("gpls_woo_rfq_rfq_enable_reset"));
            }

            $value = '';


        }




        if ($option['id'] == 'settings_gpls_woo_rfq_bulk_hide_add_to_cart_cat') {


            if (isset($_POST['cats'])) {
                $cats = (array)$_POST['cats'];
            } else {
                $cats = array();
            }


            if ($value == 'yes') {

                $args = array(
                    'post_type' => array('product', 'product_variation'),
                    'post_status' => 'publish',
                    'posts_per_page' => -1,


                );

                $the_query = new WP_Query($args);

                while ($the_query->have_posts()) : $the_query->the_post();

                    delete_post_meta(get_the_ID(), "_gpls_woo_rfq_no_add_to_cart", 'yes');
                    delete_post_meta(get_the_ID(), "_gpls_woo_rfq_no_add_to_cart", 'no');

                endwhile;

                wp_reset_query();

                foreach ($cats as $cat) {

                    $args = array(
                        'post_type' => array('product', 'product_variation'),
                        'post_status' => 'publish',
                        'posts_per_page' => -1,
                        'product_cat' => $cat
                    );

                    $the_query = new WP_Query($args);

                    while ($the_query->have_posts()) : $the_query->the_post();

                        update_post_meta(get_the_ID(), "_gpls_woo_rfq_no_add_to_cart", 'yes');

                    endwhile;

                    wp_reset_query();
                }

                add_action('admin_notices', gpls_woo_rfq_plus_admin_functions::gpls_woo_rfq_plus_error_notice("gpls_woo_rfq_rfq_enable_reset"));
            }

            $value = '';


        }




        if ($option['id'] == 'settings_gpls_woo_rfq_bulk_hide_price_cat') {


            if (isset($_POST['cats'])) {
                $cats = (array)$_POST['cats'];
            } else {
                $cats = array();
            }


            if ($value == 'yes') {

                $args = array(
                    'post_type' => array('product', 'product_variation'),
                    'post_status' => 'publish',
                    'posts_per_page' => -1,


                );

                $the_query = new WP_Query($args);

                while ($the_query->have_posts()) : $the_query->the_post();

                    delete_post_meta(get_the_ID(), "_gpls_woo_rfq_hide_price", 'yes');
                    delete_post_meta(get_the_ID(), "_gpls_woo_rfq_hide_price", 'no');

                endwhile;

                wp_reset_query();

                foreach ($cats as $cat) {

                    $args = array(
                        'post_type' => array('product', 'product_variation'),
                        'post_status' => 'publish',
                        'posts_per_page' => -1,
                        'product_cat' => $cat
                    );

                    $the_query = new WP_Query($args);

                    while ($the_query->have_posts()) : $the_query->the_post();

                        update_post_meta(get_the_ID(), "_gpls_woo_rfq_hide_price", 'yes');

                    endwhile;

                    wp_reset_query();
                }

                add_action('admin_notices', gpls_woo_rfq_plus_admin_functions::gpls_woo_rfq_plus_error_notice("gpls_woo_rfq_rfq_enable_reset"));
            }

            $value = '';


        }


        if ($option['id'] == 'settings_gpls_woo_rfq_cats_new_prods') {
            $value = '';
            if (isset($_POST['cats'])) {
                $cats = $_POST['cats'];
                $value = implode(',', $cats);
            }
        }


        if ($option['id'] == 'settings_gpls_woo_rfq_bulk_rfq_enable_product_messages') {

            if (isset($_POST['marketing_cats'])) {
                $cats = (array)$_POST['marketing_cats'];
            } else {
                $cats = array();
            }


            if ($value == 'yes') {

                $args = array(
                    'post_type' => array('product', 'product_variation'),
                    'post_status' => 'publish',
                    'posts_per_page' => -1,

                );

                $the_query = new WP_Query($args);

                while ($the_query->have_posts()) : $the_query->the_post();

                    delete_post_meta(get_the_ID(), "_gpls_woo_rfq_plus_show_product_email_message", 'yes');
                    delete_post_meta(get_the_ID(), "_gpls_woo_rfq_plus_show_product_email_message", 'no');

                endwhile;

                wp_reset_query();

                foreach ($cats as $cat) {

                    $args = array(
                        'post_type' => array('product', 'product_variation'),
                        'post_status' => 'publish',
                        'posts_per_page' => -1,
                        'product_cat' => $cat
                    );

                    $the_query = new WP_Query($args);

                    while ($the_query->have_posts()) : $the_query->the_post();

                        update_post_meta(get_the_ID(), "_gpls_woo_rfq_plus_show_product_email_message", 'yes');

                    endwhile;

                    wp_reset_query();
                }

                add_action('admin_notices', gpls_woo_rfq_plus_admin_functions::gpls_woo_rfq_plus_error_notice("gpls_woo_rfq_bulk_rfq_enable_product_messages"));
            }

            $value = '';

        }


        if ($option['id'] == 'settings_gpls_woo_rfq_cats_new_enable_product_messages') {
            $value = '';
            if (isset($_POST['marketing_cats'])) {
                $cats = $_POST['marketing_cats'];
                $value = implode(',', $cats);
            }
        }


        if ($option['id'] == 'settings_gpls_woo_rfq_bulk_rfq_update_product_messages') {

            if (isset($_POST['marketing_content_cats'])) {
                $cats = (array)$_POST['marketing_content_cats'];
            } else {
                $cats = array();
            }


            if ($value == 'yes') {

                $settings_gpls_woo_prod_marketing_by_category_array = get_option('settings_gpls_woo_prod_marketing_by_category_array', array());

                $args = array(
                    'post_type' => array('product', 'product_variation'),
                    'post_status' => 'publish',
                    'posts_per_page' => -1,


                );

                $the_query = new WP_Query($args);

                while ($the_query->have_posts()) : $the_query->the_post();

                    // delete_post_meta(get_the_ID(), "_gpls_woo_rfq_plus_product_email_message");
                endwhile;

                wp_reset_query();

                foreach ($cats as $cat) {

                    $args = array(
                        'post_type' => array('product', 'product_variation'),
                        'post_status' => 'publish',
                        'posts_per_page' => -1,
                        'product_cat' => $cat
                    );

                    $the_query = new WP_Query($args);

                    while ($the_query->have_posts()) : $the_query->the_post();
                        update_post_meta(get_the_ID(), "_gpls_woo_rfq_plus_product_email_message", $_POST['settings_gpls_woo_rfq_customer_product_message_content']);

                        $settings_gpls_woo_prod_marketing_by_category_array[$cat] = $_POST['settings_gpls_woo_rfq_customer_product_message_content'];

                    endwhile;

                    wp_reset_query();
                }

                update_option('settings_gpls_woo_prod_marketing_by_category_array', $settings_gpls_woo_prod_marketing_by_category_array);

                add_action('admin_notices', gpls_woo_rfq_plus_admin_functions::gpls_woo_rfq_plus_error_notice("gpls_woo_rfq_bulk_rfq_enable_product_messages"));
            }

            $value = '';

        }


        if ($option['id'] == 'settings_gpls_woo_rfq_cats_new_update_product_messages') {
            $value = '';
            if (isset($_POST['marketing_content_cats'])) {
                $cats = $_POST['marketing_content_cats'];
                $value = implode(',', $cats);
            }
        }


        if ($option['id'] == 'settings_gpls_woo_rfq_plus_visible_price_roles') {
            $value = '';
            if (isset($_POST['cats_roles'])) {
                $cats = $_POST['cats_roles'];
                $value = implode(',', $cats);
            }
        }

        if ($option['id'] == 'settings_gpls_woo_rfq_delay_quote_hours') {
            if (!is_numeric($value)) {
                //  add_action('admin_notices', gpls_woo_rfq_plus_admin_functions::gpls_woo_rfq_plus_error_notice("Delay for sending quote"));
                $value = '';
            }
        }


        if ($option['id'] == 'settings_gpls_woo_prod_marketing_by_category') {

            $value = get_option('settings_gpls_woo_prod_marketing_by_category_array');
        }

        return $value;

    }

    public static function gpls_woo_rfq_plus_admin_chkbox_roles($value)
    {

        $option_value = get_option($value['id'], $value['default']);
        $cats = GPLS_Woo_RFQ_PLUS_Settings::gpls_woo_rfq_get_roles();

        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $value['id']; ?>"><?php echo esc_html($value['title']); ?></label><br/>
            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <ul>
                    <?php

                    $option_value_list = explode(',', $option_value);

                    foreach ($cats as $cat) {
                        if (trim($cat) == '') continue;

                        if (in_array($cat, $option_value_list)) {
                            echo "<li><input type='checkbox' name='cats_roles[]' value='$cat' checked/>$cat</li>";
                        } else {
                            echo "<li><input type='checkbox' name='cats_roles[]' value='$cat' />$cat</li>";
                        }

                    }
                    ?>
                </ul>

                <?php echo $value['desc']; ?>
            </td>
        </tr>
        <?php


    }

    public static function gpls_woo_rfq_plus_admin_chkbox_prod_marketing_list($value)
    {


        $option_value = get_option($value['id'], $value['default']);
        $cats = GPLS_Woo_RFQ_PLUS_Settings::gpls_woo_rfq_get_cats();

        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $value['id']; ?>"><?php echo esc_html($value['title']); ?></label><br/>
            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <ul>
                    <?php

                    $option_value_list = explode(',', $option_value);

                    foreach ($cats as $cat) {
                        if (trim($cat) == '') continue;

                        if (in_array($cat, $option_value_list)) {
                            echo "<li><input type='checkbox' name='marketing_cats[]' value='$cat' checked/>$cat</li>";
                        } else {
                            echo "<li><input type='checkbox' name='marketing_cats[]' value='$cat' />$cat</li>";
                        }

                    }
                    ?>
                </ul>

                <?php echo $value['desc']; ?>
            </td>
        </tr>
        <?php


    }


    public static function gpls_woo_chkbox_prod_marketing_content_list($value)
    {


        $option_value = get_option($value['id'], $value['default']);
        $cats = GPLS_Woo_RFQ_PLUS_Settings::gpls_woo_rfq_get_cats();

        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $value['id']; ?>"><?php echo esc_html($value['title']); ?></label><br/>
            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <ul>
                    <?php

                    $option_value_list = explode(',', $option_value);

                    foreach ($cats as $cat) {
                        if (trim($cat) == '') continue;

                        if (in_array($cat, $option_value_list)) {
                            echo "<li><input type='checkbox' name='marketing_content_cats[]' value='$cat' checked/>$cat</li>";
                        } else {
                            echo "<li><input type='checkbox' name='marketing_content_cats[]' value='$cat' />$cat</li>";
                        }

                    }
                    ?>
                </ul>

                <?php echo $value['desc']; ?>
            </td>
        </tr>
        <?php


    }

    public static function gpls_woo_rfq_plus_admin_chkbox_list_field($value)
    {


        $option_value = get_option($value['id'], $value['default']);
        $cats = GPLS_Woo_RFQ_PLUS_Settings::gpls_woo_rfq_get_cats();

        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $value['id']; ?>"><?php echo esc_html($value['title']); ?></label><br/>
            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <ul>
                    <?php

                    $option_value_list = explode(',', $option_value);

                    foreach ($cats as $cat) {
                        if (trim($cat) == '') continue;

                        if (in_array($cat, $option_value_list)) {
                            echo "<li><input type='checkbox' name='cats[]' value='$cat' checked/>$cat</li>";
                        } else {
                            echo "<li><input type='checkbox' name='cats[]' value='$cat' />$cat</li>";
                        }

                    }
                    ?>
                </ul>

                <?php echo $value['desc']; ?>
            </td>
        </tr>
        <?php


    }


    public static function gpls_woo_rfq_plus_admin_text_area_field($value)
    {


        $option_value = get_option($value['id'], $value['default']);

        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $value['id']; ?>"><?php echo esc_html($value['title']); ?></label><br/>
            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <textarea style="<?php echo $value['css']; ?>" name="<?php echo $value['id']; ?>"
                          id="<?php echo $value['id']; ?>"><?php echo esc_textarea($option_value); ?></textarea><br/>
                <?php echo $value['desc']; ?>
            </td>
        </tr>
        <?php
    }


    public static function gpls_woo_rfq_gpls_woo_prod_marketing_by_category($value)
    {

        $description = '<div >' . $value['desc'] . '</div><br /><div><br /></div>';
        $option_value = WC_Admin_Settings::get_option($value['id'], $value['default']);

        ?>

        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo esc_attr($value['id']); ?>"><?php echo esc_html($value['title']); ?></label>

            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <?php echo $description; ?>

                <?php
                foreach ($option_value as $cat => $html) {
                    echo '<h3>' . $cat . '</h3>';
                    echo '<div>' . $html . '</div>';
                }
                ?>

            </td>
        </tr>

        <?php


    }


    public static function gpls_woo_rfq_plus_admin_field_html_editor($value)
    {


        $description = '<div >' . $value['desc'] . '</div><br /><div><br /></div>';
        $option_value = WC_Admin_Settings::get_option($value['id'], $value['default']);
        ?>

        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo esc_attr($value['id']); ?>"><?php echo esc_html($value['title']); ?></label>

            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <?php echo $description; ?>

                <?php

                $settings = array(
                    'tabindex' => 1,
                    'textarea_rows' => $value['textarea_rows'],
                    'textarea_name' => esc_attr($value['id']),
                );

                //wp_editor($option_value, $value['id'], $settings);
                wp_editor($option_value, $value['id'], $settings);

                ?>

            </td>
        </tr>
        <?php
    }

    public static function gpls_woo_rfq_plus_get_sections($sections)
    {

        return gpls_woo_get_sections($sections);

    }


    public static function gpls_woo_rfq_plus_get_settings($settings, $section)
    {
        switch ($section) {


            case '' :
                //$settings =
                $settings =
                    array(
                        'general_section_title' => array(
                            'name' => __('RFQ-ToolKit General Options', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('RFQ-ToolKit general options ', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_general_section_title'
                        ),
                        'checkout_option' => array(
                            'name' => '1- ' . __('Checkout Option', 'rfqtk'),
                            'type' => 'select',
                            'options' => array(
                                'normal_checkout' => __('Normal Checkout', 'rfqtk'),
                                'rfq' => __('RFQ', 'rfqtk')),
                            'desc' => '<h4>' .
                                __('RFQ turns WooCommerce shopping cart into a request for quote. In premium version there are additional options to buy or request a quote the whole cart at WooCommerce checkout.<br />RFQ option provides very high compatibility with other third party plugins and products. Normal option allows checking out normally or request a quote using a quote cart.', 'rfqtk') .
                                '</h4><h4>' . __('Normal Checkout: If normal checkout, prices will be shown except for selected products (managed in product setup-advanced tab) and customer can only inquire about the products that you specify in product setup in the advanced tab.<br />
<br>RFQ Checkout: In RFQ mode the plugin is integrated with the WooCommerce cart and the entire cart is submitted as a quote request.<br /> All the prices are hidden and at checkout the option is to submit a quote request.<br />', 'rfqtk') . '</h4>',

                            'default' => 'normal_checkout',
                            'id' => 'settings_gpls_woo_rfq_checkout_option'
                        ),

                        'settings_gpls_woo_rfq_show_prices' => array(
                            'name' => '2- ' . __('Always Show Product Prices With RFQ Checkout', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Applicable to RFQ checkout option only.<br /> Prices are shown for products but checkout is still a request for quote. Premium version show prices in the email and thank you page also.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_show_prices'
                        ),

                        'settings_gpls_woo_rfq_normal_checkout_show_prices' => array(
                            'name' => '3- ' . __('Show Prices With Normal Checkout', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Applicable to normal checkout option only.<br /> Prices are shown on the site but customer can inquire or checkout with selected products.< br />
                            This allows customers to checkout using the published prices or to request a personalized quote.  Premium version show prices in the email and thank you page also', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_normal_checkout_show_prices'
                        ),
                        'settings_gpls_woo_rfq_global_no_add_to_cart' => array(
                            'name' => '3a- ' . __('Normal Checkout: Hide Add To Cart. Show Only Add To Quote', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Applicable to normal checkout option only.<br />Hide the Add to cart button for all quote items. Even when prices are showing', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_global_no_add_to_cart'
                        ),

                        'settings_gpls_woo_rfq_hide_visitor_prices' => array(
                            'name' => '4- ' . __('Hide Prices from Visitors For Quote Request', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Hide Prices From Visitor. Visitors who are not logged in can only submit a quotes request. <br />.Enable guest checkout so the customers can submit requests as guest', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_hide_visitor_prices'
                        ),


                        'general_section_end345' => array(
                            'type' => 'sectionend',
                            'id' => 'settings_gpls_woo_rfq_general_section_end345'
                        )
                    ,

                        'general_section_end33552' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section_end33552'
                        ),

                        'general_section233553_title' => array(
                            'name' => __('==============================================================================================================', 'rfqtk'),
                            'type' => 'title',

                            'id' => 'general_section233553_title'
                        ),

                        'general_section300_title' => array(
                            'name' => __('Enable role based price visibility and checkout options at checkout', 'rfqtk'),
                            'type' => 'title',

                            'id' => 'settings_gpls_woo_rfq_general_section3_title'
                        ),

                        'settings_gpls_woo_rfq_plus_role_based_visible' => array(
                            'name' => '4a- ' . __('RFQ Checkout: Enable role based price visibility and checkout options at checkout', 'rfqtk'),
                            'type' => 'select',
                            'options' => array(
                                'no' => '',
                                'purchase' => __('1: Selected roles can view prices and purchase in option 5. Others can only request a quote', 'rfqtk'),
                                'others_purchase_only' => __('2: Selected roles can view prices and purchase in option 5. Others can only purchase', 'rfqtk')),
                            'desc' => "<br /><br />" . __('option 1: Only selected roles can view prices. Also, only selected roles can purchase at checkout when using Option 5-buy now or request a quote. Other roles cannot view prices and can only request a quote at checkout.<br /><br />option 2: Only selected roles can request a quote when using Option 5-buy now or request a quote.<br />Other roles can view prices and can only purchase at checkout.<br /><br />Roles do not affect Option 5C "Buy Or Request based on items in the cart"', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_plus_role_based_visible'
                        ),


                        'settings_gpls_woo_rfq_plus_visible_price_roles' => array(
                            'name' => '4b- ' . __('RFQ Checkout: Select roles that can view prices.', 'rfqtk'),
                            'type' => 'gpls_woo_chkbox_roles',
                            'desc' => __('Roles that can view prices', 'rfqtk'),
                            'default' => '',
                            'id' => 'settings_gpls_woo_rfq_plus_visible_price_roles',
                            'css' => 'width:600px;height:100px;vertical-align: top'
                        ),
                        'general_section300dd_end' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section3dd_end'
                        ),


                        'general_section_end3432' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section_end3432'
                        ),

                        'general_section23erf33_title' => array(
                            'name' => __('==============================================================================================================', 'rfqtk'),
                            'type' => 'title',

                            'id' => 'general_section23erf33_title'
                        ),


                        'general_section3_title' => array(
                            'name' => __('Buy Or Request a Quote Section', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('Buy Or Request a Quote Section. This applies to RFQ mode only. You can present both the choice to purchase or request a quote.', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_general_section3_title'
                        ),

                        'settings_gpls_woo_rfq_plus_normal_checkout' => array(
                            'name' => '5- ' . __('Allow Other Payment Methods In RFQ Checkout Mode. Buy Or Request a Quote', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => "<br />" . __('Applicable to RFQ checkout option only.<br /> Allow customer to pay or submit a quote request at Checkout. Allows either "Checkout or Request quote" for the entire cart.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_plus_normal_checkout'
                        ),
                        'settings_gpls_woo_rfq_plus_normal_checkout_limit_message' => array(
                            'name' => '5A- ' . __('Message to Customer for Buy or Request a Quote at cart and checkout. Leave blank if no message)', 'rfqtk'),
                            'type' => 'text',
                            'desc' => "<br />" . __('Message to Customer for Buy or Request a Quote at cart and checkout', 'rfqtk'),
                            'default' => '',
                            'id' => 'settings_gpls_woo_rfq_plus_normal_checkout_limit_message',
                            'css' => 'width:600px;'
                        ),
                        'general_section3dd_end' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section3dd_end'
                        ),

                        'general_section3sx_title' => array(
                            'name' => __('Buy Or Request a Quote based on minimum purchase', 'rfqtk'),
                            'type' => 'title',
                            'id' => 'general_section3sx_title'
                        ),

                        'settings_gpls_woo_rfq_plus_normal_checkout_limit' => array(
                            'name' => '5B- ' . __('Minimum purchase to allow Quote Request Option at Checkout(This works with option 5 above. Leave blank if no minimum)', 'rfqtk'),
                            'type' => 'number',
                            'desc' => "<br />" . __('Minimum purchase to allow Quote Request at checkout', 'rfqtk'),
                            'default' => '',
                            'id' => 'settings_gpls_woo_rfq_plus_normal_checkout_limit',
                            'css' => 'width:100px'
                        ),

                        'general_section3ddx_end' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section3ddx_end'
                        ),

                        'general_section3sxx_title' => array(
                            'name' => __('Buy Or Request based on items in the cart', 'rfqtk'),
                            'type' => 'title',
                            'id' => 'general_section3sxx_title'
                        ),


                        'settings_gpls_woo_rfq_limit_to_rfq_only' => array(
                            'name' => '5C- ' . __('Option 5 must be active. Limit to quote request only if any of the products in the cart is marked as "RFQ-Enabled" in the product setup. Minimum limit above does not apply with this option. The whole cart is submitted as a quote request. If there are no RFQ enabled products, customer can purchase normally', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Applicable to RFQ checkout option only. If the cart contains a "quote item" (as setup in the product advance setup) then customer can only request a quote. If this option is picked the minimum purchase does not apply.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_limit_to_rfq_only',
                        ),
                        'settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices' => array(
                            'name' => '5D- ' . __('Hide prices for quote items in the option above', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Hide the prices for quote items. You can optionally hide prices for individual items in the product setup', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices',
                        ),

                        'general_section_end332' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section_end332'
                        ),

                        'general_section2333_title' => array(
                            'name' => __('==============================================================================================================', 'rfqtk'),
                            'type' => 'title',

                            'id' => 'general_section2333_title'
                        ),


                        'general_section_end' => array(
                            'type' => 'sectionend',
                            'id' => 'settings_gpls_woo_rfq_general_section_end4'
                        ),

                        'general_section2_title' => array(
                            'name' => __('Enable Quote Items by Category', 'rfqtk'),
                            'type' => 'title',

                            'id' => 'settings_gpls_woo_rfq_general_section245_title'
                        ),





                        'settings_gpls_woo_rfq_bulk_rfq_enable_in_cat' => array(
                            'name' => '1- ' . __('Bulk RFQ Enable/Disable Existing Products In A Category', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Enable or remove RFQ status on existing products for selected categories below. 
                             <br />If this option is checked, only the selected categories below will be quote items.
                            <br /> You can still modify at product level.', 'rfqtk'),
                            "default" => '',
                            'id' => 'settings_gpls_woo_rfq_bulk_rfq_enable_in_cat'
                        ),
                        'settings_gpls_woo_rfq_bulk_hide_add_to_cart_cat' => array(
                            'name' => '1a- ' . __('Bulk Enable/Disable "Hide Add to Cart" for Existing Products In A Category', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Enable or remove "Hide Add to Cart" for Existing Products for selected categories below. 
                             <br />If this option is checked, "Add to cart" will be hidden only for the selected categories below.
                            <br /> You can still modify at product level.', 'rfqtk'),
                            "default" => '',
                            'id' => 'settings_gpls_woo_rfq_bulk_hide_add_to_cart_cat'
                        ),
                        'settings_gpls_woo_rfq_bulk_hide_price_cat' => array(
                            'name' => '1b- ' . __('Bulk Enable/Disable "Hide Price" for Existing Products In A Category', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Enable or remove "Hide Price" for Existing Products for selected categories below. 
                             <br />If this option is checked, "Add Price" will be hidden only for the selected categories below.
                            <br /> You can still modify at product level.', 'rfqtk'),
                            "default" => '',
                            'id' => 'settings_gpls_woo_rfq_bulk_hide_price_cat'
                        ),

                        'settings_gpls_woo_rfq_cats_new_prods' => array(
                            'name' => '2- ' . __('Enable RFQ status for new products in the selected categories', 'rfqtk'),
                            'type' => 'gpls_woo_chkbox_list',
                            'desc' => __('All new products created in selected categories will be Quote products. <br />You can update the existing products by checking the option above.<br />
                             If option 2 above is checked, only the selected categories will be quote items. You can still modify at product level.', 'rfqtk'),
                            'default' => '',
                            'id' => 'settings_gpls_woo_rfq_cats_new_prods',
                            'css' => 'width:600px;height:100px;vertical-align: top'
                        ),

                        'settings_gpls_woo_rfq_bulk_rfq_enable' => array(
                            'name' => '3- ' . __('Bulk RFQ Enable/Disable All Existing Products', 'rfqtk'),
                            'type' => 'select',
                            'options' => array(
                                '' => '',
                                'yes' => __('RFQ-Enable all existing products', 'rfqtk'),
                                'no' => __('Remove RFQ From all existing products', 'rfqtk')),
                            'desc' => "<br />" . __('Applicable to normal mode. Enable or disable RFQ on all existing products', 'rfqtk'),
                            "default" => '',
                            'id' => 'settings_gpls_woo_rfq_bulk_rfq_enable'
                        ),


                        'settings_gpls_woo_rfq_rfq_enable_default' => array(
                            'name' => '4- ' . __('Normal Checkout. RFQ-Enable All New Products', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Applicable to normal mode. Enable RFQ on all new products', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_rfq_enable_default'
                        ),

                       /* 'settings_gpls_woo_rfq_no_add_to_cart_default' => array(
                            'name' => '2- ' . __('Applies to Normal checkout. Dealing with zero pirce rfq-enabled products when prices are showing in normal checkout ', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('This option hides the "add to cart" button for new product while in normal checkout with prices showing".<br />
                            Checking this hides "Add To Quote" only for new products as they are created. <br />Existing products have to be checked in the product setup section', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_no_add_to_cart_default'
                        ),


                        'settings_gpls_woo_rfq_hide_price_default' => array(
                            'name' => '3- ' . __('Normal Checkout. Dealing with zero pirce rfq-enabled products when prices are showing in normal checkout', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('This option hides the price for new product while in normal checkout with prices showing".<br />
                             Checking this hides product prices only for new products as they are created. <br />Existing products have to be checked in the product setup section', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_hide_price_default'
                        ),*/




                        'settings_gpls_woo_rfq_customer_confirmation_section_end33537' => array(
                            'type' => 'sectionend',
                            'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end33537'
                        ),

                        'general_section233we3_title' => array(
                            'name' => __('==============================================================================================================', 'rfqtk'),
                            'type' => 'title',

                            'id' => 'general_section233we3_title'
                        ),

                        'general_section_title2264' => array(
                            'name' => __('Payment Screen Options', 'rfqtk'),
                            'type' => 'title',
                            
                            'id' => 'general_section_title2264'
                        ),
                        'settings_gpls_plus_allow_anon_at_pay_order' => array(
                            'name' => '1- ' . __('Experimental. Allow visitors to pay for an order without having to log in first. ', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Experimental. It might not work with all payment gateways and third party plugins. Allow visitors to pay for an order without logging in.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_plus_allow_anon_at_pay_order'),

                        'settings_gpls_woo_rfq_address_at_pay_order' => array(
                            'name' => '2- ' . __('Confirm address on pay order screen', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Confirm address on pay order screen(similar to regular checkout screen. The address collected, will be used for the order.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_address_at_pay_order'),

                        'settings_gpls_woo_rfq_phone_at_pay_order' => array(
                            'name' => '3- ' . __('Require phone on pay order screen', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Require phone on pay order screen. The phone number collected, will be used for the order.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_phone_at_pay_order'),

                        /* 'settings_gpls_woo_rfq_only_anon_at_pay_order' => array(
                             'name' => '12- ' . __('Confirm phone & address above only for visitors', 'rfqtk'),
                             'type' => 'checkbox',
                             'desc' => __('Do not confirm address & phone at order pay screen when the user is logged in.', 'rfqtk'),
                             'default' => 'no',
                             'id' => 'settings_gpls_woo_rfq_only_anon_at_pay_order'),*/

                        'settings_gpls_woo_rfq_general_section4512_end' => array(
                            'type' => 'sectionend',
                            'id' => 'settings_gpls_woo_rfq_general_section4512_end'
                        ),
                        'settings_gpls_woo_rfq_customer_confirmation_section_endee33537' => array(
                            'type' => 'sectionend',
                            'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_endee33537'
                        ),

                        'general_section233we3ee_title' => array(
                            'name' => __('==============================================================================================================', 'rfqtk'),
                            'type' => 'title',

                            'id' => 'general_section233we3ee_title'
                        ),
                        'settings_gpls_woo_rfq_general_section255_title' => array(
                            'name' => __('MISC Options', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __(' MISC options ', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_general_section255_title'
                        ),

                        'settings_gpls_woo_rfq_change_stock' => array(
                            'name' => '1- ' . __('Decrease stock with manual order-status chanage ', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => "<br />" . __('If you choose this option, stock quantity decreases when order status is manually changed to processing or completed', 'rfqtk') . "<br />" . __('processing to completed does not reduce again). Cancelling increases stock', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_change_stock'),

                        'settings_gpls_woo_rfq_hide_shipping' => array(
                            'name' => '2- ' . __('Shipping Totals: Hide Shipping in WooCommerce checkout', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Hide Shipping in WooCommerce Checkout', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_hide_shipping'
                        ),

                        'settings_gpls_woo_rfq_rfq_no_shipping' => array(
                            'name' => '3- ' . __('Experimental: Disable Shipping For Quote Requests', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Experimental: Disable Shipping For Quote Requests', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_rfq_no_shipping'
                        ),



                        'general_section2_end' => array(
                            'type' => 'sectionend',
                            'id' => 'settings_gpls_woo_rfq_general245_section_end'
                        ),

                        'twitter_checkout_option2' => array(
                            'name' => '====================================================================================================================================================================',
                            'type' => 'title',
                            'desc' => '<br /><h4><a target="_blank" href="https://www.neahplugins.com/product/woocommerce-quote-request-plus/"><span style="color:blue">NP WooCommerce Quote Request Plus</span></a>' . __(' provides many more customization options and features.', 'rfqtk') . '' . '<h4>' . '<br /><h4><a target="_blank" href="https://www.neahplugins.com/product/woocommerce-quote-request-upload-files/"><span style="color:blue">NP WooCommerce Quote Request- File Upload</span></a>' . __(' Allows customer to upload files along with Quote Requests and WooCommerce orders.', 'rfqtk') . '' . '<h4>' . '<h4>' . '<br /><h4><a target="_blank" href="https://www.neahplugins.com/product/woocommerce-quote-request-product_fields/"><span style="color:blue">NP WooCommerce Quote Request - Product Form</span></a>' . __(' Allows custom forms in the product page for Quote Requests and WooCommerce orders.', 'rfqtk') . '<br /><h4><a target="_blank" href="https://www.neahplugins.com/product/woocommerce-quickbooks-connector"><span style="color:blue">WooCommerce-QuickBooks Desktop Connector</span></a>' . __(' Sync your orders and inventory between WooCommerce and QuickBooks.', 'rfqtk') . '<h4><h4><br /><h4>' . __('<strong>If NP WooCommerce Quote Request is helpful to you, a <a target="_blank" href="https://wordpress.org/support/plugin/woo-rfq-for-woocommerce/reviews/">rating</a> would be appreciated. Thank you in advance.<strong><br /><br /><b>Please follow us on Twitter for news on features & updates <a target="_blank" href="https://twitter.com/@NeahPlugins" class="twitter-follow-button" data-show-count="true">@NeahPlugins</a> and visit us at <a target="_blank" href="http://www.neahplugins.com/">NeahPlugins</a>. You can <a  target="blank" href="mailto:contact@neahplugins.com" >contact</a> us for feedback or suggestions.</b>', 'rfqtk'),
                            'id' => 'twitter_checkout_option20',
                            'css' => 'width:600px; margin-top:50px'
                        ),
                        'general_section_end34055' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section_end34550'
                        )


                    );
                break;
            case 'translations':

                $settings = array_slice($settings, 0, count($settings) - 1, true)
                    + array('settings_gpls_woo_rfq_quote_request_label' =>
                        array(
                            'name' => '17- Normal or RFQ Checkout-' . __('Quote Requests Status Label In Orders Admin Page', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Choose the text for "Quote Requests" for admin orders screen', 'rfqtk'),
                            'default' => __('Quote Request', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_quote_request_label',
                            'css' => 'width:400px'
                        ))

                    + array('settings_gpls_woo_rfq_quote_sent_label' =>
                        array(
                            'name' => '18- Normal or RFQ Checkout-' . __('Quotes Sent Status Label In Orders Admin Page', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Choose the text for "Quotes Sent" for admin orders screen', 'rfqtk'),
                            'default' => __('Quote Sent', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_quote_sent_label',
                            'css' => 'width:400px'
                        )) +
                    array_slice($settings, count($settings) - 2, count($settings) - 1, true);


                break;

            case 'rfq_page':
                $settings = array_slice($settings, 0, count($settings) - 1, true)

                    + array(

                        'rfq_cart_sc_update_button_section_page_title' => array(
                            'name' => __('Page Fields', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '',
                            'id' => 'rfq_cart_sc_update_button_section_page_title',
                            'css' => 'width:600px'
                        ),

                        'rfq_cart_sc_section_rfq_page_create_accounts' => array(
                            'name' => __('Allow Account Creation', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Allow visitors to create an account while requesting a quote.', 'rfqtk'),
                            'default' => 'yes',
                            'id' => 'rfq_cart_sc_section_rfq_page_create_accounts',
                            'css' => 'width:400px;'
                        ),

                        'rfq_cart_sc_visitor_section_title' => array(
                            'name' => '',
                            'type' => 'title',
                            'desc' => __('<h1>Make the following fields required for visitors.</h1>', 'rfqtk'),
                            'id' => 'rfq_cart_sc_visitor_section_title',
                            'css' => 'width:600px'
                        ),


                        'rfq_cart_sc_section_rfq_page_phone_required' => array(
                            'name' => '1- ' . __('Phone Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_phone_required',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_company_required' => array(
                            'name' => '2- ' . __('Company Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_company_required',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_country_required' => array(
                            'name' => '3- ' . __('Country Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_country_required',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_state_required' => array(
                            'name' => '4- ' . __('State Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_state_required',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_address_required' => array(
                            'name' => '5- ' . __('Address', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_address_required',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_city_required' => array(
                            'name' => '6- ' . __('City Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_city_required',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_zip_required' => array(
                            'name' => '7- ' . __('Zip Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_zip_required',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_comment_required' => array(
                            'name' => '8- ' . __('Comment Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_comment_required',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_page_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_section_page_title_end'
                        ),
                        'rfq_cart_sc_visitor_section_title234' => array(
                            'name' => '',
                            'type' => 'title',
                            'desc' => __('<h1>Style The quote request page</h1>.', 'rfqtk'),
                            'id' => 'rfq_cart_sc_visitor_section_title',
                            'css' => 'width:600px'
                        ),

                        'rfq_cart_sc_section_rfq_page_apply_style' => array(
                            'name' => __('Enable custom styling', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Enable/Disable styling. It applies or removes the following custom styling for the page including buttons', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_apply_style',
                            'css' => 'width:400px;'
                        ),
                        'gpls_woo_rfq_request_page_background' => array(
                            'name' => __('Main Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Main Background Color for the cart and customer info.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'gpls_woo_rfq_request_page_background',
                        ),

                        'rfq_cart_sc_section_page_title_end234' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_section_page_title_end'
                        ),

                        'rfq_cart_sc_page_cart_section_title' => array(
                            'name' => __('Customize Quote Cart', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '',
                            'id' => 'rfq_cart_sc_page_cart_section_title',
                            'css' => 'width:600px'
                        ),


                        'rfq_cart_sc_section_rfq_page_update_cart_button_background' => array(
                            'name' => '1- ' . __('Update Request List Button Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of update list button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_update_cart_button_background',
                        ),

                        'rfq_cart_sc_section_rfq_page_update_cart_button_color' => array(
                            'name' => '2- ' . __('Update Request List Button Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of update list button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_update_cart_button_color',
                        ),
                        'rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background' => array(
                            'name' => '3- ' . __('Update Request List Button MouseOver Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of update list button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background',
                        ),
                        'rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color' => array(
                            'name' => '4-' . __('Update Request List Button MouseOver Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of update list button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color',

                        ),


                        'rfq_cart_sc_section_rfq_page_cart_background' => array(
                            'name' => '5- ' . __('Cart Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Cart background bolor for the whole quote cart.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_background',
                        ),

                        'rfq_cart_sc_section_rfq_page_cart_header_background' => array(
                            'name' => '6- ' . __('Cart Row Header Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Cart Row Header Background Color.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_header_background',
                        ),

                        'rfq_cart_sc_section_rfq_page_cart_header_color' => array(
                            'name' => '7- ' . __('Cart Row Header Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Cart Row Header Font Color', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_header_color',
                        ),

                        'rfq_cart_sc_section_rfq_page_cart_row_background' => array(
                            'name' => '8- ' . __('Cart Row Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Cart Row Background Color', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_row_background',
                        ),
                        'rfq_cart_sc_section_rfq_page_cart_font_color' => array(
                            'name' => '9- ' . __('Cart Row Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Cart Row Font Color.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_font_color',
                        ),
                        'rfq_cart_sc_section_rfq_page_cart_link_color' => array(
                            'name' => '10- ' . __('Cart Row Link Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Cart Row Link Color', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_link_color',
                        ),
                        'rfq_cart_sc_section_rfq_page_cart_image_size' => array(
                            'name' => '11- ' . __('Product Image Maximum Width', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Product image maximum width size in px,em or %, e.g. 4em , 800px or 80%', 'rfqtk'),
                            'default' => '',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_image_size',
                        ),

                        'rfq_cart_sc_page_cart_section_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_page_cart_section_title_end'
                        ),


                        'rfq_cart_sc_page_cust_info_title' => array(
                            'name' => __('Customize Customer Info', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '',
                            'id' => 'rfq_cart_sc_page_cust_info_title',
                            'css' => 'width:600px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_submit_quote_button_background' => array(
                            'name' => '1- ' . __('Submit Quote Button Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of update list button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_submit_quote_button_background',
                        ),

                        'rfq_cart_sc_section_rfq_page_submit_quote_button_color' => array(
                            'name' => '2- ' . __('Submit Quote Button Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of update list button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_submit_quote_button_color',
                        ),
                        'rfq_cart_sc_section_rfq_page_submit_quote_button_mouse_over_background' => array(
                            'name' => '3- ' . __('Submit Quote Button MouseOver Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of submit quote button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_submit_quote_button_mouse_over_background',
                        ),
                        'rfq_cart_sc_section_rfq_page_submit_quote_button_mouse_over_color' => array(
                            'name' => '4- ' . __('Submit Quote Button MouseOver Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of submit quote button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_submit_quote_button_mouse_over_color',
                        ),


                        'rfq_cart_sc_section_rfq_cust_info_background' => array(
                            'name' => '5- ' . __('Customer Info Section Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer info background color for the whole section.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_cust_info_background',
                        ),

                        'rfq_cart_sc_section_rfq_cust_info_header_background' => array(
                            'name' => '6- ' . __('Customer Info Row Header Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer Info Row Header Background Color.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_cust_info_header_background',
                        ),

                        'rfq_cart_sc_section_rfq_cust_info_header_color' => array(
                            'name' => '7- ' . __('Customer Info Row Header Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer Info Row Header Font Color', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_cust_info_header_color',
                        ),

                        'rfq_cart_sc_section_rfq_cust_info_row_background' => array(
                            'name' => '8- ' . __('Customer Info Row Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer Info Row Background Color', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_cust_info_row_background',
                        ),
                        'rfq_cart_sc_section_rfq_cust_info_font_color' => array(
                            'name' => '9- ' . __('Customer Info Row Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer Info Row Font Color.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_cust_info_font_color',
                        ),

                        'rfq_cart_sc_section_rfq_woo_rfq_customer_info_header_color' => array(
                            'name' => '10- ' . __('Customer Info Section Title Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer Info Section Title Color.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_woo_rfq_customer_info_header_color',
                        ),
                        'rfq_cart_sc_section_rfq_woo_rfq_customer_info_input_background' => array(
                            'name' => '11- ' . __('Customer Info Input Field Background', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer Info Section Title Color.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_woo_rfq_customer_info_input_background',
                        ),

//
                        'rfq_cart_sc_section_rfq_woo_rfq_customer_info_border_color' => array(
                            'name' => '12- ' . __('Customer Info Border Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer info border color.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_woo_rfq_customer_info_border_color',
                        ),

                        'rfq_cart_sc_section_rfq_page_cart_border_size' => array(
                            'name' => '13- ' . __('Customer Info Border Width', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer border style size in px or em, e.g. 0.01em or 2px', 'rfqtk'),
                            'default' => '0px',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_border_size',
                        ),

                        'rfq_cart_sc_section_rfq_page_cart_border_style' => array(
                            'name' => '14- ' . __('Customer Info Border Style', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer border style, e.g. solid dashed', 'rfqtk'),
                            'default' => 'none',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_border_style',
                        ),

                        'rfq_cart_sc_page_cust_info_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_page_cust_info_title_end'
                        ),

                        'rfq_cart_sc_html_desc_section_title' => array(
                            'name' => '',
                            'type' => 'title',
                            'desc' => __('<h1>Create Custom Content</h1>', 'rfqtk'),
                            'id' => 'rfq_cart_sc_html_desc_section_title',
                            'css' => 'width:600px'
                        ),
                        'settings_gpls_woo_rfq_enabled_page_desc_top' => array(
                            'name' => '1- ' . __('Enable In Request for Quote Page', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('HTML Content Before Items', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_enabled_page_desc_top'
                        ),
                        'settings_gpls_woo_rfq_page_desc_top' => array(
                            'name' => '',
                            'type' => 'gpls_woo_html_editor',
                            'desc' => __('HTML at the beginning of the page which is after page title, before the list of items.', 'rfqtk'),
                            'default' => '',
                            'textarea_rows' => 10,
                            'editor_css' => '<style>#wp-settings_gpls_woo_rfq_customer_offer_desc-wrap{height:100px; width:600px;}</style>',
                            'id' => 'settings_gpls_woo_rfq_page_desc_top',

                        ),
                        'settings_gpls_woo_rfq_enabled_page_desc_bottom' => array(
                            'name' => '2- ' . __('Enable In Request for Quote Page', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('HTML Content At Page End', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_enabled_page_desc_bottom'
                        ),
                        'settings_gpls_woo_rfq_page_desc_bottom' => array(
                            'name' => '',
                            'type' => 'gpls_woo_html_editor',
                            'textarea_rows' => 10,
                            'desc' => __('HTML at end of the page after the submit quote button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'gpls_woo_plus_htm_editor_wide',
                            'id' => 'settings_gpls_woo_rfq_page_desc_bottom',

                        ),
                        'settings_gpls_woo_rfq_remove_update_cart_in_rfq_cart' => array(
                            'name' => '3- ' . __('Minimal RFQ Cart. Remove update button and remove item in quote request cart', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Use a minimal RFQ Cart. User can set quantity to zero to remove items. The only button is submit quote', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_remove_update_cart_in_rfq_cart'
                        ),
                        'rfq_cart_sc_html_desc_section_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_html_desc_section_title_end'
                        ),

                    )
                    +
                    array_slice($settings, count($settings) - 2, count($settings) - 1, true);;
                break;

            case 'add-to-quote':
                $settings =

                    array(

                        'rfq_cart_short_redirect_title' => array(
                            'name' => __('Add to Quote Button', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '',
                            'id' => 'rfq_cart_short_redirect_title',
                            'css' => 'width:600px'
                        ),


                        'rfq_cart_sc_redirect_title_end245' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_redirect_title_end245'
                        ),
                        'rfq_cart_short_sc_section_title' => array(
                            'name' => __('Add to Quote Shortcode', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '<b>' . __('In the <b>normal checkout</b> mode you can create a "add to quote" button with <i>[gpls-woo-rfq-quote-button product_id=\'115\' show_image=\'yes\' image_size=\'thumbnail\' show_title=\'yes\' div_width=\'200px\']<i>.<br /> The sizes include thumbnail,shop_thumbnail, shop_catalog and shop_single. 
                                            The resulting image size depends on your shop settings for these images. The short code does not resize the image.<br /><br />
                                            In the <b>RFQ mode</b> use [add_to_cart id="115" style="border:4px solid #ccc; padding: 12px" sku="FOO" show_price="true" class="CSS-CLASS" quantity="1"]' . '</b>', 'rfqtk'),
                            'id' => 'rfq_cart_short_sc_section_title',
                            'css' => 'width:600px'
                        ),
                        'rfq_cart_sc_section_add_to_quote_short_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_section_add_to_quote_short_title_end'
                        ),
                        'ninja_section_title' => array(
                            'name' => __('Normal Checkout Add to Quote Button Style.', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('Style add to quote button', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_add-to-quote_section_title'
                        ),

                        'rfq_cart_sc_section_rfq_page_add_to_quote_button_background' => array(
                            'name' => '1- ' . __('Add to Quote Button Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of add to quote button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_to_quote_button_background',
                        ),

                        'rfq_cart_sc_section_rfq_page_add_to_quote_button_color' => array(
                            'name' => '2- ' . __('Add to Quote Button Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of Quote button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_to_quote_button_color',
                        ),
                        'rfq_cart_sc_section_rfq_page_add_to_quote_button_mouse_over_background' => array(
                            'name' => '3- ' . __('Add to Quote Button MouseOver Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of Upload button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_to_quote_button_mouse_over_background',
                        ),
                        'rfq_cart_sc_section_rfq_page_add_to_quote_button_mouse_over_color' => array(
                            'name' => '4-' . __('Add to Quote Button MouseOver Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of Quote button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_to_quote_button_mouse_over_color',
                        ),

                        'settings_gpls_woo_rfq_only_on_single_page_normal' => array(
                            'name' => '5- ' . __('Normal Checkout Only. Show "Add To Quote" only on single product Page', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Normal Checkout Only. Some themes only show "Add to Cart" in the single page.<br /> This would show "Add To Quote" only on single product Page.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_only_on_single_page_normal'
                        ),

                        'settings_gpls_woo_rfq_only_on_single_page_rfq' => array(
                            'name' => '6- ' . __('RFQ Checkout Only. Show "Add To Quote" only on single product Page', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('This would show "Add To Quote" only on single product Page.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_only_on_single_page_rfq'
                        ),
                        'rfq_cart_sc_redirect_after_add' => array(
                            'name' => '7- ' . __('Normal Checkout-Enable Redirect After Add to Quote For All Users', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Enable Redirect to RFQ Cart After Add to Quote For For All Users', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_redirect_after_add'
                        ),
                        'rfq_cart_sc_redirect_to_single' => array(
                            'name' => '8- ' . __('Always redirect the user to the single product page', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Always redirect the user to the single product page', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_redirect_to_single'
                        ),

                        'rfq_cart_sc_section_add_to_quote_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_section_add_to_quote_title_end'
                        ),


                    );
                break;


            case 'email-options':
                $settings = array(


                    'general_section_title0' => array(
                        'name' => __('Proposal Content', 'rfqtk'),
                        'type' => 'title',
                        'desc' => __('Custom HTML content to be included with each proposal', 'rfqtk'),
                        'id' => 'general_section_title0'
                    ),
                    'settings_gpls_woo_rfq_default_proposal_content' => array(
                        'name' => __('Default Proposal HTML Content', 'rfqtk'),
                        'type' => 'gpls_woo_html_editor',
                        'textarea_rows' => 10,
                        'desc' => __('Default Proposal HTML Content. You can modify this before sending', 'rfqtk'),
                        'default' => '',
                        'class' => 'gpls_woo_plus_htm_editor_wide',
                        'id' => 'settings_gpls_woo_rfq_default_proposal_content',
                    ),

                    'settings_gpls_woo_rfq_global_proposal' => array(
                        'name' => '' . __('HTML Content appended to each proposal sent to customer', 'rfqtk'),
                        'type' => 'gpls_woo_html_editor',
                        'textarea_rows' => 5,
                        'desc' => __('Custom HTML content to be included at the end of each proposal.', 'rfqtk'),
                        'default' => "",
                        'class' => 'gpls_woo_plus_htm_editor_wide',
                        'id' => 'settings_gpls_woo_rfq_global_proposal',
                    ),
                    'settings_settings_gpls_woo_rfq_global_proposal_section_end33' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end33'
                    ),
                    'general_section_title0000' => array(
                        'name' => __('Email Options', 'rfqtk'),
                        'type' => 'title',
                        'desc' => __('links in the "Quote Sent" Email ', 'rfqtk'),
                        'id' => 'general_section_title0000'
                    ),
                    'settings_gpls_woo_rfq_pay_default' => array(
                        'name' => '1- ' . __('Check Pay Link For All Proposals', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Check Pay Link For All Proposals', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_pay_default'
                    ),
                    'settings_gpls_woo_rfq_respond_default' => array(
                        'name' => '2- ' . __('Check Respond Link For All Proposals', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Check Respond Link For All Proposals', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_respond_default'
                    ),

                    'settings_gpls_woo_rfq_accept_default' => array(
                        'name' => '3- ' . __('Check Accept Link For All Proposals', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Check Accept Link For All Proposals', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_accept_default'
                    ),

                    'settings_gpls_woo_rfq_show_accept_offer' => array(
                        'name' => '4- ' . __('Show Accept Offer Form to Customer', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Show "accept offer" form to customer in the order screen in my-account', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_show_accept_offer'),
                    'settings_gpls_woo_rfq_expire_method' => array(
                        'name' => '5- ' . __('Quote Expiration Option', 'rfqtk'),
                        'type' => 'select',
                        'options' => array(
                            'no' => __('No Expiration', 'rfqtk'),
                            'wc-cancelled' => __('Cancel Quotes', 'rfqtk'),
                            'trash' => __('Move Quotes to Trash', 'rfqtk')),
                        'desc' => "<br />" . __('Choose if you want to expire the quote request after a length of time', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_expire_method'),

                    'settings_gpls_woo_rfq_expire_days' => array(
                        'name' => '6- ' . __('Number of Days Before Quote Expires( Greater than 1 day is required)', 'rfqtk'),
                        'type' => 'number',
                        'desc' => "<br />" . __('Number of Days Before Quote Expires. Put a number greater than 1 or the job will not run', 'rfqtk'),
                        'default' => '30',
                        'id' => 'settings_gpls_woo_rfq_expire_days',
                        'css' => 'width:100px'
                    ),
                    'settings_gpls_woo_rfq_order_date' => array(
                        'name' => '7- ' . __('Update Order Date On Completion?', 'rfqtk'),
                        'type' => 'select',
                        'options' => array(
                            'no' => __('No. Keep the original Date', 'rfqtk'),
                            'yes' => __('Yes. Update order date to order payment date', 'rfqtk')),
                        'desc' => "<br />" . __('Update order date to payment date for quote requests".', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_order_date')
                ,

                    'settings_gpls_woo_rfq_admin_email_reply_to' => array(
                        'name' => '8- ' . __('Change "reply to" in admin email to customer email', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Change "reply to" to the customer billing email in emails sent to admin for convenience.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_admin_email_reply_to',
                        'css' => 'width:400px;'
                    ),

                    'settings_gpls_woo_rfq_quote_sent_email_customer_notes' => array(
                        'name' => '9- ' . __('Include Customer Notes In Quote Sent Email', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Include all the cutomer notes in the "Quote Sent" (proposal) email..', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_quote_sent_email_customer_notes',
                        'css' => 'width:400px;'
                    ),

                    'settings_gpls_woo_rfq_show_prices_customer_confirmation_email' => array(
                        'name' => '10- ' . __('Show Prices in Customer Quote Request Email Confirmation.', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Include prices in the request for quote confirmation email.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_show_prices_customer_confirmation_email'
                    ),
                    'settings_gpls_woo_rfq_import_order_items_table' => array(
                        'name' => '11- ' . __('Import Order Items Table Into the Proposal', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Import order items table (similar to what goes out in the email) into the proposal. This can be edited to be included in the porposal', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_import_order_items_table'
                    ),
                    'settings_gpls_woo_rfq_import_order_items_table_desc' => array(
                        'name' => '12- ' . __('Show product descriptions in the Order Items Table', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Show product descriptions in the Order Items Table', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_import_order_items_table_desc'
                    ),



                    'settings_gpls_woo_rfq_change_to_sent' => array(
                        'name' => '13- ' . __('Convert all New Quote Request to "Quote Sent" automatically', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('PLEASE BE CAREFUL WITH THIS OPTION. IF AN ITEM IN THE ORDER HAS ZERO OR NO PRICE,<br />CUSTOMER WILL RECIEIVE A 100% DISCOUNT ON THAT ITEM.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_change_to_sent'
                    ),
                    'settings_gpls_woo_rfq_delay_quote_hours' => array(
                        'name' => '14- ' . __('Number of Hours Before Quote Is Sent automatically', 'rfqtk'),
                        'type' => 'text',
                        'desc' => "<br />" . __('Put a number for number of hours before quote is sent. Example: 1,0.5 or 1.5. Initial Confirmation email is also sent. If blank, quote is sent with a 5 minutes delay', 'rfqtk'),
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_delay_quote_hours',
                        'css' => 'width:100px'
                    ),
                    'settings_gpls_woo_rfq_accept_offer_order_status' => array(
                        'name' => '15- ' . __('Change Order Status when customer accepts offer. It only works if order status is in "Quote Sent" ', 'rfqtk'),
                        'type' => 'select',
                        'options' => array(
                            'no' => __('No Change', 'rfqtk'),
                            'wc-pending' => __('pending', 'rfqtk'),
                            'wc-processing' => __('processing', 'rfqtk'),
                            'wc-completed' => __('completed', 'rfqtk')),
                        'desc' => "<br />" . __('Choose if you want to change order-status when customer accepts offer.<br /> It only works if order status is in "Quote Sent"', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_accept_offer_order_status'),

                    'settings_settings_gpls_woo_rfq_global_proposal_section_end333' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end333'
                    ),

                );
                break;


            case 'marketing':
                $settings = array(

                    'general_section_title1' => array(
                        'name' => __('Marketing Content For Email & Thank You Page', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '<h4>' . __('Marketing content can in be included as HTML in confirmation emails and the thank you page. <br />Content can be included in two ways: <br /> 1: You can include custom product-specific content which can be created in the advanced tab of product setup. <br />2: You can also include a custom global content in this page below. ', 'rfqtk') . '</h4>',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_title2'
                    ),

                    'settings_gpls_woo_rfq_customer_confirmation_section_end33' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end33'
                    ),
                    'general_section_end332eee' => array(
                        'type' => 'sectionend',
                        'id' => 'general_section_end332eee'
                    ),


                    'general_section_title22' => array(
                        'name' => __('Enable / Disable Product-Specific Marketing Content Options', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '<h4>' . __('Manage product-specific custom content in the confirmation email and thank you page. Content is setup individually in product setup pages.', 'rfqtk') . '</h4>',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_title'
                    ),

                    'gpls_woo_rfq_customer_confirmation_product_thankyou_page' => array(
                        'name' => '1- ' . __('Include Product-Specific Content in The Thank You Page.', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('This option enables/disables product marketing globally in the thank you pages.<br />If this option is not checked no custom content is included in the thank you page.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'gpls_woo_rfq_customer_confirmation_product_thankyou_page'
                    ),
                    'gpls_woo_rfq_email_confirmation_product_messages' => array(
                        'name' => '2- ' . __('Show Product-Specific Content in Request Recieved and Quote Sent Email Confirmation', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('This option enables/disables product marketing globally. <b>It still has to be enabled and setup individually in product setup pages or by using the category tool below. <br />Additional product-specific content (from product setup admin page) to show the customer in confirmation emails to customers. <br />This can be disabled for specific products in the product setup page</b>.<br /> If this option is not checked no custom content is included in the confirmation emails.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'gpls_woo_rfq_email_confirmation_product_messages'
                    ),

                    'general_section_end3324' => array(
                        'type' => 'sectionend',
                        'id' => 'general_section_end3324'
                    ),
                    'general_section_end332' => array(
                        'type' => 'sectionend',
                        'id' => 'general_section_end332'
                    ),

                    'general_section233356_title' => array(
                        'name' => __('==============================================================================================================', 'rfqtk'),
                        'type' => 'title',

                        'id' => 'general_section233356_title'
                    ),
                    'general_section_title2266f' => array(
                        'name' => __('Enable/Disable Marketing Content for Products by Category', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '<h4>' . __('Enable/Disable Marketing Content for Products by Category.', 'rfqtk') . '</h4>',
                        'id' => 'general_section_title2266f'
                    ),
                    'settings_gpls_woo_rfq_bulk_rfq_enable_product_messages' => array(
                        'name' => '3- ' . __('Bulk Enable/Disable Product Marketing Content In Products In Selected Categories', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Bulk Enable/Disable sending Product marketing content in customer emails on existing products for selected categories below. 
                             <br />If this option is checked, product marketing materials will be sent only for the selected categories below.
                             <br />If this option is checked, product marketing materials will be sent only for the selected categories below.
                            <br /> You can still modify at product level.', 'rfqtk'),
                        "default" => '',
                        'id' => 'settings_gpls_woo_rfq_bulk_rfq_enable_product_messages'
                    ),


                    'settings_gpls_woo_rfq_cats_new_enable_product_messages' => array(
                        'name' => '4- ' . __('Bulk Enable/Disable Product Marketing Content for new products in the selected categories', 'rfqtk'),
                        'type' => 'gpls_woo_chkbox_prod_marketing_list',
                        'desc' => __('All new products created in selected categories will Product Marketing Content Enabled. <br />You can update the existing products by checking the option above.<br />
                             If option 2 above is checked, only the products in selected categories will have Product Marketing. You can still modify at product level.', 'rfqtk'),
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_cats_new_enable_product_messages',
                        'css' => 'width:600px;height:100px;vertical-align: top'
                    ),

                    'settings_gpls_woo_rfq_customer_confirmation_section_end335' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end335'
                    ),
                    'general_section_end3324a' => array(
                        'type' => 'sectionend',
                        'id' => 'general_section_end3324a'
                    ),

                    'general_section23334b_title' => array(
                        'name' => __('==============================================================================================================', 'rfqtk'),
                        'type' => 'title',

                        'id' => 'general_section23334b_title'
                    ),
                    'general_section_title2266' => array(
                        'name' => __('Update Marketing Content for Products by Category', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '<h4>' . __('Update Marketing Content for Products by Category. Content can also be update individually in product setup.', 'rfqtk') . '</h4>',
                        'id' => 'general_section_title2266'
                    ),

                    'settings_gpls_woo_rfq_customer_product_message_content' => array(
                        'name' => '5- ' . __('HTML Content For Products in Selected Categories Email Confirmation/Thank You Page', 'rfqtk'),
                        'type' => 'gpls_woo_html_editor',
                        'textarea_rows' => 10,
                        'desc' => __('HTML Content For Products in Selected Categories to be included in confirmation emails and thank you page.<br />', 'rfqtk'),
                        'default' => '',
                        'class' => 'gpls_woo_plus_htm_editor_wide',
                        'id' => 'settings_gpls_woo_rfq_customer_product_message_content',
                    ),
                    'settings_gpls_woo_rfq_bulk_rfq_update_product_messages' => array(
                        'name' => '6- ' . __('Bulk update Product Marketing Content In Products In Selected Categories', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Bulk update product marketing content in for selected categories below. 
                             <br />If this option is checked, product marketing materials will be updated for the selected categories below.                             
                            <br /> You can still modify at product level.', 'rfqtk'),
                        "default" => '',
                        'id' => 'settings_gpls_woo_rfq_bulk_rfq_update_product_messages'
                    ),


                    'settings_gpls_woo_rfq_cats_new_update_product_messages' => array(
                        'name' => '7- ' . __('Bulk Update Product Marketing Content for new products in the selected categories', 'rfqtk'),
                        'type' => 'gpls_woo_chkbox_prod_marketing_content_list',
                        'desc' => __('Bulk update product marketing content in for selected categories below.<br />You can update the existing products by checking the option above.<br />
                             If option 2 above is checked, only the products in selected categories will be updated. You can still modify at product level.', 'rfqtk'),
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_cats_new_update_product_messages',
                        'css' => 'width:600px;height:100px;vertical-align: top'
                    ),

                    'settings_gpls_woo_prod_marketing_by_category' => array(
                        'name' => __('Marketing Content for Products by Category', 'rfqtk'),
                        'type' => 'gpls_woo_prod_marketing_by_category',
                        'desc' => '<h4>' . __('Marketing Content for Products by Category.', 'rfqtk') . '</h4>',
                        'id' => 'settings_gpls_woo_prod_marketing_by_category'
                    ),


                    'settings_gpls_woo_rfq_customer_confirmation_section_end3357' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end3357'
                    ),
                    'general_section_end332o9' => array(
                        'type' => 'sectionend',
                        'id' => 'general_section_end332o9'
                    ),

                    'general_section2333tt_title' => array(
                        'name' => __('==============================================================================================================', 'rfqtk'),
                        'type' => 'title',

                        'id' => 'general_section2333tt_title'
                    ),
                    'general_section_title2264' => array(
                        'name' => __('Send  Email for Each Product', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '<h4>' . __('Send an email for each product.', 'rfqtk') . '</h4>',
                        'id' => 'general_section_title2264'
                    ),
                    'gpls_woo_rfq_email_product_marketing_emails' => array(
                        'name' => '8- ' . __('Send an email for each product-specific marketing content. This sends an email for each product, but does not include a quote. This is an informational email only.', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Send an email for each product-specific marketing content.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'gpls_woo_rfq_email_product_marketing_emails'
                    ),
                    'settings_gpls_woo_rfq_delay_product_marketing_hours' => array(
                        'name' => '9- ' . __('Number of Hours Before EmailIs Sent automatically', 'rfqtk'),
                        'type' => 'text',
                        'desc' => "<br />" . __('Put a number for number of hours before email is sent. Example: 1,0.5 or 1.5. Default is 5 minutes delay', 'rfqtk'),
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_delay_product_marketing_hours',
                        'css' => 'width:100px'
                    ),

                    'settings_gpls_woo_rfq_customer_confirmation_section_end300' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end300'
                    ),

                    'general_section_end332fff' => array(
                        'type' => 'sectionend',
                        'id' => 'general_section_end332fff'
                    ),

                    'general_section233e4r3_title' => array(
                        'name' => __('==============================================================================================================', 'rfqtk'),
                        'type' => 'title',
                        'id' => 'general_section233e4r3_title'
                    ),

                    'general_section_title333' => array(
                        'name' => __('Global Custom Content For All Products', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '<h4>' . __('Manage global custom content in confirmation emails and confirmation pages', 'rfqtk') . '</h4>',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_title'
                    ),

                    'gpls_woo_rfq_customer_confirmation_stock_thankyou_page' => array(
                        'name' => '10- ' . __('Show The Content Below in Request Recieved / Thank You Page', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Custom content to show the customer in the thank you page after request for quote is submitted.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'gpls_woo_rfq_customer_confirmation_stock_thankyou_page'
                    ),
                    'gpls_woo_rfq_email_confirmation_stock_message' => array(
                        'name' => '11- ' . __('Show The Content Below in Request Recieved Email Confirmation', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Custom content to show the customer in the email confirmation after request for quote is submitted. ', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'gpls_woo_rfq_email_confirmation_stock_message'
                    ),


                    'settings_gpls_woo_rfq_customer_confirmation_message' => array(
                        'name' => '12- ' . __('HTML Content to Customers in Email Confirmation/Thank You Page', 'rfqtk'),
                        'type' => 'gpls_woo_html_editor',
                        'textarea_rows' => 10,
                        'desc' => __('Custom HTML content to be included in confirmation emails and thank you page.', 'rfqtk'),
                        'default' => '',
                        'class' => 'gpls_woo_plus_htm_editor_wide',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_message',
                    ),
                    'settings_gpls_woo_rfq_customer_confirmation_section_end21' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end21'
                    ),
                    'general_section_title444' => array(
                        'name' => __('Miscellaneous Options', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '<h4></h4>',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_title'
                    ),


                    'settings_gpls_woo_rfq_customer_confirmation_section_end24' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end24'
                    ),
                );
                break;


            case 'custom-form':


                $settings =

                    array(

                        'ninja_section_title' => array(
                            'name' => __('Custom Form Integration.', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '<h3>' . __('Add your own fields to checkout(RFQ checkout) or quote request page(normal checkout) using a Ninja Form.', 'rfqtk') . '</h3>'
                                . '<ul><li><b>' . __('Compatibe with Ninja Forms version 3.0.', 'rfqtk') . '</b></li>'
                                . '<li><b>' . __('Supports <u><i>most standard fields and basic features(Not paid e.g file upload or third party extensions)</i></u> included with Ninja Forms 3.0.', 'rfqtk') . '</b></li>'
                                . '<li><b>' . __('Note: Must include a Submit Button in your Ninja Form.', 'rfqtk') . '</b></li>'
                                . '<li><b>' . __('Note: Calculated fields are not saved in the order.', 'rfqtk') . '</b></li>'
                                . '<li><b>' . __('Note: “CUSTOM NAME ATTRIBUTE” must be blank. Ninja Form sometimes(e.g city, zip) adds a value to “CUSTOM NAME   ATTRIBUTE” when you add a field. <br />This is found in the ADVANCED section of the field settings..', 'rfqtk') . '</b></li>'

                                . '<li><b>' . __('Note: Plugin saves the values entered by the user in the order.', 'rfqtk') . '</b></li></ul>',
                            'id' => 'settings_gpls_woo_rfq_ninja_section_title'
                        ),
                        'settings_gpls_woo_rfq_allow_custom_form' => array(
                            'name' => '1- ' . __('Display Custom Form for quote request checkout', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Enable Custom Form For Quote Request Checkout', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_allow_custom_form'
                        ),
                        'settings_gpls_woo_rfq_allow_custom_form_wc' => array(
                            'name' => '2- ' . __('Applicable to Normal Checkout Only: Display Custom Form in WooCommerce Checkout ', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Enable Custom Form in WooCommerce checkout', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_allow_custom_form_wc'
                        ),

                        'settings_gpls_woo_ninja_form_option' => array(
                            'name' => '3- ' . __('Select Ninja Form', 'rfqtk'),
                            'type' => 'select',
                            'options' => gpls_woo_rfq_plus_get_ninja_forms(),
                            'desc' => '<br />' . __('Choose a Ninja form <b>version 3.0</b> to use for Additional inquries/information.
<br />  Note: Form must have a submit button. Calculated fields, Recaptcha or Anti-Spam are ignored and can break the integration with this plugin.', 'rfqtk'),
                            'default' => '',
                            'id' => 'settings_gpls_woo_ninja_form_option'
                        ),

                        'settings_gpls_woo_rfq_ninja_form_position' => array(
                            'name' => '4- ' . __('Applicable to RFQ Checkout Only: Ninja Form Position in WooCommerce Checkout Page.', 'rfqtk'),
                            'type' => 'select',
                            'options' => array(
                                '1' => __('Before Customer Information', 'rfqtk'),
                                '2' => __('After Customer Information', 'rfqtk')),

                            'desc' => '<br />' . __('Applicable to RFQ Checkout Only. Choose position of the Ninja Form in the cart page.<br /> Your theme might not support all the positions or the placement might vary in your theme.', 'rfqtk'),
                            'default' => '1',
                            'id' => 'settings_gpls_woo_rfq_ninja_form_position'
                        ),

                        'ninja_section_end' => array(
                            'type' => 'sectionend',
                            'id' => 'settings_gpls_woo_rfq_ninja_section_end'
                        ),


                    );
                break;

            case 'customer-notes':
                $settings =

                    array(
                        'ninja_section_title' => array(
                            'name' => __('Allow customers to add notes to existing "quotes requests" and orders', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '<h4>' . __('Allow customers to add notes to existing "quotes requests" and orders. Notes notifies the shop manager.', 'rfqtk') . '</h4>',
                            'id' => 'settings_gpls_woo_rfq_add-to-note_section_title'
                        ),
                        'settings_gpls_woo_rfq_customer_note_text' => array(
                            'name' => '1- ' . __('Label For Adding a Note', 'rfqtk'),
                            'type' => 'text',
                            'desc' => '',
                            'default' => __('Add Notes', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_customer_note_text',
                            'css' => 'width:600px'
                        ),

                        'rfq_cart_sc_section_rfq_page_add_customer_note_button_background' => array(
                            'name' => '2- ' . __('Order Notes Button Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of add to order notes button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_customer_note_button_background',
                        ),

                        'rfq_cart_sc_section_rfq_page_add_customer_note_button_color' => array(
                            'name' => '3- ' . __('Add to Order Notes Button Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of Order Notes button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_customer_note_button_color',
                        ),
                        'rfq_cart_sc_section_rfq_page_add_customer_note_button_mouse_over_background' => array(
                            'name' => '4- ' . __('Add to Order Notes Button MouseOver Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of Order Notes button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_customer_note_button_mouse_over_background',
                        ),
                        'rfq_cart_sc_section_rfq_page_add_customer_note_button_mouse_over_color' => array(
                            'name' => '5-' . __('Add to Order Notes Button MouseOver Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of Order Notes button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_customer_note_button_mouse_over_color',
                        ),

                        'rfq_cart_sc_section_add_customer_note_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_section_add_customer_note_title_end'
                        ),


                    );
                break;

            case 'customer-offer':
                $settings = array(

                    'general_section_title' => array(
                        'name' => __('RFQ-ToolKit Customer Bid', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '<h4>' . __('Allow customers to make a bid on the whole cart while submitting a request for quote', 'rfqtk') . '</h4><h4>This plugin also allows you to set min/max quantities for each product.</h4><h4>You can also select a product to be an exclusive item. Exclusive item has to be the only item in the quote request.</h4><h2>The settings for each product can be by category ( in the category edit) or in product advanced setup</h2>',
                        'id' => 'settings_gpls_woo_rfq_customer_offer_section_title'
                    ),


                    'settings_gpls_woo_rfq_allow_customer_offer' => array(
                        'name' => '1- ' . __('Allow Customer to Make an Offer', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Allow the customer to make an offer on the whole cart.<br /> The offer price is saved in the order and included in the email messages', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_allow_customer_offer'
                    ),
                    'settings_gpls_woo_rfq_make_customer_offer_required' => array(
                        'name' => '2- ' . __('Make Customer Offer Required', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Make customer offer a requried field.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_make_customer_offer_required'
                    ),


                    'settings_gpls_woo_rfq_customer_offer_text' => array(
                        'name' => '3- ' . __('Label For Make an Offer', 'rfqtk'),
                        'type' => 'text',
                        'desc' => '',
                        'default' => __('Make an Offer!', 'rfqtk'),
                        'id' => 'settings_gpls_woo_rfq_customer_offer_text',
                        'css' => 'width:600px'
                    ),
                    'settings_gpls_woo_rfq_customer_offer_desc' => array(
                        'name' => '4- ' . __('HTML Content for Make an Offer', 'rfqtk'),
                        'type' => 'gpls_woo_html_editor',
                        'textarea_rows' => 10,
                        'desc' => __('Instructions to customer for making an offer.', 'rfqtk'),
                        'default' => 'Make an offer!',
                        'editor_css' => '<style>#wp-settings_gpls_woo_rfq_customer_offer_desc-wrap{height:100px; width:600px;}</style>',
                        'id' => 'settings_gpls_woo_rfq_customer_offer_desc',

                    ),
                    'settings_gpls_woo_rfq_customer_offer_checkout_position' => array(
                        'name' => '5- ' . __('RFQ Checkout Only: Customer Offer Checkout Page Position', 'rfqtk'),
                        'type' => 'select',
                        'options' => array(
                            '1' => __('Before Order Totals Review', 'rfqtk'),
                            '2' => __('After Order Totals Review', 'rfqtk'),
                            '3' => __('Before Customer Information', 'rfqtk'),
                            '4' => __('After Customer Information', 'rfqtk')),
                        'desc' => '<br />' . __('Choose position of customer offer in the checkout page.<br /> Your theme might not support all the positions or the placement might vary in your theme.', 'rfqtk'),
                        'default' => '1',
                        'id' => 'settings_gpls_woo_rfq_customer_offer_checkout_position'
                    ),
                    'settings_gpls_woo_rfq_quote_sent_email_customer_offer' => array(
                        'name' => '6- ' . __('Include the Customer Offer In Quote Sent Email', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Include the cutomer offer in the "Quote Sent" (proposal) email..', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_quote_sent_email_customer_offer'
                    ),

                    'settings_gpls_woo_rfq_customer_confirmation_section_end' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_offer_section_section_end'
                    )
                );
                break;


            case 'sales-staff':
                $settings = array(

                    'general_section_title' => array(
                        'name' => __('Sales Staff Settings', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '',
                        'id' => 'settings_gpls_woo_rfq_sales-staff_section_title'
                    ),
                    'settings_gpls_woo_rfq_allow_sales_staff_ip_filter' => array(
                        'name' => '1- ' . __('Enabled Sales Staff mode by IP address', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Enabled Sales Staff mode by IP address.<br /> In the RFQ mode sales staff can view prices, buy or create a quote at woocommerce checkut. In the normal checkout sales staff can see all the prices.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_allow_sales_staff_ip_filter'
                    ),

                    'settings_gpls_woo_sales_staff_ips' => array(
                        'name' => '2- ' . __('IP List', 'rfqtk'),
                        'type' => 'gpls_woo_text_area',
                        'desc' => __('Add IP addresses seperated by commas:. <br /> * Network ranges can be specified as:<ul> <li>Wildcard format:     1.2.3.*</li> <li>CIDR format:         1.2.3/24  OR  1.2.3.4/255.255.255.0</li><li>Start-End IP format: 1.2.3.0-1.2.3.255.</li></ul>', 'rfqtk'),
                        'default' => '',
                        'id' => 'settings_gpls_woo_sales_staff_ips',
                        'css' => 'width:600px;height:100px;vertical-align: top'
                    ),

                    'settings_gpls_woo_rfq_sales_staff_section_end' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_offer_section_section_end'
                    )


                );
                break;


            case 'rfq-toolkit-license':


                if (class_exists('GPLS_WOO_RFQ_PLUS')) {
                    $rfqtk_main_setting = array(
                        'name' => '',
                        'type' => 'title',
                        'desc' => '<a target="_blank" href="' . admin_url() . 'options-general.php?page=wc_api_manager_rfqtk_plus_dashboard">NP Quote Request WooCommerce Plus</a>',
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_lic_page',

                    );

                } else {
                    $rfqtk_main_setting = array();
                }


                if (class_exists('GPLS_WOO_RFQ_UPLOAD')) {

                    $rfqtk_upload_setting = array(
                        'name' => '',
                        'type' => 'title',
                        'desc' => '<a target="_blank" href="' . admin_url() . 'options-general.php?page=wc_api_manager_rfqtk_upload_dashboard">NP Quote Request WooCommerce - File Upload</a>',

                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_upload_lic_page',

                    );

                } else {
                    $rfqtk_upload_setting = array();
                }

                if (class_exists('GPLS_WOO_RFQ_FIELD')) {
                    $rfqtk_field_setting = array(
                        'name' => '',
                        'type' => 'title',
                        'desc' => '<a target="_blank" href="' . admin_url() . 'options-general.php?page=wc_api_manager_rfqtk_field_dashboard">NP Quote Request WooCommerce - Custom Product Fields</a>',
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_field_lic_page',

                    );

                } else {
                    $rfqtk_field_setting = array();
                }


                $settings =

                    array(
                        'general_lic_page_section_title' => array(
                            'name' => __('Manage RFQ-Toolkit License to recieve automatic product updates', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '<h4></h4>',
                            'id' => 'general_lic_page_section_title'
                        ),

                        'settings_gpls_woo_rfq_lic_page' => $rfqtk_main_setting,

                        'settings_gpls_woo_rfq_upload_lic_page' => $rfqtk_upload_setting,

                        'settings_gpls_woo_rfq_field_lic_page' => $rfqtk_field_setting,


                        'general_lic_page_section_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'general_lic_page_section_title_end'
                        ),


                    );
                break;


        }

        return $settings;

    }


    /**
     * @param $sections
     * @return mixed
     */


}

