<?php
if (!defined('ABSPATH'))
    exit;
/**
 * Main class
 *
 */
if (!class_exists('rfqtk_email_functions')) {

    class rfqtk_email_functions
    {
        function __construct()
        {

        }
    }

    /**
     * @return array
     */
    function gpls_woo_rfq_plus_get_stock_product_priority()
    {

    }

    add_action('woocommerce_order_status_changed', 'gplsrfq_change_to_sent', 10, 4);

    add_action('woo_rfq_delay_quote_hours_event', 'gplsrfq_change_to_sent_old', 10, 3);

    function gplsrfq_change_to_sent($order_id, $from, $to, $order)
    {
        $order = WC_Order_Factory::get_order($order_id);


        if (strcmp(trim($to), "gplsquote-req") != 0 ) {
            return;
        }

        $quote_sent = $order->get_meta('rfqtk_send_quote');

        if($quote_sent=="yes"){
            return;
        }

        if (get_option('settings_gpls_woo_rfq_change_to_sent', "no") == 'yes') {

            $delay = get_option('settings_gpls_woo_rfq_delay_quote_hours');

            if ($delay == "") {
                $delay = 0.1;
            }
            if (!wp_next_scheduled('woo_rfq_delay_quote_hours_event'))
            {
                $args = array($order_id, $from, $to);

                wp_schedule_single_event(time() + $delay * 60 * 60, 'woo_rfq_delay_quote_hours_event', $args);
            }
        }
    }



    function gplsrfq_change_to_sent_old($order_id, $from, $to)
    {
        $order = WC_Order_Factory::get_order($order_id);

        $quote_sent = $order->get_meta('rfqtk_send_quote');

        if($quote_sent=="yes"){
            return;
        }

        $order = WC_Order_Factory::get_order($order_id);



        if(strcmp(trim($to),"gplsquote-req")!=0){
            return;
        }



       // $order->update_status('wc-gplsquote-sent');
        $order->add_order_note(__("Order status changed from Quote Request to Quote Sent by NP Quote Plugin.","rfqtk"),0, false);
        // Update post 37
        $my_post = array(
            'ID'           => $order_id,
            'post_status'   => 'wc-gplsquote-sent',
        );

// Update the post into the database
        wp_update_post( $my_post );

        sleep(1);

        //$mail= new WC_Email_Product_Marketing();
        $email =  WC()->mailer()->emails['WC_Email_Customer_RFQ_Sent'];
        $mail= new WC_Email_Customer_RFQ_Sent();
        $mail->trigger( $order_id);

        //$order->set_status('wc-gplsquote-sent');
        update_post_meta($order_id,'rfqtk_send_quote',"yes");

    }





    function gpls_woo_rfq_plus_email_confirmation_stock_messages($order, $sent_to_admin, $plain_text)
    {

        $stock_email_confirmation_message = get_option('settings_gpls_woo_rfq_customer_confirmation_message', '');

       // echo '<br />'.$stock_email_confirmation_message ;

        echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">&nbsp;</div>';
        echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">' . $stock_email_confirmation_message, '</div>';
        echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">&nbsp;</div>';


    }


    function gpls_woo_rfq_plus_email_confirmation_product_messages($order, $sent_to_admin, $plain_text)
    {


        $items = $order->get_items();
        $message_array = array();
        foreach ($items as $item) {

            $_product = apply_filters('woocommerce_order_item_product', $order->get_product_from_item($item), $item);

            $product_email_confirmation_message = rftk_cat_has_meta($_product->get_id(), '_gpls_woo_rfq_plus_product_email_message', true);

            $show_product_email_confirmation_message = rftk_cat_has_meta($_product->get_id(), '_gpls_woo_rfq_plus_show_product_email_message', true);

            $hashed_message = md5($product_email_confirmation_message);
            //echo $hashed_message;
            if(!isset($message_array[$hashed_message])) {
                //echo $product_email_confirmation_message;
                $message_array[$hashed_message] = $product_email_confirmation_message;
            }


        }
        foreach ($message_array as $key=>$val) {

            // echo '<br />'.$product_email_confirmation_message;
            echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">&nbsp;</div>';
            echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">' . $val, '</div>';
            echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">&nbsp;</div>';

        }


    }


    function gpls_woo_rfq_plus_thankyou_confirmation_stock_messages($order_id)
    {

        $stock_email_confirmation_message = get_option('settings_gpls_woo_rfq_customer_confirmation_message', '');

        echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">&nbsp;</div>';
        echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">&nbsp;</div>';
        echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">' . $stock_email_confirmation_message, '</div>';
        echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">&nbsp;</div>';
        echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">&nbsp;</div>';

    }

    add_action('woo_rfq_delay_marketing_content_hours_event', 'gplsrfq_send_product_marketing_content', 10, 1);

    function gpls_woo_rfq_plus_thankyou_confirmation_product_messages($order_id)
    {

        $of= new WC_Order_Factory();

        $order = $of::get_order($order_id);

        if (strcmp(trim($order->get_status()), 'gplsquote-req') != 0) {
            return;
        }

        $items = $order->get_items();

        $message_array = array();

        foreach ($items as $item) {

            $_product = apply_filters('woocommerce_order_item_product', $order->get_product_from_item($item), $item);

            $product_email_confirmation_message = rftk_cat_has_meta($_product->get_id(), '_gpls_woo_rfq_plus_product_email_message', true);
            $show_product_email_confirmation_message = rftk_cat_has_meta($_product->get_id(), '_gpls_woo_rfq_plus_show_product_email_message', true);

            $hashed_message = md5($product_email_confirmation_message);
            //echo $hashed_message;
            if(in_array($hashed_message,$message_array) )  {
                //echo $product_email_confirmation_message;
                $message_array[$hashed_message] = array('_product'=>$_product->get_id(),'content'=>$product_email_confirmation_message);
            }
        }

        foreach ($message_array as $key=>$val) {
            // echo '<br />'.$product_email_confirmation_message;
            echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">&nbsp;</div>';
            echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">' . $val['content'], '</div>';
            echo '<div class="gpls_woo_thankyou" style="display:block; clear:both">&nbsp;</div>';
        }

        $send= get_option('gpls_woo_rfq_email_product_marketing_emails','no');

        if($send=="no"){
            return;
        }

        $delay = get_option('settings_gpls_woo_rfq_delay_product_marketing_hours');

        if ($delay == "") {
            $delay = 0.1 ;
        }

        if (!wp_next_scheduled('woo_rfq_delay_marketing_content_hours_event'))
        {
            $args = array($order_id);
            wp_schedule_single_event(time() + ($delay) * 60 * 60, 'woo_rfq_delay_marketing_content_hours_event', $args);
        }

    }


    function gplsrfq_send_product_marketing_content($order_id)
    {


        $of= new WC_Order_Factory();

        $order = $of::get_order($order_id);

        if (strcmp(trim($order->get_status()), 'gplsquote-req') != 0) {
          //  return;
        }


        $items = $order->get_items();

        $message_array = array();

        foreach ($items as $item) {

            $_product = apply_filters('woocommerce_order_item_product', $order->get_product_from_item($item), $item);

            $product_email_confirmation_message = rftk_cat_has_meta($_product->get_id(), '_gpls_woo_rfq_plus_product_email_message', true);
            $show_product_email_confirmation_message = rftk_cat_has_meta($_product->get_id(), '_gpls_woo_rfq_plus_show_product_email_message', true);

            $hashed_message = md5($product_email_confirmation_message);
            //echo $hashed_message;
            if(!isset($message_array[$hashed_message]) && $message_array[$hashed_message] == null)  {
                //echo $product_email_confirmation_message;
                $message_array[$hashed_message] = array('_product'=>$_product->get_id(),'content'=>$product_email_confirmation_message);
            }
        }

        foreach ($message_array as $key=>$val) {

            //$args = array($order_id,$val['_product'], $val['content']);

            sleep(1);

            $args = array('order_id' => $order_id,'_product' => $val['_product'],'prod_note' => $val['content']);

            //$mail= new WC_Email_Product_Marketing();
            $email =  WC()->mailer()->emails['WC_Email_Product_Marketing'];
            $mail= new WC_Email_Product_Marketing();
            $mail->trigger( $args);

            $order->add_order_note(__("Product Information Sent to Customer by NP Quote Plugin.","rfqtk"),0, false);


        }
    }

    //add_action('woo_rfq_delay_marketing_content_hours_event', 'gplsrfq_send_product_marketing_content', 10, 1);






    function gpls_woo_rfq_plus_email_order_meta_fields($fields, $sent_to_admin, $order)
    {
        $fields['meta_key'] = array(
            'label' => __('Label'),
            'value' => get_post_meta($order->get_id(), 'meta_key', true),
        );
        return $fields;
    }


    function gpls_woo_rfq_plus_customer_email_order_meta_display($order, $sent_to_admin, $plain_text)
    {

        $ninja_data = get_post_meta($order->get_id(), '_ninja_forms_fields', true);

        if ($ninja_data !=null && is_array($ninja_data)) {

            echo '<div  style="clear: both; margin-top:20px; height: 20px; display:block;"></div>';
            echo '<div  style="clear: both; margin-top:20px; display:block;;font-weight: bold"><h3>' . __('Checkout Fields', 'rfqtk') . '</h3></div><div style="float:left; height: ">';

            foreach ($ninja_data as $key) {
                echo '<strong>' . $key["label"] . '</strong><br />' . $key["value"] . '<br />';
            }
            echo '<br /></div>';
        }


        $notes=$order->get_customer_order_notes();
        if(count($notes) < 2)return;
        ?>

        <h3><?php echo __('Order Notes History', 'rfqtk') ?></h3>

        <?php
        foreach ($order->get_customer_order_notes() as $note) {
            printf('<span  style=" font-size:8pt ; color:grey"> %1$s at %2$s by %3$s</span>', date_i18n(wc_date_format(), strtotime($note->comment_date)), date_i18n(wc_time_format(), strtotime($note->comment_date)), $note->comment_author);
            echo '<div style="width: 75%; margin-bottom: 10px">' . $note->comment_content . '</div>';

        }


    }


    function gpls_woo_rfq_plus_email_order_meta_display($order, $sent_to_admin, $plain_text)
    {

      //  ob_start();

        $include_customer_notes = get_option('settings_gpls_woo_rfq_quote_sent_email_customer_notes','yes');;

        $include_notes_offer = get_option('settings_gpls_woo_rfq_quote_sent_email_customer_offer','yes');;


        ?>





        <?php
        if($include_customer_notes=='yes')
        {
            echo "<h4>".__('Order Notes', 'rfqtk')."</h4>";
            foreach ($order->get_customer_order_notes() as $note) {
                printf('<span  style=" font-size:8pt ; color:grey"> %1$s at %2$s by %3$s</span>', date_i18n(wc_date_format(), strtotime($note->comment_date)), date_i18n(wc_time_format(), strtotime($note->comment_date)), $note->comment_author);
                echo '<div style="width: 75%; margin-bottom: 10px">' . $note->comment_content . '</div>';

            }
        }

        if($include_notes_offer=='yes')
        {


            $customer_offer_text = __('Customer Bid', 'rfqtk');
            $customer_offer = get_post_meta($order->get_id(), '_woo_rfq_customer_bid', true);


            if (isset($customer_offer) && $customer_offer != '') {

                echo '<div  style="clear: both; margin-top:20px; height: 20px; display:block;"></div>';
                echo '<div  style="clear: both; margin-top:20px; display:block;"></div>';
echo '<div ><h4>' . $customer_offer_text . ':' . get_woocommerce_currency_symbol() . '' . get_post_meta($order->get_id(), '_woo_rfq_customer_bid', true) . '</h4></div>';
            }
        }

       /* $ninja_data = get_post_meta($order->get_id(), '_ninja_forms_fields', true);

          if ($ninja_data !=null && is_array($ninja_data)) {

              echo '<div  style="clear: both; margin-top:20px; height: 20px; display:block;"></div>';
              echo '<div  style="clear: both; margin-top:20px; display:block;;font-weight: bold"><h3>' . __('Checkout Fields', 'rfqtk') . '</h3></div><div style="float:left; height: ">';

              foreach ($ninja_data as $key) {
                  echo '<strong>' . $key["label"] . '</strong><br />' . $key["value"] . '<br />';
              }
              echo '<br /></div>';
          }*/

        //echo ob_get_clean();
    }


    function gpls_woo_rfq_plus_show_email_prices($show_prices)
    {
        return true;
    }








}

