<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WC_Email_Product_Marketing' ) ) :

/**
 * Customer Note Order Email.
 *
 * Customer note emails are sent when you add a note to an order.
 *
 * @class       WC_Email_admin_note
 * @version     2.3.0
 * @package     WooCommerce/Classes/Emails
 * @author      WooThemes
 * @extends     WC_Email
 */
class WC_Email_Product_Marketing extends WC_Email {

	/**
	 * Customer note.
	 *
	 * @var string
	 */
	public $prod_note;
    public $_product;

	/**
	 * Constructor.
	 */
	public function __construct() {


	    $this->id             = 'gpls_prod_marketing';
		$this->title          = __( 'RFQ-Toolkit Product Marketing', 'rfqtk' );
		$this->description    = __( 'Product Marketing emails are sent to to the customer after a customer asks for a quote request.', 'rfqtk' );
        $this->customer_email = false;
		$this->template_html  = 'emails/product-marketing.php';
		$this->template_plain = 'emails/plain/product-marketing.php';

        //$this->heading = $this->_product->get_title().__(' for request #({order_number}) on {order_date}. ', 'rfqtk');

        //$this->subject = $this->_product->get_title().__(' Information for request #({order_number}) - {order_date}', 'rfqtk');

        $this->content_intro = $this->format_string($this->get_option( 'content_intro' ));
        $this->email_type='html';
		// Triggers

            add_action('woocommerce_new_product_marketing_notification', array($this, 'trigger'));


        $this->customer_email = true;


		// Call parent constructor
		parent::__construct();

        $this->recipient = $this->get_option( 'recipient', get_option( 'admin_email' ) );
	}

	/**
	 * Trigger.
	 *
	 * @param array $args
	 */
	public function trigger( $args ) {

		if ( isset( $args ) ) {

			$defaults = array(
				'order_id'      => '',
				'prod_note' => '',
                '_product' => ''
			);

			$args = wp_parse_args( $args, $defaults );


			extract( $args );

			if ( $order_id && ( $this->object = wc_get_order( $order_id ) ) ) {
                $this->recipient = $this->object->get_billing_email();
				$this->prod_note = $prod_note;
                $this->_product  = $_product;

                $product = wc_get_product($_product);

                $this->heading = $product->get_title().__(' from {site_title}.<br /> Request #({order_number}) on {order_date}. ', 'rfqtk');

                $this->subject = $product->get_title().__(' from {site_title}. Request #({order_number}) - {order_date}', 'rfqtk');

                $this->find['order-date']      = '{order_date}';
				$this->find['order-number']    = '{order_number}';

				$this->replace['order-date']   = date_i18n( wc_date_format(), strtotime( $this->object->get_date_created() ) );
				$this->replace['order-number'] = $this->object->get_order_number();

                $order = WC_Order_Factory::get_order($order_id);

                $customer_name = $order->get_billing_first_name() . ' ' . $order->get_billing_last_name();

                $offer_subject='';

                if (!$this->is_enabled() || !$this->get_recipient()) {
                    return;
                }


                    $this->send($this->get_recipient(), $this->get_subject(), $this->get_content(), $this->get_headers(), null);



			} else {


				return ;
			}
		}




	}

	/**
	 * Get content html.
	 *
	 * @access public
	 * @return string
	 */
	public function get_content_html() {
		return wc_get_template_html( $this->template_html, array(
			'order'         => $this->object,
			'email_heading' => $this->get_heading(),
			'prod_note' => $this->prod_note,
			'_product'  => $this->_product,
			'sent_to_admin' => false,
			'plain_text'    => false,
			'email'			=> $this
		) );
	}

	/**
	 * Get content plain.
	 *
	 * @access public
	 * @return string
	 */
	public function get_content_plain() {
		return wc_get_template_html( $this->template_plain, array(
			'order'         => $this->object,
			'email_heading' => $this->get_heading(),
            'prod_note' => $this->prod_note,
            '_product'  => $this->_product,
			'sent_to_admin' => false,
			'plain_text'    => true,
			'email'			=> $this
		) );
	}

    public function init_form_fields()
    {
        $this->form_fields = array(
            'enabled' => array(
                'title' => __('Enable/Disable', 'rfqtk'),
                'type' => 'checkbox',
                'label' => __('Enable this email notification', 'rfqtk'),
                'default' => 'yes'
            ),

            'recipient'  => array(
                'title'       => __( 'Recipient(s)', 'woocommerce' ),
                'type'        => 'text',
                /* translators: %s: WP admin email */
                'description' => sprintf( __( 'Enter recipients (comma separated) for this email. Defaults to %s.', 'woocommerce' ), '<code>' . esc_attr( get_option( 'admin_email' ) ) . '</code>' ),
                'placeholder' => '',
                'default'     => '',
                'desc_tip'    => true,
            ),


            'subject' => array(
                'title' => __('Subject', 'rfqtk'),
                'type' => 'text',
                'description' => sprintf(__('This controls the email subject line. Leave blank to use the default subject: <code>%s</code>.', 'rfqtk'), $this->subject),
                'placeholder' => '',
                'default' => ''
            ),
            'heading' => array(
                'title' => __('Email Heading', 'rfqtk'),
                'type' => 'text',
                'description' => sprintf(__('This controls the main heading contained within the email notification. Leave blank to use the default heading: <code>%s</code>.', 'rfqtk'), $this->heading),
                'placeholder' => '',
                'default' => ''
            ),
            'content_intro' => array(
                'title' => __('Content Intro', 'rfqtk'),
                'type' => 'textarea',
                'description' => sprintf(__('This controls the first paragrah contained within the email notification.', 'rfqtk'), $this->heading),
                'placeholder' => '',
                'default' => 'Thanks for your inquiry',

            ),
            'email_type' => array(
                'title' => __('Email type', 'rfqtk'),
                'type' => 'select',
                'description' => __('Choose which format of email to send.', 'rfqtk'),
                'default' => 'html',
                'class' => 'email_type wc-enhanced-select',
                'options' => $this->get_email_type_options()
            )
        );
    }


}

endif;
$GLOBALS['WC_Email_Product_Marketing']=new WC_Email_Product_Marketing();
return $GLOBALS['WC_Email_Product_Marketing'];
