<?php

/**
 * Created by PhpStorm.
 * User: cneah
 * Date: 1/10/2016
 * Time: 2:57 PM
 */


function gplsrfqtk_after_calculate_totals($cart)
{

    $in_role=true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    if($enable_roles == "purchase" && is_user_logged_in()){
        $in_role=false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role=true;
            }
        }

    }


    $quote_request_limit = strval(get_option('settings_gpls_woo_rfq_plus_normal_checkout_limit', ''));
    $cart_total = WC()->cart->get_total('number');

    $limit = false;

    add_action('woocommerce_check_cart_items',  'gplsrfqtk_quote_request_removed_message', 100);

    if ( $in_role==true && $quote_request_limit > 0 && $quote_request_limit > strval($cart_total)
        && get_option('settings_gpls_woo_rfq_plus_normal_checkout', 'no') == 'yes') {

        $limit = true;

        add_filter('woocommerce_available_payment_gateways',  'gplsrfqtk_remove_quote_request', 1100, 1);
    }



}

function gplsrfqtk_limit_to_rfq_only_after_calculate_totals($cart)
{

    $settings_gpls_woo_rfq_limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', '');

    $items = WC()->cart->get_cart();

    $has_rfq = false;

    foreach ($items as $item => $values) {


        $_product = wc_get_product($values['product_id']);

        $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable',$rfq_enable,$_product->get_id());

        if ($rfq_enable == 'yes' ) {
            $has_rfq = true;
            break;
        }
    }




    if ($settings_gpls_woo_rfq_limit_to_rfq_only == "yes" && $has_rfq == true) {

        //add_action('woocommerce_check_cart_items',  'gplsrfqtk_quote_request_removed_message', 100);

        add_filter('woocommerce_available_payment_gateways',  'gplsrfqtk_only_quote_request', 2000, 1);

    }
    if ($settings_gpls_woo_rfq_limit_to_rfq_only == "yes" && $has_rfq != true) {

        //add_action('woocommerce_check_cart_items',  'gplsrfqtk_quote_request_removed_message', 100);

        add_filter('woocommerce_available_payment_gateways',  'gplsrfqtk_only_purchase', 2000, 1);
    }

}


function gplsrfqtk_quote_request_removed_message()
{

    $quote_request_limit_message = get_option('settings_gpls_woo_rfq_plus_normal_checkout_limit_message', '');
    $quote_request_limit_message = __($quote_request_limit_message, 'rfqtk');


    if ( $quote_request_limit_message != '') {
        wc_add_notice($quote_request_limit_message, 'notice');
    }

}


function gplsrfqtk_remove_quote_request($available_gateways)
{

    if (isset($_GET['pay_for_order'])) {
        unset($available_gateways['gpls-rfq']);
        return $available_gateways;
    }

    foreach ($available_gateways as $gateway_id => $gateway) {

        if ($gateway_id == 'gpls-rfq') {
            unset($available_gateways[$gateway_id]);
            return $available_gateways;
        }
    }

    return $available_gateways;

}

function gplsrfqtk_only_quote_request($available_gateways)
{

    if (isset($_GET['pay_for_order'])) {
        unset($available_gateways['gpls-rfq']);
        return $available_gateways;
    }

    //    add_action('woocommerce_check_cart_items', array($this, 'gplsrfqtk_quote_request_removed_message'), 100);

    foreach ($available_gateways as $gateway_id => $gateway) {

        if ($gateway_id != 'gpls-rfq') {
            unset($available_gateways[$gateway_id]);
            //  return $available_gateways;
        }
    }

    return $available_gateways;
}



function gplsrfqtk_only_purchase($available_gateways)
{

    if (isset($_GET['pay_for_order'])) {
        unset($available_gateways['gpls-rfq']);
        return $available_gateways;
    }

    foreach ($available_gateways as $gateway_id => $gateway) {

        if ($gateway_id == 'gpls-rfq') {
            unset($available_gateways[$gateway_id]);
            return $available_gateways;
        }
    }

    return $available_gateways;
}




class WC_Gateway_RFQ_Plus
{
    /**
     * Constructor
     */
    public function __construct()
    {



        $checkout_option = "";
        $purchase_or_quote = false;

        if (isset($GLOBALS["gpls_woo_rfq_checkout_option"])) {
            $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];
        }




        $in_role=true;

        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if($enable_roles != "no" && !is_user_logged_in()){
            $in_role=false;
        }

        if($enable_roles != "no" && is_user_logged_in()){
            $in_role=false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role=true;

                }
            }

        }


        if ($checkout_option == 'rfq' && $in_role==true
            && get_option('settings_gpls_woo_rfq_plus_normal_checkout', 'no') == 'yes'
            && (get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'yes'
                || get_option('settings_gpls_woo_rfq_show_prices_everywhere', 'no') == 'yes')
        ) {
            $purchase_or_quote = true;
        }



        $limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', '');


        $limit_by_role = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if ($purchase_or_quote == true) {
            add_action('woocommerce_check_cart_items', 'gplsrfqtk_quote_request_removed_message', 100);
        }

        if ($purchase_or_quote == true && $limit_to_rfq_only=="no") {

            if( ($limit_by_role =="others_purchase_only" || $limit_by_role =="purchase" || $limit_by_role =="no") && $in_role==true )
            {
                remove_filter('woocommerce_available_payment_gateways', 'gpls_rfq_remove_other_payment_gateways', 1000, 1);
                add_action('woocommerce_after_calculate_totals',  'gplsrfqtk_after_calculate_totals', 1000, 1);

                return;

            }
            if( ($limit_by_role =="others_purchase_only" || $limit_by_role =="no") && $in_role==false )
            {
                remove_filter('woocommerce_available_payment_gateways', 'gpls_rfq_remove_other_payment_gateways', 1000, 1);
                add_filter('woocommerce_available_payment_gateways',  'gplsrfqtk_only_purchase', 2000, 1);

                return;

            }




        }


        if ($purchase_or_quote == true && $limit_to_rfq_only=="yes") {
            remove_filter('woocommerce_available_payment_gateways', 'gpls_rfq_remove_other_payment_gateways', 1000, 1);
            add_action('woocommerce_after_calculate_totals',  'gplsrfqtk_limit_to_rfq_only_after_calculate_totals',1000,1);
            //add_action('woocommerce_check_cart_items', 'gplsrfqtk_quote_request_removed_message', 100);

            return;
        }

        if( $purchase_or_quote == false && $limit_by_role =="others_purchase_only" )
        {
            remove_filter('woocommerce_available_payment_gateways', 'gpls_rfq_remove_other_payment_gateways', 1000, 1);
            add_filter('woocommerce_available_payment_gateways',  'gplsrfqtk_only_purchase', 2000, 1);

            return;

        }



    }


    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


    /**
     * @param $_product
     */


}

?>