<?php
if (!defined('ABSPATH'))
    exit;
/**
 * Main class
 *
 */
if (!class_exists('rfqtk_notes_functions')) {

    class rfqtk_notes_functions
    {
        function __construct()
        {

            add_action('save_post', 'rfqtk_save_quote_sent_note', -100, 3);

            add_action('woocommerce_view_order', 'gpls_woo_rfq_plus_file_my_account_orders_notes', -10);
            add_action('woocommerce_view_order', 'gpls_woo_rfq_plus_add_customer_response', -1);

            add_filter('gpls_woo_rfq_customer_notes_styles', 'gpls_woo_rfq_add_to_note_create_styles', 10, 1);
            add_action('wp_dashboard_setup', 'gpls_woo_rfq_add_widget', 999);

            add_action('wp_dashboard_setup', 'gpls_woo_rfq_add_widget', 999);


            add_action('wp_loaded', 'gpls_woo_rfq_customer_response', 2000);

           add_action('wp_loaded', 'gpls_woo_rfq_plus_save_customer_note', 1000);


        }

    }

}



function gpls_woo_rfq_plus_save_customer_note()
{

    if (isset($_POST['order_id']) && $_POST['order_id'] != '') {



        if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'gpls_woo_rfq_Plus_customer_note_form_nonce')) {
            return;
        }

        $of = new WC_Order_Factory();
        $order = $of->get_order($_POST['order_id']);


        if (isset($_POST['gpls_woo_rfq_customer_note']) && trim($_POST["gpls_woo_rfq_customer_note"]) != '') {

            $admin_note = trim($_POST["gpls_woo_rfq_customer_note"]);

            $saved_note= $order->get_customer_order_notes();



            $saved_already=false;

            foreach($saved_note as $i => $item) {

                if ($item->comment_content==$admin_note){
                    $saved_already=true;
                }
            }


            if (!$saved_already) {

                gpls_woo_rfq_add_order_note($order, $admin_note, 1, true);

                do_action('woocommerce_new_admin_note', array('order_id' => $order->get_id(),
                    'accepted_offer' => false, 'customer_note' => $admin_note));

                do_action('gplsrfq_new_admin_note', $order->get_id(), $admin_note);
            }

        }

        if (isset($_POST['accept_offer'])) {

            $offer_accepted = get_post_meta($order->get_id(), '_gpls_accepted_offer', true);


            if ($offer_accepted == "yes") {

                return;
            }

            $Customer_accepted_offer_of = __('Customer accepted offer of ', "rfqtk");

            $accepted_offer_note = $Customer_accepted_offer_of . get_woocommerce_currency_symbol() . $order->get_total();

            gpls_woo_rfq_add_order_note($order, $accepted_offer_note,
                1, true);

            update_post_meta($order->get_id(), '_gpls_accepted_offer', "yes");

            update_post_meta($order->get_id(), '_gpls_accepted_offer_date', current_time('timestamp'));

            do_action('woocommerce_new_admin_note', array('order_id' => $_POST['order_id'], 'accepted_offer' => true,
                    'customer_note' => $accepted_offer_note));


            $new_status = get_option('settings_gpls_woo_rfq_accept_offer_order_status', 'no');
            //echo $manage_stock; exit;

              if (in_array($order->get_status(), array('wc-gplsquote-sent','gplsquote-sent'), true) == true) {
                  if (in_array($new_status, array('wc-pending', 'wc-processing', 'wc-completed'), true) == true) {

                      $order = WC_Order_Factory::get_order($order->get_id());
                      $order->set_status($new_status);
                      $order->save();

                      do_action('woocommerce_before_resend_order_emails', $order, 'customer_invoice');

                      // Send the customer invoice email.
                      WC()->payment_gateways();
                      WC()->shipping();
                      WC()->mailer()->customer_invoice($order);

                      // Note the event.
                      $order->add_order_note(__('Order details sent to customer.', 'rfqtk'), false, true);

                      do_action('woocommerce_after_resend_order_email', $order, 'customer_invoice');


                  }
              }

            do_action('gplsrfq_customer_accepted_offer', $order->get_id());
        }

        if (isset($_POST['gpls_woo_rfq_plus_customer_bid']) && $_POST['gpls_woo_rfq_plus_customer_bid'] != '') {

            update_post_meta($_POST['order_id'], '_woo_rfq_customer_bid', $_POST['gpls_woo_rfq_plus_customer_bid']);

            $of = new WC_Order_Factory();

            $order = $of::get_order($_POST['order_id']);

            //$order->add_order_note('Customer Offer ' . get_woocommerce_currency_symbol() . $_POST['gpls_woo_rfq_plus_customer_bid'],1,true);

            $order->update_meta_data('_woo_rfq_customer_bid', $_POST['gpls_woo_rfq_plus_customer_bid']);

            gpls_woo_rfq_add_order_note($order,'Customer Offer ' . get_woocommerce_currency_symbol() . $_POST['gpls_woo_rfq_plus_customer_bid'],1,true);
            //gpls_woo_rfq_add_order_note($order, $note, $is_customer_note = 0, $added_by_user = false)
            do_action('woocommerce_new_admin_note', array('order_id' => $order->get_id(),
                'accepted_offer' => false, 'customer_note' => 'Customer Offer ' . get_woocommerce_currency_symbol() . $_POST['gpls_woo_rfq_plus_customer_bid']));

            do_action('gplsrfq_new_admin_note', $order->get_id(), 'Customer Offer ' . get_woocommerce_currency_symbol() . $_POST['gpls_woo_rfq_plus_customer_bid']);






        }
    }

}




function gpls_woo_rfq_customer_response()
{
    if (isset($_REQUEST['respond_to_offer']) && isset($_REQUEST['id'])
        && strpos($_REQUEST['key'], 'wc_order_', 0) === 0) {


        $of = new WC_Order_Factory();
        $order = $of::get_order($_REQUEST['id']);
        $order_id = $_REQUEST['id'];


        if($order->get_order_key() == $_REQUEST['key']) {


            $offer_accepted_already = get_post_meta($order->get_id(), '_gpls_accepted_offer', true);


            if ($offer_accepted_already != "yes") {

                if (isset($_GET['accept_offer'])) {


                    if ($_GET['accept_offer'] == "true") {


                        $Customer_accepted_offer_of = __('Customer accepted offer of ', "rfqtk");

                        $accepted_offer_note = $Customer_accepted_offer_of . get_woocommerce_currency_symbol() . $order->get_total();

                        gpls_woo_rfq_add_order_note($order, $accepted_offer_note,
                            1, true);

                        $email =  WC()->mailer()->emails['WC_Email_Admin_Note'];
                        $mail= new WC_Email_Admin_Note();

                        $mail->trigger(   array('order_id' => $order_id,
                            'accepted_offer' => true,
                            'customer_note' => $accepted_offer_note) );

                        update_post_meta($order->get_id(), '_gpls_accepted_offer', "yes");

                        update_post_meta($order->get_id(), '_gpls_accepted_offer_date', current_time('timestamp'));

                       // do_action('woocommerce_new_admin_note', array('order_id' => $order_id,'accepted_offer' => true,'customer_note' => $accepted_offer_note));

                        $manage_stock = get_option('settings_gpls_woo_rfq_accept_offer_order_status', 'no');
                        //echo $manage_stock; exit;
                        $new_status = get_option('settings_gpls_woo_rfq_accept_offer_order_status', 'no');
                        //echo $manage_stock; exit;
                        if (in_array($new_status, array('wc-pending', 'wc-processing', 'wc-completed'), true) == true) {

                            $order = WC_Order_Factory::get_order($order->get_id());
                            $order->set_status($new_status);
                            $order->save();

                            do_action( 'woocommerce_before_resend_order_emails', $order, 'customer_invoice' );

                            // Send the customer invoice email.
                            WC()->payment_gateways();
                            WC()->shipping();
                            WC()->mailer()->customer_invoice( $order );

                            // Note the event.
                            $order->add_order_note( __( 'Order details sent to customer.', 'rfqtk' ), false, true );

                            do_action( 'woocommerce_after_resend_order_email', $order, 'customer_invoice' );

                        }


                        do_action('gplsrfq_customer_accepted_offer', $order->get_id());
                    }
                }
            }

            //include_once(ABSPATH . 'wp-content/plugins/rfqtk/woocommerce/woo-rfq/customer-respond.php');
            wc_get_template('woo-rfq/customer-respond.php');
            exit;
        }

    }
}


function gpls_woo_rfq_add_widget()
{
    global $wp_meta_boxes;
    wp_add_dashboard_widget('rfktoolkit_dashboard_recent_notes', __('RFQ-ToolKit recent customer notes', 'woocommerce'), 'gpls_woo_rfq_recent_notes');
}


function gpls_woo_rfq_recent_notes()
{
    global $wpdb;
    $comments = $wpdb->get_results("
					
			SELECT posts.ID, posts.post_title, comments.comment_author, comments.comment_ID, SUBSTRING(comments.comment_content,1,100) AS comment_excerpt,meta_key,meta_value
			FROM $wpdb->comments comments
			LEFT JOIN $wpdb->posts posts ON (comments.comment_post_ID = posts.ID)
            LEFt JOIN $wpdb->commentmeta commentmeta ON (comments.comment_ID =  commentmeta.comment_id)
			WHERE comments.comment_type = 'order_note' and comments.comment_content <>''
			and (posts.post_status='wc-gplsquote-req' or posts.post_status='wc-gplsquote-sent')
            and meta_key='note_added_by_customer' and meta_value=1
            ORDER BY comments.comment_date_gmt DESC
			LIMIT 10
		");

    if ($comments) {
        echo '<ul>';

        $order_fact = new WC_Order_Factory();

        foreach ($comments as $comment) {

            $order = $order_fact::get_order($comment->ID);

            $order_status = $order->get_status();
            // echo $order_status;

            if ($order_status == 'gplsquote-sent') {

                $order_status = get_option('settings_gpls_woo_rfq_quote_sent_label');
                $order_status = __($order_status, 'rfqtk');

                if (!isset($order_status)) {
                    $order_status = __('Quote Sent', 'rfqtk');
                }
            }

            if ($order_status == 'gplsquote-req') {

                $order_status = get_option('settings_gpls_woo_rfq_quote_request_label');
                $order_status = __($order_status, 'rfqtk');

                if (!isset($order_status)) {
                    $order_status = __('Quote Request', 'rfqtk');
                }
            }

            echo '<li >';

            $avatar = get_avatar($comment->comment_author, '32');

            if (isset($avatar)) {
                $avatar;
            }

            /* translators: %s: review author */
            //echo '<h4 class="meta"><a href="' . get_permalink( $comment->ID ) . '#comment-' . absint( $comment->ID ) . '">' . esc_html( apply_filters( 'rfktoolkit_dashboard_recent_notes', $comment->post_title, $comment ) ) . '</a> ' . sprintf( __( ' %s', 'rfqtk' ), esc_html( $comment->comment_author ) ) . '</h4>';
            ?>
            <h5><a class="link"
                   href="<?php echo admin_url('post.php?post=' . $order->get_id() . '&action=edit'); ?>"><?php printf(__('Order #%s', 'rfqtk'), $order->get_order_number() . ' ' . $order_status); ?></a>
                (<?php printf('<time datetime="%s">%s</time>', date_i18n('c', strtotime($order->get_date_created())), date_i18n(wc_date_format(), strtotime($order->get_date_created()))); ?>
                )<?php printf(__(' %s', 'rfqtk'), esc_html($comment->comment_author)) ?></h5>
            <?php
            echo '<blockquote style="background: #f6f2ec; padding:5px">' . wp_kses_data($comment->comment_excerpt) . '</blockquote></li>';

        }
        echo '</ul>';
    } else {
        echo '<p>' . __('There are no customer notes yet.', 'rfqtk') . '</p>';
    }
}


function gpls_woo_rfq_plus_file_my_account_orders_notes($order_id)
{

    $order_factory = new WC_Order_Factory();

    $order = $order_factory->get_order($order_id);


    echo '<ul class="order_notes">';
    $notes = $order->get_customer_order_notes();
    if ($notes) {

        foreach ($notes as $note) {

            $note_classes = array('note');
            $note_classes[] = get_comment_meta($note->comment_ID, 'is_customer_note', true) ? 'customer-note' : '';
            $note_classes[] = $note->comment_author === __('WooCommerce', 'rfqtk') ? 'system-note' : '';
            $note_classes = apply_filters('woocommerce_order_note_class', array_filter($note_classes), $note);
            ?>
            <li rel="<?php echo absint($note->comment_ID); ?>"
                class="<?php echo esc_attr(implode(' ', $note_classes)); ?>">
                <div class="note_content">
                    <?php echo wpautop(wptexturize(wp_kses_post($note->comment_content))); ?>
                </div>
                <p class="meta">
                    <abbr class="exact-date"
                          title="<?php echo $note->comment_date; ?>"><?php printf(__('added on %1$s at %2$s', 'rfqtk'), date_i18n(wc_date_format(), strtotime($note->comment_date)), date_i18n(wc_time_format(), strtotime($note->comment_date))); ?></abbr>
                    <?php if ($note->comment_author !== __('WooCommerce', 'rfqtk')) printf(' ' . __('by %s', 'rfqtk'), $note->comment_author); ?>

                </p>
            </li>
            <?php
        }

    } else {
        echo '<li>' . __('There are no notes yet.', 'rfqtk') . '</li>';
    }

    echo '</ul>';
}

function gpls_woo_rfq_add_to_note_create_styles($gpls_woo_rfq_upload_styles)
{


    $gpls_woo_rfq_page_update_button_styles = '';

    $gpls_woo_rfq_page_update_button_onmouseover_color = '';
    $gpls_woo_rfq_page_update_button_background_onmouseover = '';
    $gpls_woo_rfq_page_update_button_onmouseover = '';

    $gpls_woo_rfq_page_update_button_onmouseout_color = '';
    $gpls_woo_rfq_page_update_button_background_onmouseout = '';


    $gpls_woo_rfq_page_submit_button_styles = '';

    $gpls_woo_rfq_page_submit_button_onmouseover = '';
    $gpls_woo_rfq_page_submit_button_background_onmouseover = '';

    $gpls_woo_rfq_page_submit_button_onmouseout = '';
    $gpls_woo_rfq_page_submit_button_background_onmouseout = '';

    $gpls_woo_rfq_page_update_button_onmouseout = '';


    $rfq_cart_sc_section_rfq_page_update_cart_button_background = get_option('rfq_cart_sc_section_rfq_page_add_customer_note_button_background', '');

    if (($rfq_cart_sc_section_rfq_page_update_cart_button_background) != '') {

        $gpls_woo_rfq_page_update_button_styles .= "background-color:" . $rfq_cart_sc_section_rfq_page_update_cart_button_background . " !important;";

    }


    $rfq_cart_sc_section_rfq_page_update_cart_button_color = get_option('rfq_cart_sc_section_rfq_page_add_customer_note_button_color', '');

    if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_color) != '') {

        $gpls_woo_rfq_page_update_button_styles .= "color:" . $rfq_cart_sc_section_rfq_page_update_cart_button_color . " !important;";

    }


    $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background = get_option('rfq_cart_sc_section_rfq_page_add_customer_note_button_mouse_over_background', '');
    // echo $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background;

    if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background) != '') {

        $gpls_woo_rfq_page_update_button_background_onmouseover .= "this.style.background='" . $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background . "';";
        $gpls_woo_rfq_page_update_button_background_onmouseout .= "this.style.background='" . $rfq_cart_sc_section_rfq_page_update_cart_button_background . "';";

    }


    $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color = get_option('rfq_cart_sc_section_rfq_page_add_customer_note_button_mouse_over_color', '');

    if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color) != '') {

        $gpls_woo_rfq_page_update_button_onmouseover .= "this.style.color='" . $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color . "';";
        $gpls_woo_rfq_page_update_button_onmouseout .= "this.style.color='" . $rfq_cart_sc_section_rfq_page_update_cart_button_color . "';";

    }


    $gpls_woo_rfq_upload_styles = array(

        'gpls_woo_rfq_page_button_styles' => $gpls_woo_rfq_page_update_button_styles,

        'gpls_woo_rfq_page_button_onmouseover_color' => $gpls_woo_rfq_page_update_button_onmouseover_color,
        'gpls_woo_rfq_page_button_background_onmouseover' => $gpls_woo_rfq_page_update_button_background_onmouseover,

        'gpls_woo_rfq_page_button_onmouseout_color' => $gpls_woo_rfq_page_update_button_onmouseout_color,
        'gpls_woo_rfq_page_button_background_onmouseout' => $gpls_woo_rfq_page_update_button_background_onmouseout,

        'gpls_woo_rfq_page_button_onmouseover' => $gpls_woo_rfq_page_update_button_onmouseover,
        'gpls_woo_rfq_page_button_onmouseout' => $gpls_woo_rfq_page_update_button_onmouseout,


    );

    return $gpls_woo_rfq_upload_styles;


}


function rfqtk_save_quote_sent_note($post_id, $post, $update)
{


   // echo $post_id;
    //d($_POST);//exit;

    if (!isset($_POST['quote_sent_note_editor'])){
        return;
    }

    if (!isset($_POST["meta-box-nonce"]) || !wp_verify_nonce($_POST["meta-box-nonce"], "meta-box-nonce"))
      //  return $post_id;

    if (!current_user_can("edit_post", $post_id))
        return $post_id;

    if (defined("DOING_AUTOSAVE") && DOING_AUTOSAVE)
        return $post_id;


    if ('shop_order' != $post->post_type)
        return $post_id;

    // Check user has permission to edit
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }
    // check if there was a multisite switch before
    if (is_multisite() && ms_is_switched()) {
        return $post_id;
    }


    if (isset($_POST['quote_sent_note_editor']) && trim($_POST['quote_sent_note_editor']) != "") {

        update_post_meta($post_id, '_quote_sent_note', $_POST['quote_sent_note_editor']);
    }

    if (isset($_POST['include_proposal_pay_link'])) {

        update_post_meta($post_id, '_include_proposal_pay_link', "yes");
    } else {
        update_post_meta($post_id, '_include_proposal_pay_link', "no");
    }

    if (isset($_POST['include_respond_link'])) {

        update_post_meta($post_id, '_include_respond_link', "yes");
    } else {
        update_post_meta($post_id, '_include_respond_link', "no");
    }


    if (isset($_POST['include_accept_link'])) {

        update_post_meta($post_id, '_include_accept_link', "yes");
    } else {
        update_post_meta($post_id, '_include_accept_link', "no");
    }



    if (isset($_POST['gpls_woo_rfq_no_expire'])) {
        update_post_meta($post_id, '_gpls_woo_rfq_no_expire', "yes");
    } else {
        update_post_meta($post_id, '_gpls_woo_rfq_no_expire', "no");
    }


    if (isset($_POST['gpls_woo_rfq_email_sender']))
    {
        update_post_meta($post_id, '_gpls_woo_rfq_email_sender', $_POST['gpls_woo_rfq_email_sender']);
    }

    if (isset($_POST['gpls_woo_rfq_email_cc']))
    {
        update_post_meta($post_id, '_gpls_woo_rfq_email_cc', $_POST['gpls_woo_rfq_email_cc']);
    }

    if (isset($_POST['gpls_woo_rfq_email_reply']))
    {
        update_post_meta($post_id, '_gpls_woo_rfq_email_reply', $_POST['gpls_woo_rfq_email_reply']);
    }




    // handle your meta box input ...
}




function gpls_woo_rfq_add_order_note($order, $note, $is_customer_note = 0, $added_by_user = false)
{

    if (trim($note) == "") return 0;

    if (is_user_logged_in() && current_user_can('edit_shop_order', $order->get_id()) && $added_by_user) {
        $user = get_user_by('id', get_current_user_id());
        $comment_author = $user->display_name;
        $comment_author_email = $user->user_email;
    } else {
        $comment_author = __('Customer', 'rfqtk');
        $comment_author_email = strtolower(__('Customer', 'rfqtk')) . '@';
        $comment_author_email .= isset($_SERVER['HTTP_HOST']) ? str_replace('www.', '', $_SERVER['HTTP_HOST']) : 'noreply.com';
        $comment_author_email = sanitize_email($comment_author_email);
    }


    $comment_post_ID = $order->get_id();
    $comment_author_url = '';
    $comment_content = $note;
    $comment_agent = 'Customer';
    $comment_type = 'order_note';
    $comment_parent = 0;
    $comment_approved = 1;
    $commentdata = apply_filters('woocommerce_new_order_note_data', compact('comment_post_ID', 'comment_author', 'comment_author_email', 'comment_author_url', 'comment_content', 'comment_agent', 'comment_type', 'comment_parent', 'comment_approved'), array('order_id' => $order->get_id(), 'is_customer_note' => $is_customer_note));

    $comment_id = wp_insert_comment($commentdata);

    if ($is_customer_note) {
        add_comment_meta($comment_id, 'is_customer_note', 1);
    }

    if ($added_by_user) {
        add_comment_meta($comment_id, 'note_added_by_customer', 1);
    }


    return $comment_id;
}

function gpls_woo_rfq_plus_add_customer_response($order_id)
{

    //ob_start();


    wc_get_template('woo-rfq/myacct/cust-notes.php', array(

        'order_id' => $order_id

    ));


    echo '<div  style=" margin-top:5px;margin-bottom:5px; display:block;"><h3>&nbsp;</h3></div>';

    //echo ob_get_clean();

}