<?php


class rfq_page_plus_Widget extends WP_Widget {


    // Set up the widget name and description.
    public function __construct() {
        $widget_options = array( 'classname' => 'rfq_page_plus_Widget', 'description' => 'RFQ-Toolkit Widget' );
        parent::__construct( 'rfq_page_plus_Widget', 'RFQ-Toolkit Widget', $widget_options );



    }


    // Create the widget output.
    public function widget( $args, $instance ) {

        if(is_active_widget(false, false, $this->id_base)){
            //gpls_woo_rfq_cart_set('rfq_page_plus_Widget', "yes");
            set_transient( 'rfq_page_plus_Widget', "yes", 12 * HOUR_IN_SECONDS );

        }else{
           // gpls_woo_rfq_cart_set('rfq_page_plus_Widget', "no");
            delete_transient( 'rfq_page_plus_Widget' );
        }

        $title = apply_filters( 'widget_title', $instance[ 'title' ] );


        echo $args['before_widget'] . $args['before_title'] . $title . $args['after_title'];
       // ob_start();

      //  $gpls_woo_rfq_cart = gpls_woo_rfq_get_item(gpls_woo_rfq_cart_tran_key() . '_' . 'gpls_woo_rfq_cart');
        wc_get_template('woo-rfq/mini-rfq-cart.php');

     //   echo ob_get_clean();
        echo $args['after_widget'];
    }


    // Create the admin area widget settings form.
    public function form( $instance ) {
        $title = isset( $instance['title'] ) ? $instance['title'] : ''; ?>
        <p>
        <label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label>
        <input type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $title ); ?>" />
        </p><?php
    }


    // Apply settings to the widget instance.
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance[ 'title' ] = strip_tags( $new_instance[ 'title' ] );
        return $instance;
    }

}

// Register the widget.
function rfq_page_plus_register_quote_cart_widget() {
    register_widget('rfq_page_plus_Widget');
}
add_action( 'widgets_init', 'rfq_page_plus_register_quote_cart_widget' );

?>