<?php
if (!defined('ABSPATH'))
    exit;
/**
 * Main class
 *
 */

if (!class_exists('gpls_woo_rfq_plus_functions')) {

    class gpls_woo_rfq_plus_functions
    {

        function __construct()
        {

            $checkout_option = "";

            if (isset($GLOBALS["gpls_woo_rfq_checkout_option"])) {
                $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];
            }

            add_action('woocommerce_checkout_order_processed', 'gpls_woo_rfq_plus_capture_order_id', 10);

            add_filter('woocommerce_my_account_my_orders_actions', 'gpls_woo_rfq_my_account_my_orders_actions', 100, 2);

            add_filter('woocommerce_valid_order_statuses_for_payment', 'gpls_woo_rfq_valid_order_statuses_for_payment', 100, 2);

            add_action('admin_head', 'gpls_woo_rfq_add_custom_order_status_icon');

            add_shortcode('gpls-woo-rfq-quote-button', 'gpls_woo_rfq_quote_button_shortcode');

            $create_accounts = get_option('rfq_cart_sc_section_rfq_page_create_accounts', 'yes');

            if ($create_accounts == 'no') {
                remove_action('gpls_woo_create_an_account', 'gpls_woo_create_an_account_function', 10);
            }

            add_filter('woocommerce_locate_template', array($this, 'gpls_woo_rfq_pay_woocommerce_locate_template'), 1, 3);


            //if(!function_exists('add_gpls_rfq_toolkit_meta_boxes'))
            {
                add_action('add_meta_boxes', 'add_gpls_rfq_toolkit_meta_boxes', 100);
            }


            //do_action('woocommerce_add_order_item_meta', $item_id, $cart_item, $cart_item_key);
            add_action('woocommerce_new_order_item', 'gpls_woo_rfq_set_order_item_attributes', 10, 3);


            add_action('woocommerce_admin_order_item_values', 'gpls_woo_rfq_show_atts_in_admin_order', 10, 3);
            //add_action( 'woocommerce_before_order_itemmeta',  'gpls_woo_rfq_show_atts_in_admin_order', 10, 3 );


            add_action('woocommerce_admin_order_item_headers', 'gpls_woo_rfq_admin_order_item_header');


            add_action('gpls_woo_rfq_add_custom_products', "gpls_woo_rfq_add_bundled_product", 10, 2);
            add_action('gpls_woo_rfq_delete_custom_products', "gpls_woo_rfq_delete_bundled_product", 10);
            add_action('gpls_woo_rfq_add_to_order_custom_products', "gpls_woo_rfq_add_to_order_bundled_product", 10, 4);


            add_filter('woocommerce_loop_add_to_cart_link', 'gpls_woo_rfq_plus_add_to_cart_link_shop', -1000, 2);
            add_action('woocommerce_after_add_to_cart_button', 'gpls_woo_rfq_plus_after_add_to_cart_button', 1000);



            add_filter('gpls_woo_rfq_no_add_to_cart', 'gpls_woo_rfq_no_add_to_cart', 10, 3);


            add_action('save_post', 'gpls_woorfq_save_post_callback', -100, 3);

            add_action('save_post', 'gpls_woorfq_save_post_update_callback', 200, 3);


            add_filter('gpls_woo_rfq_after_shop_loop_item_filter', 'gpls_woo_rfq_after_after_shop_loop_item_filter_rftk', 100, 2);//
            add_filter('gplsrfq_hide_after_shop_loop_item', 'gpls_woo_rfq_hide_after_shop_loop_item_filter', 100, 2);//


            add_action('gpls_woo_rfq_woocommerce_after_add_to_rfq_cart_finished', 'gplsrfq_add_to_rfq_cart_finished', 100, 2);

            //  add_action('wp_loaded', 'gpls_woo_rfq_redirect_after_add_to_quote_cart_action', 100000);
            // add_filter('woocommerce_add_to_cart_redirect', 'gpls_woo_rfq_redirect_after_add_to_quote_cart',100,1);

            add_filter('gpls_woo_rfq_after_after_shop_loop_item_proceed', 'gpls_woo_rfq_after_shop_loop_item_rftk', 100, 1);

            add_action('woocommerce_thankyou', 'gpls_woo_payment_status', 100, 1);

            /**
             * Adds a new item into the Bulk Actions dropdown.
             */
            add_filter('bulk_actions-edit-shop_order', 'gpls_woo_rfq_shop_order_bulk_actions');

            add_filter('handle_bulk_actions-edit-shop_order', 'gpls_woo_rfq_handle_shop_order_bulk_actions', 10, 3);

            add_action('admin_notices', 'gpls_woo_rfq_bulk_admin_notices');

            add_action('gpls_woo_rfq_order_item_meta', 'gpls_woo_rfq_plus_order_item_meta', 1000, 3);

            add_filter('sanitize_text_field', 'gpls_rfq_sanitize_text_field', 1000, 2);

            // do_action('gpls_woo_rfq_add_to_cart_button_text_action',$custom_cart_button_text, $product, $rfq_checkout_mode);

            add_action('gpls_woo_rfq_add_to_cart_button_text_action', 'gplsrfq_add_to_cart_button_text_action', 1000, 3);


            add_filter('gpls_woo_rfq_custom_add_to_cart_button_text', 'gpls_woo_rfq_custom_add_to_cart_button_text_rftk', 100, 3);

            add_filter('gpls_woo_rfq_is_an_rfq_add_to_cart', 'gpls_woo_rfq_is_an_rfq_add_to_cart_rftk', 100, 9);

           // add_action('woocommerce_order_status_changed', 'gplsrfq_change_to_sent', 10, 4);


            //do_action( 'woocommerce_receipt_' . $order->get_payment_method(), $order->get_id() )

            if (!is_admin()) {
                add_filter('woocommerce_get_variation_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
                add_filter('woocommerce_cart_product_price', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
            }


            // if ($GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq" && !is_admin()) {
            if (!is_admin()) {
                add_filter('gpls_woo_rfq_get_price_hidden_html', 'gpls_woo_rfq_hide_price_function', 1000, 4);
                add_filter('gpls_woo_rfq_get_price_hidden_variation_html', 'gpls_woo_rfq_hide_price_function', 1000, 4);
                add_filter('gpls_woo_rfq_individual_price_hidden_variation_html', 'gpls_woo_rfq_hide_price_function', 1000, 4);
                add_filter('woocommerce_cart_item_subtotal', 'gpls_woo_rfq_hide_subtotal_price_function', 1000, 3);

                add_filter('woocommerce_cart_item_subtotal', 'gpls_woo_rfq_hide_subtotal_price_function', 1000, 3);

                add_filter('woocommerce_cart_subtotal', 'gpls_woo_rfqtk_hide_woocommerce_cart_subtotal', 1000, 3);

                add_filter('woocommerce_cart_subtotal', 'gpls_woo_rfqtk_hide_woocommerce_cart_subtotal', 1000, 3);

                add_filter('woocommerce_cart_tax_totals', 'gpls_woo_rfqtk_hide_tax_woocommerce_cart_subtotal', 1000, 2);

                add_filter('woocommerce_cart_total', 'gpls_woo_rfqtk_hide_woocommerce_cart_total', 1000, 1);

                add_filter('woocommerce_cart_total', 'gpls_woo_rfqtk_hide_woocommerce_cart_total', 1000, 1);

                add_filter('woocommerce_order_formatted_line_subtotal', 'gpls_woo_rfqtk_order_formatted_line_subtotal', 100, 3);
                add_filter('woocommerce_get_formatted_order_total', 'gpls_woo_rfqtk_get_formatted_order_total', 100, 2);
                add_filter('woocommerce_get_order_item_totals', 'gpls_woo_rfqtk_woocommerce_get_order_item_totals', 100, 2);

                add_filter('woocommerce_product_add_to_cart_text', 'gpls_woo_rfqtk_woo_custom_cart_button_text', 2000, 2);
                add_filter('woocommerce_product_single_add_to_cart_text', 'gpls_woo_rfqtk_woo_custom_cart_button_text', 2000, 2);


                ///////////////////////////////////////////////////////////////////////////////////////////////////////////////


                add_filter('woocommerce_get_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
                add_filter('woocommerce_sale_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
                add_filter('woocommerce_bundle_sale_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
                add_filter('woocommerce_bundle_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
                add_filter('woocommerce_grouped_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
                add_filter('woocommerce_bundled_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
                add_filter('woocommerce_variation_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
                add_filter('woocommerce_variable_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
                add_filter('woocommerce_free_sale_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
                add_filter('woocommerce_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);            //
                add_filter('woocommerce_get_variation_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);


                add_filter('woocommerce_product_is_on_sale', 'gpls_woo_rfqtk_product_is_on_sale', 1000, 2);
                add_filter('woocommerce_bundle_is_on_sale', 'gpls_woo_rfqtk_product_is_on_sale', 1000, 2);


                add_filter('woocommerce_get_variation_price', 'gpls_woo_rfqtk_individual_price_hidden_variation_html', 1000, 4);
                add_filter('woocommerce_get_variation_sale_price', 'gpls_woo_rfqtk_individual_price_hidden_variation_html', 1000, 4);
                add_filter('woocommerce_get_variation_regular_price', 'gpls_woo_rfqtk_individual_price_hidden_variation_html', 1000, 4);

                if(!isset($_POST['gpls-woo-rfq_checkout']) && !isset($_POST['woocommerce-process-checkout-nonce']))
                {
                    add_filter('woocommerce_get_price_excluding_tax', 'gpls_woo_rfqtk_individual_price_hidden_tax', 1000, 3);//remove at checkout
                    add_filter('woocommerce_get_price_including_tax', 'gpls_woo_rfqtk_individual_price_hidden_tax', 1000, 3);//remove at checkout
                }
            }


            add_action('woocommerce_checkout_order_processed', 'gpls_woo_rfq_woocommerce_RFQTK_only_add_to_cart', 1000);

            //add_filter( 'woocommerce_loop_add_to_cart_args', 'filter_woocommerce_loop_add_to_cart_args', 100, 2 );


            add_filter('woocommerce_thankyou_order_received_text', 'gpls_woo_woocommerce_plus_thankyou_order_received_text', 10, 2);

            add_filter('manage_posts_columns', 'rfqtk_Plus_columns_head');
            add_action('manage_posts_custom_column', 'rfqtk_Plus_columns_content', 10, 2);
            add_filter('manage_edit-product_sortable_columns', 'rfqtk_Plus_sortable_columns');
            add_filter( 'request', 'rfqtk_Plus_column_orderby') ;


            // apply_filters( 'woocommerce_shipping_rate_cost', $this->data['cost'], $this );
            // apply_filters( 'woocommerce_shipping_rate_taxes', $this->data['taxes'], $this );
            $url = $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
            $template_name = '/checkout/';
            if (strpos($url, $template_name) !== false) {
                if (!is_admin()) {
                    $hide_shipping = get_option('settings_gpls_woo_rfq_hide_shipping', 'no');

                    if ($hide_shipping == 'yes') {
                        add_filter('woocommerce_shipping_rate_cost', 'rftk_shipping_rate_cost', 100, 2);
                        add_filter('woocommerce_shipping_rate_taxes', 'rftk_shipping_rate_taxes', 100, 2);
                        add_action('wp_print_footer_scripts', 'rftk_header_css', 1000);
                    }
                }
            }


            add_action('wp_print_footer_scripts', 'rftk_add_to_quote_single_css', 1000);

            add_action('woocommerce_checkout_update_order_meta', 'rfqtk_get_proposal_order_items', 100, 2);


            add_action( 'rfqtk_woocommerce_checkout_create_order_line_item', 'rfqtk_prod_add_on_order_line_item' , 1000, 3 );
          //  add_filter( 'woocommerce_get_item_data', 'rfqtk_prod_add_on_get_item_data' , 100, 2 );

         //   add_filter('rfq_cart_get_item_data_action','rfqtk_cart_get_item_data_action',100,4);
            add_filter('woocommerce_get_item_data','rfqtk_cart_rfq_get_item_data_action',100,2);

            if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {
                $no_shipping= get_option("settings_gpls_woo_rfq_rfq_no_shipping","no");

                if($no_shipping=="yes") {

                    add_filter('woocommerce_cart_needs_shipping', 'gpls_woo_rfqtk_needs_shipping', 1000, 1);
                    add_action('woocommerce_package_rates', 'gpls_woo_rfqtk_show_hide_shipping_methods', 10, 2);
                    add_action('woocommerce_checkout_update_order_review', 'gpls_woo_rfqtk_refresh_shipping_methods');
                    add_action('woocommerce_review_order_before_payment', 'gpls_woo_rfqtk_payment_methods_trigger_update_checkout');
                }
            }
        }


        public function gpls_woo_rfq_pay_woocommerce_locate_template($template, $template_name, $template_path)
        {

            // global $woocommerce;

            $_template = $template;
            if (!$template_path)
                $template_path = WC()->template_url;

            $plugin_path = gpls_woo_rfq_plus_DIR . 'woocommerce/';

            // Look within passed path within the theme - this is priority
            $template = locate_template(
                array(
                    $template_path . $template_name,
                    $template_name
                )
            );

            if (!$template && file_exists($plugin_path . $template_name))
                $template = $plugin_path . $template_name;

            if (!$template)
                $template = $_template;

            return $template;
            // Return what we found

        }

    }


    function gpls_woo_rfqtk_needs_shipping($needs_shipping){

        $payment_method = 'gpls-rfq';

        $chosen_payment_method = WC()->session->get('chosen_payment_method');

        if ($payment_method == $chosen_payment_method) {
           return false;
        }

        return $needs_shipping;

    }

    function gpls_woo_rfqtk_show_hide_shipping_methods($rates, $package)
    {
        // HERE Define your targeted shipping method ID
        $payment_method = 'gpls-rfq';

        $chosen_payment_method = WC()->session->get('chosen_payment_method');

        if ($payment_method == $chosen_payment_method) {
            //unset($rates['flat_rate:12']);
            $rates = array();
           // add_filter('woocommerce_cart_needs_shipping', false, 1000);
        }

       // add_filter('woocommerce_cart_needs_shipping', true, 1000);

        return $rates;
    }


    function gpls_woo_rfqtk_payment_methods_trigger_update_checkout()
    {
        // jQuery code
        ?>
        <script type="text/javascript">
            (function ($) {
                $('form.checkout').on('change', 'input[name^="payment_method"]', function () {

                    $(document.body).trigger('update_checkout');
                });
            })(jQuery);
        </script>
        <?php
    }


    function gpls_woo_rfqtk_refresh_shipping_methods($post_data)
    {
        // HERE Define your targeted shipping method ID
        $payment_method = 'gpls-rfq';
        $bool = true;

        if (WC()->session->get('chosen_payment_method') === $payment_method)
            $bool = false;

        // Mandatory to make it work with shipping methods
        foreach (WC()->cart->get_shipping_packages() as $package_key => $package) {
            WC()->session->set('shipping_for_package_' . $package_key, $bool);
        }
        WC()->cart->calculate_shipping();
    }





    function rfqtk_cart_rfq_get_item_data_action($item_data,$cart_item){


        foreach ($item_data as $key => $data) {
            // Set hidden to true to not display meta on cart.
            if (isset($data['hidden'])) {
                unset($item_data[$key]);
                continue;
            }


            $item_data[$key]['key'] = isset($data['key']) && $data['key'] !=""  ? $data['key'] : $data['name'];

            $item_data[$key]['display'] = isset($data['display']) && $data['display'] !="" ? $data['display'] : $data['value'];

            if ( isset( $cart_item['addons'] ) && is_array($cart_item['addons']) && count($cart_item['addons']) >0 ) {

                $strip = false;

                if (!is_admin() && $GLOBALS["gpls_woo_rfq_checkout_option"] != "rfq") {

                    if ((get_option('settings_gpls_woo_rfq_normal_checkout_show_prices', 'no') == 'no'))
                    {
                        $strip = true;
                    }
                }
                if (!is_admin() && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq") {

                    if ((get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'no')) {
                        $strip = true;
                    }
                }

                if($strip == true) {
                    $item_data[$key]['key'] = str_replace(')', '', $item_data[$key]['key']);
                    $item_data[$key]['key'] = str_replace('(', '', $item_data[$key]['key']);
                }

            }

        }


        return $item_data;
    }


    function rfqtk_cart_get_item_data_action($item_data,$cart_item,$key,$data){
        if ( isset( $cart_item['addons'] ) && is_array($cart_item['addons']) && count($cart_item['addons']) >0 ) {

            $strip = false;

            if (!is_admin() && $GLOBALS["gpls_woo_rfq_checkout_option"] != "rfq") {

                if ((get_option('settings_gpls_woo_rfq_normal_checkout_show_prices', 'no') == 'no'))
                {
                    $strip = true;
                }
            }
            if (!is_admin() && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq") {

                if ((get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'no')) {
                    $strip = true;
                }
            }

            if($strip == true) {
                $item_data[$key]['key'] = str_replace(')', '', $item_data[$key]['key']);
                $item_data[$key]['key'] = str_replace('(', '', $item_data[$key]['key']);
            }

        }
        return $item_data;
    }



    function rfqtk_prod_add_on_get_item_data( $other_data, $cart_item ) {
        if ( ! empty( $cart_item['addons'] ) ) {
            foreach ( $cart_item['addons'] as $addon ) {


                $price = isset( $cart_item['addons_price_before_calc'] ) ? $cart_item['addons_price_before_calc'] : $addon['price'];
                $name  = $addon['name'];

                if ( 0 == $addon['price'] ) {
                    $name .= '';
                } elseif ( 'percentage_based' === $addon['price_type'] && 0 == $price ) {
                    $name .= '';
                } elseif ( 'percentage_based' !== $addon['price_type'] && $addon['price'] && apply_filters( 'woocommerce_addons_add_price_to_name', '__return_true' ) ) {
                    $name .= '<span class="woocommerce-Price-amount" style="inline-block !important"> (' . wc_price( rfqtk_prod_add_on_get_product_addon_price_for_display( $addon['price'], $cart_item['data'] ) ) . ')</span>';
                } else {
                    $_product = new WC_Product( $cart_item['product_id'] );
                    $_product->set_price( $price * ( $addon['price'] / 100 ) );
                    $name .= '<span class="woocommerce-Price-amount" style="inline-block !important"> (' . WC()->cart->get_product_price( $_product ) . ')</span>';
                }

                $other_data[] = array(
                    'name'    => $name,
                    'value'   => $addon['value'],
                    'display' => isset( $addon['display'] ) ? $addon['display'] : '',
                );
            }
        }

        return $other_data;
    }





    function rfqtk_prod_add_on_order_line_item( $item, $cart_item_key, $cart_item ) {




        //WCPADD
        if ( ! empty( $cart_item['addons'] ) ) {

            foreach ( $cart_item['addons'] as $addon ) {
                $key           = $addon['name'];
                $price_type    = $addon['price_type'];
                $product       = $item->get_product();

                $product_price = $product->get_price();
                $price         = html_entity_decode( strip_tags( wc_price( rfqtk_prod_add_on_get_product_addon_price_for_display( $addon['price'], $cart_item['data'] ) ) ) );

                if ( $addon['price'] && 'percentage_based' === $price_type && 0 != $product_price ) {
                    $price = html_entity_decode( strip_tags( wc_price( rfqtk_prod_add_on_get_product_addon_price_for_display( ( $product_price * ( $addon['price'] / 100 ) ) ) ) ) );
                }

                if ( $addon['price'] && apply_filters( 'woocommerce_addons_add_price_to_name', true ) ) {
                    $key .= '<span class="woocommerce-Price-amount" style="inline-block !important"> (' . $price . ')</span>';
                }


                if ( 'custom_price' === $addon['field_type'] )
                {
                    $addon['value'] = $addon['price'];
                }

                wc_add_order_item_meta($item->get_id(),$key, $addon['value']);

            }
        }

        //TMXPO
        $values = $cart_item;

        do_action( 'wc_epo_order_item_meta_before', $item, $cart_item_key, $values );

        if ( !empty( $values['tmcartepo'] ) ) {
            wc_add_order_item_meta($item->get_id(), '_tmcartepo_data', $values['tmcartepo'] );
            wc_add_order_item_meta($item->get_id(), '_tm_epo_product_original_price', array( $values['tm_epo_product_original_price'] ) );
            wc_add_order_item_meta($item->get_id(), '_tm_epo', array( 1 ) );
        }
        if ( !empty( $values['tmsubscriptionfee'] ) ) {
            wc_add_order_item_meta($item->get_id(), '_tmsubscriptionfee_data', array( $values['tmsubscriptionfee'] ) );
            wc_add_order_item_meta($item->get_id(), __( "Options Subscription fee", 'woocommerce-tm-extra-product-options' ), $values['tmsubscriptionfee'] );
        }
        if ( !empty( $values['tmcartfee'] ) ) {
            wc_add_order_item_meta($item->get_id(), '_tmcartfee_data', array( $values['tmcartfee'] ) );
        }

        do_action( 'wc_epo_order_item_meta', $item, $cart_item_key, $values );

    }





     function rfqtk_prod_add_on_get_product_addon_price_for_display( $price, $cart_item = null ) {
        $product = ! empty( $GLOBALS['product'] ) && is_object( $GLOBALS['product'] ) ? clone $GLOBALS['product'] : null;

        if ( '' === $price || '0' == $price ) {
            return;
        }

        $neg = false;

        if ( $price < 0 ) {
            $neg = true;
            $price *= -1;
        }

        if ( ( is_cart() || is_checkout() ) && null !== $cart_item ) {
            $product = wc_get_product( $cart_item->get_id() );
        }

        if ( is_object( $product ) ) {
            // Support new wc_get_price_excluding_tax() and wc_get_price_excluding_tax() functions.
            if ( function_exists( 'wc_get_price_excluding_tax' ) ) {
                $display_price = rfqtk_prod_add_on_get_product_addon_tax_display_mode() === 'incl' ? wc_get_price_including_tax( $product, array( 'qty' => 1, 'price' => $price ) ) : wc_get_price_excluding_tax( $product, array( 'qty' => 1, 'price' => $price ) );
            } else {
                $display_price = rfqtk_prod_add_on_get_product_addon_tax_display_mode() === 'incl' ? $product->get_price_including_tax( 1, $price ) : $product->get_price_excluding_tax( 1, $price );
            }
        } else {
            $display_price = $price;
        }

        if ( $neg ) {
            $display_price = '-' . $display_price;
        }

        return $display_price;
    }

    /**
     * Return tax display mode depending on context.
     *
     * @return string
     */
     function rfqtk_prod_add_on_get_product_addon_tax_display_mode() {
        if ( is_cart() || is_checkout() ) {
            return get_option( 'woocommerce_tax_display_cart' );
        }

        return get_option( 'woocommerce_tax_display_shop' );
    }





    function rfqtk_get_proposal_order_items($order_id, $data)
    {
        $the_order = WC()->order_factory->get_order($order_id);

        if (get_option("settings_gpls_woo_rfq_import_order_items_table", 'no') == "no"
            || $the_order->get_meta("settings_gpls_woo_rfq_order_table_imported", true) == "yes"
        ) {
              return;
        }



            $args = array(
                'the_order' => $the_order,
                'data' => $data,
                'plain_text' => false,

            );

            $template = $args['plain_text'] ? 'woo-rfq/rfqtk-proposal_order_detail.php' : 'woo-rfq/rfqtk-proposal_order_detail.php';

            wc_get_template($template, array('the_order' => $the_order, 'data' => $data));


    }


    function rftk_add_to_quote_single_css()
    {
        //$gpls_woo_rfq_file_add_to_quote_styles['gpls_woo_rfq_page_button_styles']
        global $product;

        if (!is_object($product)) {
            $product = wc_get_product(get_the_ID());
            if ($product == false) return;
        }

        if ($product == false || !is_single()) {
            return;
        }

        $gpls_woo_rfq_page_update_button_styles = '';


        $rfq_cart_sc_section_rfq_page_update_cart_button_background = get_option('rfq_cart_sc_section_rfq_page_add_to_quote_button_background', '');

        if (($rfq_cart_sc_section_rfq_page_update_cart_button_background) != '') {

            $gpls_woo_rfq_page_update_button_styles .= "background-color:" . $rfq_cart_sc_section_rfq_page_update_cart_button_background . " !important;";

        }


        $rfq_cart_sc_section_rfq_page_update_cart_button_color = get_option('rfq_cart_sc_section_rfq_page_add_to_quote_button_color', '');

        if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_color) != '') {

            $gpls_woo_rfq_page_update_button_styles .= "color:" . $rfq_cart_sc_section_rfq_page_update_cart_button_color . " !important;";

        }

//!important  str_replace("world","Peter","Hello world!");
        //    echo "<style>.gpls_rfq_css{" . $gpls_woo_rfq_page_update_button_styles . "}</style>";


        $no_add_to_cart = get_post_meta($product->get_id(), '_gpls_woo_rfq_no_add_to_cart', true);
        $no_add_to_cart_global = get_option('settings_gpls_woo_rfq_global_no_add_to_cart', '');



            if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                $no_add_to_cart = "no";
                $no_add_to_cart_global = "no";
            }


        $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        if ($no_add_to_cart == "yes" || ($no_add_to_cart_global == 'yes' && $rfq_enable == 'yes')) {
               echo "<style>.single_add_to_cart_button {display:none !important;}#woo_pp_ec_button_product {display:none !important;}.gpls_rfq_set{display:block !important;}</style>";
        }


//$("p").css({"background-color": "yellow", "font-size": "200%"});

        $rfq_product_script = "<script> 
jQuery(document).ready( function() {
    jQuery( '.gpls_rfq_set' ).addClass('gpls_rfq_css');
    jQuery( '.gpls_rfq_set' ).css({'color':'" . $rfq_cart_sc_section_rfq_page_update_cart_button_color . "'});
    jQuery( '.gpls_rfq_set' ).css({'background-color':'" . $rfq_cart_sc_section_rfq_page_update_cart_button_background . "'});
    
    jQuery( '.gpls_rfq_set' ).mouseover(function(){
        jQuery( '.gpls_rfq_set' ).removeClass('gpls_rfq_css');  
})
jQuery( '.gpls_rfq_set' ).mouseover(function(){
       // jQuery( '.gpls_rfq_set' ).addClass('gpls_rfq_css');  
});


} ); </script>";


        echo $rfq_product_script;






    }


    function rftk_header_css()
    {

        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        if (($GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq")) {

            if ($hide_all == 'yes') {

                foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {

                    $product = $cart_item['data'];

                    $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
                    $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

                    if ($rfq_enable == 'yes') {
                        echo "<style>.woocommerce-shipping-totals ,.shipping {display:none !important;}</style>";
                        echo "<script>jQuery( '.woocommerce-shipping-totals' ).attr('style','display: none !important');jQuery( '.shipping' ).attr('style','display: none !important');jQuery( '.shipping' ).hide()</script>";

                        //return;

                    }

                }


            } else {
                echo "<style>.woocommerce-shipping-totals {display:none !important;}</style>";
                echo "<script>jQuery( '.woocommerce-shipping-totals' ).attr('style','display: none !important')</script>";

            }
        }


    }

    function rftk_shipping_rate_cost($cost, $rate)
    {

        if (($GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq")) {

            $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

            if ($hide_all == 'yes') {

                foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {

                    $product = $cart_item['data'];

                    $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
                    $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

                    if ($rfq_enable == 'yes') {
                        return "";
                    }

                }
                return $cost;

            } else {
                return "";
            }
        }

        return $cost;
    }


    function rftk_shipping_rate_taxes($cost, $rate)
    {

        if (($GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq")) {

            $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

            if ($hide_all == 'yes') {

                foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {

                    $product = $cart_item['data'];

                    $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
                    $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

                    if ($rfq_enable == 'yes') {
                        return "";
                    }
                }
                return $cost;

            } else {
                return "";
            }
        }

        return $cost;
    }

    function rfqtk_Plus_sortable_columns($columns)
    {
        return wp_parse_args( array( '_gpls_woo_rfq_rfq_enable' => 'RFQ' ), $columns );

    }

    function rfqtk_Plus_columns_head($defaults)
    {
        $defaults['_gpls_woo_rfq_rfq_enable'] = 'RFQ';

        return $defaults;
    }
    function rfqtk_Plus_column_orderby( $vars ) {
        if ( isset( $vars['orderby'] ) && 'RFQ' == $vars['orderby'] ) {
            $vars = array_merge( $vars, array(
                'meta_key' => '_gpls_woo_rfq_rfq_enable',
                'orderby' => 'meta_value'
            ) );
        }

        return $vars;
    }


    function rfqtk_Plus_columns_content($column_name, $post_ID)
    {
        if ($column_name == '_gpls_woo_rfq_rfq_enable') {
            $size = get_post_meta($post_ID, '_gpls_woo_rfq_rfq_enable', true);
            $rfq_enable = get_post_meta($post_ID, '_gpls_woo_rfq_rfq_enable', true);
            $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $post_ID);
            $size = !isset($size) ? '' : $rfq_enable;
            if ($size == 'yes') {
                $size = 'X';
            } else {
                $size = '';
            }

            echo $size;
        }
    }


    function gpls_woo_woocommerce_plus_thankyou_order_received_text($message, $order)
    {

        if(is_object($order)==false || $order == null || $order == false ){
            return $message;
        }

        if ($order->get_status() == 'gplsquote-sent') {
            $confirmation_message = __('Your quote for request #' . $order->get_id(), 'rfqtk');

            return $confirmation_message;
        } else {
            return $message;
        }
    }


    function filter_woocommerce_loop_add_to_cart_args($args, $product)
    {

        $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        $args['attributes']['data-rfq-mode'] = $GLOBALS["gpls_woo_rfq_checkout_option"];
        $args['attributes']['data-rfq-enabled'] = $rfq_enable;
        return $args;
    }


    function gpls_woo_rfqtk_individual_price_hidden_html($product_price, $product)
    {

        if (is_admin()) return;

        $temp_price = $product_price;

        $hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);


            if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                $hide_price = "no";
            }


        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        $in_role = true;
        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if ($enable_roles == "purchase" ) {
            $in_role = false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;
                }
            }

        }


        if ($in_role == false || $hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes')) {

            $temp_price = '';
        }
        return $temp_price;
    }


    function gpls_woo_rfqtk_individual_price_hidden_variation_html($price, $product, $min_or_max, $display)
    {

        if ($product->get_type() == 'external') {
            return $price;
        }

        $temp_price = $price;

        $hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);


            if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                $hide_price = "no";
            }



        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());


        $in_role = true;
        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if ($enable_roles == "purchase" ) {
            $in_role = false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;
                }
            }

        }
        if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

            $temp_price = '';
        }
        return $temp_price;


    }


    function gpls_woo_rfqtk_product_is_on_sale($is_on_sale, $product)
    {

        if ($product->get_type() == 'external') {
            return $is_on_sale;
        }

        $temp_price = $is_on_sale;

        $hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);


            if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                $hide_price = "no";
            }



        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());


        $in_role = true;
        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if ($enable_roles == "purchase" ) {
            $in_role = false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;
                }
            }

        }


        if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

            $temp_price = false;
        }
        return $temp_price;
    }


    function gpls_woo_rfqtk_woo_custom_cart_button_text($product_add_to_cart_text, $product)
    {

//global $product;


        if ($product->get_type() == 'external') {
            return $product_add_to_cart_text;
        }

        if (($product->get_type() == 'variable') && !is_product()) {

            return $product_add_to_cart_text;//"In RFQ"

        }


        $limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', 'no');

        $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        $default_text = __('Add to Quote', 'rfqtk');


        if ($limit_to_rfq_only == "yes" && $rfq_enable == "yes" && $GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq") {

            $add_txt = get_option('rfq_cart_wordings_add_to_rfq', $default_text);

            $product_add_to_cart_text = __($add_txt, 'rfqtk');

        }

        return $product_add_to_cart_text;

    }

    function gpls_woo_rfq_woocommerce_RFQTK_only_add_to_cart()
    {

        remove_filter('woocommerce_get_variation_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_cart_product_price', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('gpls_woo_rfq_get_price_hidden_html', 'gpls_woo_rfq_hide_price_function', 1000, 4);
        remove_filter('gpls_woo_rfq_get_price_hidden_variation_html', 'gpls_woo_rfq_hide_price_function', 1000, 4);
        remove_filter('gpls_woo_rfq_individual_price_hidden_variation_html', 'gpls_woo_rfq_hide_price_function', 1000, 4);
        remove_filter('woocommerce_cart_item_subtotal', 'gpls_woo_rfq_hide_subtotal_price_function', 1000, 3);
        remove_filter('woocommerce_cart_item_subtotal', 'gpls_woo_rfq_hide_subtotal_price_function', 1000, 3);
        remove_filter('woocommerce_cart_subtotal', 'gpls_woo_rfqtk_hide_woocommerce_cart_subtotal', 1000, 3);
        remove_filter('woocommerce_cart_subtotal', 'gpls_woo_rfqtk_hide_woocommerce_cart_subtotal', 1000, 3);
        remove_filter('woocommerce_cart_tax_totals', 'gpls_woo_rfqtk_hide_tax_woocommerce_cart_subtotal', 1000, 2);
        remove_filter('woocommerce_cart_total', 'gpls_woo_rfqtk_hide_woocommerce_cart_total', 1000, 1);
        remove_filter('woocommerce_cart_total', 'gpls_woo_rfqtk_hide_woocommerce_cart_total', 1000, 1);
        remove_filter('woocommerce_order_formatted_line_subtotal', 'gpls_woo_rfqtk_order_formatted_line_subtotal', 100, 3);
        remove_filter('woocommerce_get_formatted_order_total', 'gpls_woo_rfqtk_get_formatted_order_total', 100, 2);
        remove_filter('woocommerce_get_order_item_totals', 'gpls_woo_rfqtk_woocommerce_get_order_item_totals', 100, 2);
        remove_filter('woocommerce_checkout_order_processed', 'gpls_woo_rfq_woocommerce_RFQTK_only_add_to_cart', 1000);


        remove_filter('woocommerce_get_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_sale_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_bundle_sale_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_bundle_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_grouped_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_bundled_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_variation_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_variable_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_free_sale_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);
        remove_filter('woocommerce_free_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);            //
        remove_filter('woocommerce_get_variation_price_html', 'gpls_woo_rfqtk_individual_price_hidden_html', 1000, 2);


        remove_filter('woocommerce_product_is_on_sale', 'gpls_woo_rfqtk_product_is_on_sale', 1000, 2);
        remove_filter('woocommerce_bundle_is_on_sale', 'gpls_woo_rfqtk_product_is_on_sale', 1000, 2);


        remove_filter('woocommerce_get_variation_price', 'gpls_woo_rfqtk_individual_price_hidden_variation_html', 1000, 4);
        remove_filter('woocommerce_get_variation_sale_price', 'gpls_woo_rfqtk_individual_price_hidden_variation_html', 1000, 4);
        remove_filter('woocommerce_get_variation_regular_price', 'gpls_woo_rfqtk_individual_price_hidden_variation_html', 1000, 4);

        remove_filter('woocommerce_get_price_excluding_tax', 'gpls_woo_rfqtk_individual_price_hidden_tax', 1000, 3);//remove at checkout
        remove_filter('woocommerce_get_price_including_tax', 'gpls_woo_rfqtk_individual_price_hidden_tax', 1000, 3);//remove at checkout


    }

    function gpls_woo_rfqtk_woocommerce_get_order_item_totals($total_rows, $order)
    {
        $temp_price = $total_rows;

        $in_role = true;
        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if ($enable_roles == "purchase" ) {
            $in_role = false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;
                }
            }

        }

        foreach ($order->get_items() as $item_id => $item_product) {
            //Get the product ID
            $product_id = $item_product->get_product_id();
            //Get the WC_Product object
            $_product = $item_product->get_product();
            //Get the product SKU (using WC_Product method)

            $hide_price = get_post_meta($_product->get_id(), '_gpls_woo_rfq_hide_price', true);


                if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                    $hide_price = "no";
                }


            $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

            $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
            $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());


            if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

                $temp_price = array();
                break;
            }

        }
        return $temp_price;
    }


    //
    function gpls_woo_rfqtk_get_formatted_order_total($formatted_total, $order)
    {


        $temp_price = $formatted_total;

        $in_role = true;
        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if ($enable_roles == "purchase" ) {
            $in_role = false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;
                }
            }

        }

        foreach ($order->get_items() as $item_id => $item_product) {
            //Get the product ID
            $product_id = $item_product->get_product_id();
            //Get the WC_Product object
            $_product = $item_product->get_product();
            //Get the product SKU (using WC_Product method)

            $hide_price = get_post_meta($_product->get_id(), '_gpls_woo_rfq_hide_price', true);


                if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                    $hide_price = "no";
                }


            $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

            $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
            $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

            if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {
                $temp_price = '';
                break;
            }

        }

        return $temp_price;

    }

//
    function gpls_woo_rfqtk_order_formatted_line_subtotal($subtotal, $item, $order)
    {

        $temp_price = $subtotal;


        //Get the product ID
        $product_id = $item->get_product_id();
        //Get the WC_Product object
        $_product = $item->get_product();
        //Get the product SKU (using WC_Product method)

        $hide_price = get_post_meta($_product->get_id(), '_gpls_woo_rfq_hide_price', true);


            if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                $hide_price = "no";
            }



        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        //  echo $_product->get_id().' '.$hide_price.' '.$hide_all.' '.$rfq_enable.'<br />';

        $in_role = true;
        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if ($enable_roles == "purchase" ) {
            $in_role = false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;
                }
            }

        }

        if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

            $temp_price = '';

        }


        return $temp_price;


    }


    function gpls_woo_rfqtk_hide_woocommerce_cart_total($price)
    {

        $temp_price = $price;

        $items = WC()->cart->get_cart();
        $product_names = array();

        $in_role = true;
        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if ($enable_roles == "purchase" ) {
            $in_role = false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;
                }
            }

        }

        foreach ($items as $item => $values) {

            $_product = wc_get_product($values['product_id']);

            $hide_price = get_post_meta($_product->get_id(), '_gpls_woo_rfq_hide_price', true);


                if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                    $hide_price = "no";
                }


            $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

            $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
            $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

            if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

                $temp_price = '';
                break;
            }

        }

        return $temp_price;

    }


    function gpls_woo_rfqtk_hide_tax_woocommerce_cart_subtotal($tax_totals, $cart)
    {

        $temp_price = $tax_totals;

        $items = WC()->cart->get_cart();
        $product_names = array();

        $in_role = true;
        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if ($enable_roles == "purchase" ) {
            $in_role = false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;
                }
            }

        }


        foreach ($items as $item => $values) {


            $_product = wc_get_product($values['product_id']);

            $hide_price = get_post_meta($_product->get_id(), '_gpls_woo_rfq_hide_price', true);


                if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                    $hide_price = "no";
                }


            $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

            $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
            $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

            if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

                $temp_price = array();
                break;
            }

        }
        return $temp_price;
    }

    function gpls_woo_rfqtk_hide_woocommerce_cart_subtotal($cart_subtotal, $compound, $cart)
    {


        $temp_price = $cart_subtotal;

        $items = WC()->cart->get_cart();
        $product_names = array();

        $in_role = true;
        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if ($enable_roles == "purchase" ) {
            $in_role = false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;
                }
            }

        }

        foreach ($items as $item => $values) {


            $_product = wc_get_product($values['product_id']);

            $hide_price = get_post_meta($_product->get_id(), '_gpls_woo_rfq_hide_price', true);


                if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                    $hide_price = "no";
                }


            $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

            $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
            $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

            if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

                $temp_price = '';
                break;
            }

        }

        return $temp_price;
    }


    function gpls_woo_rfq_hide_price_total($subtotal, $item, $order)
    {


        $temp_price = $subtotal;
        $hide_price = get_post_meta($item->get_id(), '_gpls_woo_rfq_hide_price', true);


            if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                $hide_price = "no";
            }


        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        $rfq_enable = get_post_meta($item->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $item->get_id());


        $in_role = true;
        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if ($enable_roles == "purchase" ) {
            $in_role = false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;
                }
            }

        }


        if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

            $temp_price = '';
        }
        return $temp_price;
    }


    function gpls_woo_rfq_hide_price_function($temp_price, $price, $product, $rfq_enable)
    {




        $hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);


            if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                $hide_price = "no";
            }


        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        $in_role = true;
        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if ($enable_roles == "purchase" ) {
            $in_role = false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;
                }
            }

        }


        if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {

            $temp_price = '';
        }
        return $temp_price;
    }


    function gpls_woo_rfq_hide_subtotal_price_function($subtotal, $cart_item, $cart_item_key)
    {

        $temp_price = $subtotal;

        $_product = wc_get_product($cart_item['data']->get_id());


        $hide_price = get_post_meta($_product->get_id(), '_gpls_woo_rfq_hide_price', true);


            if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                $hide_price = "no";
            }



        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $in_role = true;
        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if ($enable_roles == "purchase" ) {
            $in_role = false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;
                }
            }

        }


        if ($hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes') || $in_role == false) {
            $temp_price = '';
        }
        return $temp_price;
    }


   //apply_filters( 'woocommerce_get_price_including_tax', $return_price, $qty, $product );

    function gpls_woo_rfqtk_individual_price_hidden_tax($product_price,$qty, $product)
    {

        if (is_admin()) return;

        $temp_price = $product_price;

        $hide_price = get_post_meta($product->get_id(), '_gpls_woo_rfq_hide_price', true);


            if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                $hide_price = "no";
            }


        $hide_all = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices', 'no');

        $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        $in_role = true;
        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        if ($enable_roles == "purchase" ) {
            $in_role = false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;

            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;
                }
            }

        }


        if ($in_role == false || $hide_price == 'yes' || ($hide_all == 'yes' && $rfq_enable == 'yes')) {

            $temp_price = '';
        }
        return $temp_price;
    }


    function gplsrfq_add_to_rfq_cart_finished($product_id, $is_set)
    {

        if ($is_set == "no") {
            return;
        }

        $product = wc_get_product($product_id);
        $redirect = 'no';


        if (get_option('rfq_cart_sc_redirect_after_add') == 'yes') {
            $redirect = 'yes';
        }

        if ( 'yes' === get_option( 'woocommerce_cart_redirect_after_add' ) ) {
            $redirect = 'yes';
        }

        if ($redirect == 'yes') {

            $url_new = get_option('rfq_cart_sc_section_show_link_to_rfq_page', '');//"In RFQ";

            if ($url_new != '') {

                $gpls_woo_rfq_cart = gpls_woo_rfq_get_item(gpls_woo_rfq_cart_tran_key() . '_' . 'gpls_woo_rfq_cart');

                if (count($gpls_woo_rfq_cart) > 0) {

                    $ajax_cart_en = get_option('woocommerce_enable_ajax_add_to_cart', 'no');

                    if ($ajax_cart_en =="yes" && !isset($_POST["rfq_single_product"])) {
                        $data = array(
                            'location' => $url_new);
                        wp_send_json_success($data);
                    } else {
                        wp_safe_redirect($url_new);
                        exit;
                    }
                }
            }
        }




    }

    function gplsrfq_add_to_cart_button_text_action($add_txt, $product, $rfq_checkout_mode)
    {

    }


    function gpls_woo_rfq_shop_order_bulk_actions($actions)
    {
        if (isset($actions['edit'])) {
            unset($actions['edit']);
        }

        $actions['mark_gplsquote-sent'] = __('Mark quote sent', 'rfqtk');

        return $actions;
    }

    function gpls_woo_rfq_handle_shop_order_bulk_actions($redirect_to, $action, $ids)
    {
        // Bail out if this is not a status-changing action.
        if (false === strpos($action, 'mark_')) {
            return $redirect_to;
        }

        $order_statuses = wc_get_order_statuses();
        $new_status = substr($action, 5); // Get the status name from action.
        $report_action = 'marked_' . $new_status;

        // Sanity check: bail out if this is actually not a status, or is
        // not a registered status.
        if (!isset($order_statuses['wc-' . $new_status])) {
            return $redirect_to;
        }

        $changed = 0;
        $ids = array_map('absint', $ids);

        foreach ($ids as $id) {
            $order = wc_get_order($id);
            $order->update_status($new_status, __('Order status changed by bulk edit:', 'rfqtk'), true);
            do_action('woocommerce_order_edit_status', $id, $new_status);
            $changed++;
        }

        $redirect_to = add_query_arg(array(
            'post_type' => 'shop_order',
            $report_action => true,
            'changed' => $changed,
            'ids' => join(',', $ids),
        ), $redirect_to);

        return esc_url_raw($redirect_to);
    }


    function gpls_woo_rfq_bulk_admin_notices()
    {
        global $post_type, $pagenow;

        // Bail out if not on shop order list page
        if ('edit.php' !== $pagenow || 'shop_order' !== $post_type) {
            return;
        }

        $order_statuses = wc_get_order_statuses();

        // Check if any status changes happened
        foreach ($order_statuses as $slug => $name) {

            if (isset($_REQUEST['marked_gplsquote-sent'])) {

                $number = isset($_REQUEST['changed']) ? absint($_REQUEST['changed']) : 0;
                /* translators: %s: orders count */
                $message = sprintf(_n('Order status changed.', '%s order statuses changed.', $number, 'rfqtk'), number_format_i18n($number));
                echo '<div class="updated"><p>' . $message . '</p></div>';

                break;
            }
        }
    }

    function gpls_woo_payment_status($order_id)
    {

        $order = WC_Order_Factory::get_order($order_id);

        if(is_object($order)==false || $order == null || $order == false ){
            return;
        }


        if ($order->get_meta('_gpls_woo_is_quote') == 'yes') {

            $current_date = get_option('settings_gpls_woo_rfq_order_date', 'no');
            if ($order->get_status() == 'processing' || $order->get_status() == 'completed') {
                if ($current_date == 'yes') {
                    $order->set_date_created(current_time('mysql', 0));
                    $order->add_order_note(__('Order Date set to payment date by RFQ-ToolKit.', 'rfqtk'), false, true);
                    $order->save();
                }

                gpls_woo_rfq_add_order_note($order, __('Customer accepted offer of ', 'rfqtk') . get_woocommerce_currency_symbol() . $order->get_total(), 1, true);

                do_action('woocommerce_new_admin_note', array('order_id' => $order_id, 'customer_note' => __('Customer accepted offer of', 'rfqtk') . get_woocommerce_currency_symbol() . $order->get_total()));


            }
        }


    }

    function gpls_woo_rfq_change_posted_date($order_id, $old_status, $new_status, $order)
    {

        $order = wc_get_order($order_id);
        $order = WC_Order_Factory::get_order($order_id);

        if ($new_status == "completed" && ($old_status == "gplsquote-sent" || $old_status == "gplsquote-req")) {

            $order->set_date_created(current_time('mysql', 0));
            $order->add_order_note(__('Order Date set to date order completed by RFQ-ToolKit.', 'rfqtk'), false, true);
            $order->save();

        }
        return;
    }


    function gpls_woo_rfq_after_shop_loop_item_rftk($proceed)
    {
        if (get_option('gpls_woo_rfq_after_after_shop_loop_item_proceed', 'yes') == 'no') {
            $proceed = false;
        } else {
        }
        return $proceed;
    }


    function gpls_rfq_sanitize_text_field($filtered, $str)
    {
        return sanitize_textarea_field($str);
    }


    function gpls_woo_rfq_custom_add_to_cart_button_text_rftk($add_txt, $product, $checkout)
    {

        if (function_exists('wp_get_current_user')) {

            if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {

                $default_text = __('Add to Quote', 'rtfk');

                $add_txt = get_option('rfq_cart_wordings_add_to_rfq', $default_text);

                $add_txt = __($add_txt, 'rtfk');
            }
        }
        return $add_txt;

    }


    function gpls_woo_rfq_is_an_rfq_add_to_cart_rftk($is_an_rfq, $REQUEST, $cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data, $rfq_enable)
    {

        if (function_exists('wp_get_current_user')) {
            if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
                $is_an_rfq = true;
            }
        }

        return $is_an_rfq;

    }


    function gpls_woo_rfq_after_after_shop_loop_item_filter_rftk($is_an_rfq, $product)
    {

        if (function_exists('wp_get_current_user')) {
            if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
                $is_an_rfq = true;
            }
        }


        return $is_an_rfq;

    }


    function gpls_woo_rfq_hide_after_shop_loop_item_filter($hide, $product)
    {


        if (get_option('settings_gpls_woo_rfq_only_on_single_page_normal', 'no') == 'yes') {
            if (!is_product()) {
                $hide = true;
            }
        }

        return $hide;

    }


    function gpls_woorfq_save_post_update_callback($post_id, $post, $update)
    {

        if (!wp_is_post_revision($post_id)) {


            if ($post->post_type == 'product') {

                $settings_gpls_woo_rfq_cats_new_prods = get_option('settings_gpls_woo_rfq_cats_new_prods');
                $option_value_list = explode(',', $settings_gpls_woo_rfq_cats_new_prods);



                $product = wc_get_product($post_id);

                $category_ids = $product->get_category_ids('');


                foreach ($category_ids as $cat_id) {

                    $term = get_term_by('id', $cat_id, 'product_cat');

                    if (in_array(trim($term->name), $option_value_list)) {

                        $default_set = get_post_meta($product->get_id(), '_gpls_woo_rfq_cat_default_rfq_enable', true);

                        if ($default_set != "yes") {
                            update_post_meta($post_id, '_gpls_woo_rfq_rfq_enable', 'yes');

                            update_post_meta($post_id, '_gpls_woo_rfq_cat_default_rfq_enable', 'yes');
                        }


                    }
                }
                // d($category_ids);
                //exit;
            }


            if ($post->post_type == 'product') {

                $settings_gpls_woo_rfq_cats_new_prods = get_option('settings_gpls_woo_rfq_cats_new_enable_product_messages');
                $option_value_list = explode(',', $settings_gpls_woo_rfq_cats_new_prods);

                $product = wc_get_product($post_id);

                $category_ids = $product->get_category_ids('');

                foreach ($category_ids as $cat_id) {

                    $term = get_term_by('id', $cat_id, 'product_cat');

                    if (in_array(trim($term->name), $option_value_list)) {

                        $default_set = get_post_meta($product->get_id(), '_gpls_woo_rfq_show_product_message_default_enable', true);

                        if ($default_set != "yes") {

                            update_post_meta($post_id, "_gpls_woo_rfq_plus_show_product_email_message", 'yes');

                            update_post_meta($post_id, "_gpls_woo_rfq_plus_show_product_thankyou_message", 'yes');

                            update_post_meta($post_id, '_gpls_woo_rfq_show_product_message_default_enable', 'yes');
                        }

                    }
                }
                // d($category_ids);
                //exit;
            }


        }

    }


    function gpls_woorfq_save_post_callback($post_id, $post, $update)
    {

        if ($update) {
            //return;
        }

        if (wp_is_post_revision($post_id)) {
            // return;
        }


        if ('product' != $post->post_type && 'shop_order' != $post->post_type)
            return;

//Grab our initial meta value, if set will return true else wordpress will return and empty string(falsey)

        if ($post->post_type == 'product') {


            $settings_gpls_woo_rfq_rfq_enable_default = get_option('settings_gpls_woo_rfq_rfq_enable_default');

            if ($settings_gpls_woo_rfq_rfq_enable_default == 'yes') {
                update_post_meta($post_id, '_gpls_woo_rfq_rfq_enable', 'yes');
            } else {
                update_post_meta($post_id, '_gpls_woo_rfq_rfq_enable', 'no');
            }

            $settings_gpls_woo_rfq_no_add_to_cart_default = get_option('settings_gpls_woo_rfq_no_add_to_cart_default', "no");

            if ($settings_gpls_woo_rfq_no_add_to_cart_default == 'yes') {
                update_post_meta($post_id, '_gpls_woo_rfq_no_add_to_cart', 'yes');
            } else {
                update_post_meta($post_id, '_gpls_woo_rfq_no_add_to_cart', 'no');
            }


            $settings_gpls_woo_rfq_hide_price_default = get_option('settings_gpls_woo_rfq_hide_price_default', "no");

            if ($settings_gpls_woo_rfq_hide_price_default == 'yes') {
                update_post_meta($post_id, '_gpls_woo_rfq_hide_price', 'yes');
            } else {
                update_post_meta($post_id, '_gpls_woo_rfq_hide_price', 'no');
            }
        }


        if ($post->post_type == 'shop_order') {

            $settings_gpls_woo_rfq_pay_default = get_option('settings_gpls_woo_rfq_pay_default');
            if ($settings_gpls_woo_rfq_pay_default == 'yes') {

                if (!metadata_exists('post', $post_id, '_include_proposal_pay_link')) {
                    update_post_meta($post_id, '_include_proposal_pay_link', 'yes');
                }
            }


            $settings_gpls_woo_rfq_respond_default = get_option('settings_gpls_woo_rfq_respond_default');
            if ($settings_gpls_woo_rfq_respond_default == 'yes') {

                if (!metadata_exists('post', $post_id, '_include_respond_link')) {
                    update_post_meta($post_id, '_include_respond_link', 'yes');
                }
            }

            $settings_gpls_woo_rfq_accept_default = get_option('settings_gpls_woo_rfq_accept_default');
            if ($settings_gpls_woo_rfq_accept_default == 'yes') {

                if (!metadata_exists('post', $post_id, '_include_accept_link')) {
                    update_post_meta($post_id, '_include_accept_link', 'yes');
                }
            }

            $settings_gpls_woo_rfq_default_proposal = get_option('settings_gpls_woo_rfq_default_proposal_content');

            if (!metadata_exists('post', $post_id, '_quote_sent_note')) {
                update_post_meta($post_id, '_quote_sent_note', $settings_gpls_woo_rfq_default_proposal . '<br/>');

            }

            if (isset($_POST['gpls_woo_rfq_email_sender'])) {
                update_post_meta($post_id, '_gpls_woo_rfq_email_sender', $_POST['gpls_woo_rfq_email_sender']);
            }

            if (isset($_POST['gpls_woo_rfq_email_cc'])) {
                update_post_meta($post_id, '_gpls_woo_rfq_email_cc', $_POST['gpls_woo_rfq_email_cc']);
            }

            if (isset($_POST['gpls_woo_rfq_email_reply'])) {
                update_post_meta($post_id, '_gpls_woo_rfq_email_reply', $_POST['gpls_woo_rfq_email_reply']);
            }

        }

    }


    function gpls_woo_rfq_plus_order_item_meta($item_id, $cart_item, $cart_item_key)
    {

        if (isset($cart_item['ppom']['fields'])) {
            $extra_options = ($cart_item['ppom']['fields']);

            if ($extra_options) {
                foreach ($extra_options as $name => $data) {

                    if ($name != "id") {
                        wc_add_order_item_meta($item_id, $name, trim(stripslashes($data)));
                    }
                }
            }
        }

    }


    /*function gpls_woo_rfq_redirect($url)
    {

        $redirect = false;

        if (function_exists('wp_get_current_user')) {
            if (get_option('rfq_cart_sc_redirect_after_add_visitor') == 'yes' && !wp_get_current_user()->exists()) {
                $redirect = 'yes';
            }
        }

        if (get_option('rfq_cart_sc_redirect_after_add') == 'yes') {
            $redirect = 'yes';
        }

        if ($redirect == 'yes') {

            $url_new = $redirect_page = get_option('rfq_cart_sc_redirect_after_add_url');//"In RFQ";
           // wc_clear_notices();
//rfq_cart_sc_redirect_after_add_url

            if ($url_new != '') {
                $url = $url_new;
            }
        }
        return $url;
    }*/


    function gpls_woo_rfq_redirect_after_add_to_quote_cart_action()
    {


        if (!isset($_REQUEST['add-to-cart'])) {
            return;
        }

        if ($GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq") {
            return;
        }


        $product_id = $_REQUEST['add-to-cart'];

        $product = wc_get_product($product_id);

        $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());


        if ($rfq_enable != "yes") {
            return;
        }

        //if ($is_an_rfq == true)
        {

            if ($rfq_enable == "yes") {
                $redirect = 'no';

                if (function_exists('wp_get_current_user')) {
                    if (get_option('rfq_cart_sc_redirect_after_add_visitor') == 'yes' && !wp_get_current_user()->exists()) {
                        $redirect = 'yes';
                    }
                }

                if (get_option('rfq_cart_sc_redirect_after_add') == 'yes') {
                    $redirect = 'yes';
                }

                if ($redirect == 'yes') {

                    $url_new = get_option('rfq_cart_sc_redirect_after_add_url', '');//"In RFQ";

                    if ($url_new != '') {
                        wp_safe_redirect($url_new);
                        exit;
                    }
                } else {
                    return;
                }
            }
        }


    }

    function gpls_woo_rfq_no_add_to_cart($remove, $product, $normal_check)
    {

        $no_add_to_cart = get_post_meta($product->get_id(), '_gpls_woo_rfq_no_add_to_cart', true);
        $no_add_to_cart_global = get_option('settings_gpls_woo_rfq_global_no_add_to_cart', '');


            if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                $no_add_to_cart = "no";
                $no_add_to_cart_global = "no";
            }


        $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());

        $result = false;


        if ($no_add_to_cart == "yes" || ($no_add_to_cart_global == 'yes' && $rfq_enable == 'yes')) {
             // $result = "yes";
        }


        return $result;

    }


    function gpls_woo_rfq_plus_add_to_cart_link_shop($link, $product)
    {


        $no_add_to_cart = get_post_meta($product->get_id(), '_gpls_woo_rfq_no_add_to_cart', true);
        $no_add_to_cart_global = get_option('settings_gpls_woo_rfq_global_no_add_to_cart', '');


            if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                $no_add_to_cart = "no";
                $no_add_to_cart_global = "no";
            }


        $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());


        $no_archive = get_option('settings_gpls_woo_rfq_only_on_single_page_rfq', 'no');

        if ($no_add_to_cart == 'yes' || $no_archive == 'yes' || ($no_add_to_cart_global == 'yes' && $rfq_enable == 'yes')) {
            return '';
        }

        return $link;
    }

    function gpls_woo_rfq_plus_after_add_to_cart_button()
    {

        global $product;
        if (!is_object($product)) {
            $product = wc_get_product(get_the_ID());
            if ($product == false) return;
        }

        if ($product->get_type() == 'external') {
            return;
        }
        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {
            return;
        }


        $proceed = true;

        $proceed = apply_filters('proceed_to_add_to_quote_button', $proceed, $product);


        if ($proceed == false) return;

        $no_add_to_cart = get_post_meta($product->get_id(), '_gpls_woo_rfq_no_add_to_cart', true);
        $no_add_to_cart_global = get_option('settings_gpls_woo_rfq_global_no_add_to_cart', '');


            if (gpls_woo_rfq_plus_check_staff_mode() == "yes") {
                $no_add_to_cart = "no";
                $no_add_to_cart_global = "no";
            }


        $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product->get_id());


        if ($no_add_to_cart == 'yes' || ($no_add_to_cart_global == 'yes' && $rfq_enable == 'yes')) {

            if (!is_admin()) {

                add_action('wp_print_footer_scripts', 'gpls_woo_rfq_print_script_hide_single_add', 9);
                add_action('wp_add_inline_script', 'gpls_woo_rfq_print_script_hide_single_add', 9);
                add_action('wp_enqueue_script', 'gpls_woo_rfq_print_script_hide_single_add', 9);

                $rfq_product_script = "<script> jQuery( '.single_add_to_cart_button' ).hide();jQuery( '.single_add_to_cart_button' ).attr('style','display: none');
jQuery( '#woo_pp_ec_button_product' ).hide();jQuery( '#woo_pp_ec_button_product' ).attr('style','display: none');
jQuery( '.gpls_rfq_set' ).show();jQuery( '.gpls_rfq_set' ).attr('style','display: block !important');
jQuery(window ).load( function() { jQuery( '.single_add_to_cart_button' ).hide();jQuery( '.single_add_to_cart_button' ).attr('style','display: none');
jQuery( '.gpls_rfq_set' ).show();jQuery( '.gpls_rfq_set' ).attr('style','display: block !important');
} ); </script>";

                echo $rfq_product_script;


                echo "<style>.single_add_to_cart_button {display:none !important;}#woo_pp_ec_button_product {display:none !important;}.gpls_rfq_set{display:block !important;}</style>";
            }

        }


    }


    function gpls_woo_rfq_print_script_hide_single_add()
    {
        if (!is_admin()) {


            $url_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk.js';
            $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk.js';
            wp_enqueue_script('gpls_woo_rfq_plus_js', $url_js, array('jquery'), filemtime($url_js_path), true);


            $custom_js =" jQuery( '.single_add_to_cart_button' ).hide();jQuery( '.single_add_to_cart_button' ).attr('style','display: none');
jQuery( '#woo_pp_ec_button_product' ).hide();jQuery( '#woo_pp_ec_button_product' ).attr('style','display: none');
jQuery( '.gpls_rfq_set' ).show();jQuery( '.gpls_rfq_set' ).attr('style','display: block !important');
jQuery(window ).load( function() { jQuery( '.single_add_to_cart_button' ).hide();jQuery( '.single_add_to_cart_button' ).attr('style','display: none');
jQuery( '.gpls_rfq_set' ).show();jQuery( '.gpls_rfq_set' ).attr('style','display: block !important')});";

            wp_add_inline_script('gpls_woo_rfq_plus_js', $custom_js);

            $rfq_product_script = "<script> jQuery( '.single_add_to_cart_button' ).hide();jQuery( '.single_add_to_cart_button' ).attr('style','display: none');
jQuery( '#woo_pp_ec_button_product' ).hide();jQuery( '#woo_pp_ec_button_product' ).attr('style','display: none');
jQuery( '.gpls_rfq_set' ).show();jQuery( '.gpls_rfq_set' ).attr('style','display: block !important');
jQuery(window ).load( function() { jQuery( '.single_add_to_cart_button' ).hide();jQuery( '.single_add_to_cart_button' ).attr('style','display: none');
jQuery( '.gpls_rfq_set' ).show();jQuery( '.gpls_rfq_set' ).attr('style','display: block !important');}); </script>";


            echo $rfq_product_script;

            $url_css = gpls_woo_rfq_plus_URL . 'assets/css/rfqtk.css';
            $url_css_path = gpls_woo_rfq_plus_DIR . 'assets/css/rfqtk.css';
            wp_enqueue_style('gpls_woo_rfq_plus_css', $url_css, array(), filemtime($url_css_path));


            $custom_css = ".single_add_to_cart_button {display:none !important;}#woo_pp_ec_button_product {display:none !important;}.gpls_rfq_set{display:block !important;} ";
            wp_add_inline_style('gpls_woo_rfq_plus_css', $custom_css);
        }

    }

    function gpls_woo_rfq_add_to_order_bundled_product($_product, $cart_item, $cart_item_key, $item_id)
    {

        if (isset($cart_item['bundled_items'])) {

            global $order;
            global $gpls_woo_rfq_cart;


            $order_items = $_product->get_bundled_items();

            $temp_items = array();

            $add_order = false;

            foreach ($order_items as $item) {


                $bundled_item_id = $item->item_id;

                $_product_bundle = wc_get_product($item->item_data['product_id']);


                $product_id_bundle = $bundled_item_id;

                if (!$item->is_priced_individually()) {
                    $_product_bundle->set_price(0);
                } else {
                    //wc_add_order_item_meta($item_id, '_price', $_product_bundle->product->get_price());
                }

                $cart_bundled_items = $gpls_woo_rfq_cart[$cart_item_key]['bundled_items'];


                $add_order = false;

                foreach ($cart_bundled_items as $cart_bundled_item) {
                    $tmp_bundled_item_id = ($gpls_woo_rfq_cart[$cart_bundled_item]['bundled_item_id']);
                    if ($bundled_item_id == $tmp_bundled_item_id) {
                        $add_order = true;
                        break;
                    }

                }


                if ($add_order == true) {
                    $item_bundle_id = $order->add_product($_product_bundle, $cart_item['quantity']);

                    wc_add_order_item_meta($_product->get_id(), '_bundled_by', 'yes');

                    if (!$_product->contains('priced_individually')) {
                        wc_add_order_item_meta($item_bundle_id, '_per_product_pricing', $_product->contains('priced_individually'));
                        wc_add_order_item_meta($item_bundle_id, '_per_product_shipping', $_product_bundle->is_sold_individually());
                    }
                }

            }
            $temp_items['bundled_items'] = $order_items;
            wc_add_order_item_meta($item_id, '_bundled_items', $temp_items['bundled_items']);
            wc_add_order_item_meta($item_id, '_bundle_cart_key', $cart_item_key);

        }

    }


    function gpls_woo_rfq_delete_bundled_product()
    {

        global $gpls_woo_rfq_cart;
        if (isset($gpls_woo_rfq_cart[$_REQUEST['man-deleted']]['bundled_items'])) {

            foreach ($gpls_woo_rfq_cart as $key => $values) {

                if (isset($values['bundled_by']) && $values['bundled_by'] == $_REQUEST['man-deleted']) {

                    unset($gpls_woo_rfq_cart[$key]['data']);
                    unset($gpls_woo_rfq_cart[$key]);

                }

            }

        }
    }


    function gpls_woo_rfq_add_bundled_product($product, $cart_item_key)
    {

        global $gpls_woo_rfq_cart;

        if ($product->get_type() == 'bundle') {

            foreach (WC()->cart->cart_contents as $key => $values) {

                if (isset($values['bundled_by']) && $values['bundled_by'] == $cart_item_key) {
                    //$gpls_woo_rfq_cart[$cart_item_key] = WC()->cart->cart_contents[$cart_item_key];

                    if (isset($gpls_woo_rfq_cart[$key])) {
                        $old_bundled_qty = $gpls_woo_rfq_cart[$key]['quantity'];
                    } else {
                        $old_bundled_qty = 0;
                    }

                    $new_bundled_item_quantity = $old_bundled_qty + WC()->cart->cart_contents[$key]['quantity'];

                    $gpls_woo_rfq_cart[$key] = WC()->cart->cart_contents[$key];
                    $gpls_woo_rfq_cart[$key]['quantity'] = $new_bundled_item_quantity;

                }

            }
        }
    }


    if (!function_exists('gpls_woo_rfq_plus_override_woo_frontend_scripts')) {
        function gpls_woo_rfq_plus_override_woo_frontend_scripts()
        {
            //  wp_deregister_script('wc-checkout');

            //  $url_js = gpls_woo_rfq_plus_DIR . 'assets/js/checkout.js';
            //   $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/checkout.js';

            //    wp_enqueue_script('wc-checkout', $url_js, array('jquery', 'woocommerce', 'wc-country-select', 'wc-address-i18n'), filemtime($url_js_path), true);
        }
    }


    function gpls_woo_rfq_show_atts_in_admin_order($product, $item, $item_id)
    {
        //    function gpls_woo_rfq_show_atts_in_admin_order( $item_id, $item, $product ) {

        $show_weight = null;
        if (get_option('wcsa_weight_admin_order_details') == 'yes') {
            $show_weight = true;
        }
        $show_dimensions = null;
        if (get_option('wcsa_dimensions_admin_order_details') == 'yes') {
            $show_dimensions = true;
        }

        if (get_option('wcsa_admin_order_details') != 'no') {
            $skip_atts = null;
        } else {
            $skip_atts = true;
        }


        if (is_object($product)) {
            echo '<td><div class="view">' . wp_kses_post(gpls_woo_rfq_get_selected_attributes($product, 'span', $show_weight, $show_dimensions, $skip_atts)) . '</div></td>';
        }
    }


    function gpls_woo_rfq_admin_order_item_header()
    {
        if (get_option('wcsa_admin_order_details') != 'no') {
            echo '<th class="wsa-custom-attributes">' . __('Attributes', 'woocommerce-show-attributes') . '</th>';
        }
    }

    function gpls_woo_rfq_get_selected_attributes($product = null, $element, $show_weight = null, $show_dimensions = null, $skip_atts = null, $single_product = null)
    {

        $attribute_array = trim(get_option('settings_gpls_woo_rfq_product_attributes', ''));

        if (!isset($attribute_array)) return;

        $attribute_array = explode(',', $attribute_array);

        $out = '';
        $out_middle = '';

        if (isset($product)) {
            if (is_object($product)) {

                if ($show_weight) {
                    if ($product->has_weight()) {
                        $weight = $product->get_weight();
                        $unit = esc_attr(get_option('woocommerce_weight_unit'));
                    }
                }

                if ($show_dimensions) {
                    if ($product->has_dimensions()) {
                        $dimensions = wc_format_dimensions($product->get_dimensions(false));
                    }
                }

                $colon = get_option('wcsa_remove_semicolon') == 'yes' ? ' ' : ': ';
                $hide_labels = get_option('woocommerce_show_attributes_hide_labels');
                // check if they choose span element over li
                if (get_option('woocommerce_show_attributes_span') == 'yes') {
                    $element = 'span';
                }

                if (!$skip_atts) {

                    $attributes = $product->get_attributes();


                    if (!$attributes) {
                        return;
                    }

                    foreach ($attributes as $attribute) {
                        if (!is_a($attribute, 'WC_Product_Attribute')) {
                            continue;
                        }

                        if (!in_array(wc_attribute_label($attribute->get_name()), $attribute_array) && !in_array(($attribute->get_name()), $attribute_array)) continue;


                        // skip variations
                        if ($attribute->get_variation()) {
                            continue;
                        }

                        // honor the visibility setting
                        if (!$attribute->get_visible()) {
                            continue;
                        }

                        $name = $attribute->get_name();

                        if ($attribute->is_taxonomy()) {

                            $product_id = $product->get_id();
                            $terms = wp_get_post_terms($product_id, $name, 'all');

                            if (isset($terms)) {
                                if (!is_wp_error($terms)) {

                                    // get the taxonomy
                                    $tax = $terms[0]->taxonomy;
                                    // get the tax object
                                    $tax_object = get_taxonomy($tax);
                                    // get tax label
                                    if (isset ($tax_object->labels->singular_name)) {
                                        $tax_label = $tax_object->labels->singular_name;
                                    } elseif (isset($tax_object->label)) {
                                        $tax_label = $tax_object->label;
                                        // Trim label prefix
                                        $label_prefix = __('Product', 'woocommerce-show-attributes') . ' ';
                                        if (0 === strpos($tax_label, $label_prefix)) {
                                            $tax_label = substr($tax_label, strlen($label_prefix));
                                        }
                                    }
                                    $out_middle .= '<' . esc_attr($element) . ' class="' . esc_attr($name) . '">';
                                    // Hide labels if they want to
                                    if ($hide_labels != 'yes') {
                                        // PolyLang translation support
                                        if (function_exists('pll__')) {
                                            $translation = pll__($tax_label);
                                            $tax_label = (isset($translation)) ? $translation : $tax_label;
                                        }

                                        $out_middle .= '<span class="attribute-label"><span class="attribute-label-text">' . sprintf(__('%s', 'woocommerce-show-attributes'), esc_html($tax_label)) . '</span>' . $colon . ' </span> ';
                                    }
                                    $out_middle .= '<span class="attribute-value">';

                                    $tax_terms = array();
                                    foreach ($terms as $term) {

                                        $single_term = sprintf(__('%s', 'woocommerce-show-attributes'), esc_html($term->name));

                                        // Show terms as links?

                                        if ($single_product) {

                                            if (get_option('wcsa_terms_as_links') == 'yes') {
                                                $term_link = get_term_link($term);
                                                if (!is_wp_error($term_link)) {
                                                    $single_term = '<a href="' . esc_url($term_link) . '">' . sprintf(__('%s', 'woocommerce-show-attributes'), esc_html($term->name)) . '</a>';
                                                }
                                            }
                                        }
                                        array_push($tax_terms, $single_term);
                                    }
                                    $out_middle .= implode(', ', $tax_terms);
                                    $out_middle .= '</span></' . esc_attr($element) . '>';

                                    if ('span' == $element) {
                                        $out_middle .= '<br />';
                                    }
                                }
                            }

                        } else {
                            $value_string = implode(', ', $attribute->get_options());
                            $out_middle .= '<' . esc_attr($element) . ' class="' . sanitize_title($name) . ' ' . sprintf(__('%s', 'woocommerce-show-attributes'), sanitize_title($value_string)) . '">';

                            // Hide labels if they want to
                            if ($hide_labels != 'yes') {

                                // PolyLang translation support
                                if (function_exists('pll__')) {
                                    $translation = pll__($name);
                                    $name = (isset($translation)) ? $translation : $name;
                                }

                                $out_middle .= '<span class="attribute-label"><span class="attribute-label-text">' . sprintf(__('%s', 'woocommerce-show-attributes'), esc_html($name)) . '</span>' . $colon . ' </span> ';
                            }
                            $out_middle .= '<span class="attribute-value">' . sprintf(__('%s', 'woocommerce-show-attributes'), esc_html($value_string)) . '</span></' . esc_attr($element) . '>';
                            if ('span' == $element) {
                                $out_middle .= '<br />';
                            }

                        }

                    } // ends foreach attribute
                }

                // Add weight and dimensions if they opted in

                if (isset($weight)) {
                    $unit = !isset($unit) ? '' : $unit;
                    // weight
                    $out_middle .= '<' . esc_attr($element) . ' class="show-attributes-weight">';
                    // Hide labels if they want to
                    if ($hide_labels != 'yes') {
                        $out_middle .= '<span class="attribute-label">' . __('Weight', 'woocommerce-show-attributes') . $colon . ' </span> ';
                    }
                    $out_middle .= '<span class="attribute-value">' . esc_html($weight) . ' ' . esc_html($unit) . ' </span></' . esc_attr($element) . '>';
                    if ('span' == $element) {
                        $out_middle .= '<br />';
                    }
                }

                if (isset($dimensions)) {
                    // dimensions
                    $out_middle .= '<' . esc_attr($element) . ' class="show-attributes-dimensions">';
                    // Hide labels if they want to
                    if ($hide_labels != 'yes') {
                        $out_middle .= '<span class="attribute-label">' . __('Dimensions', 'woocommerce-show-attributes') . $colon . ' </span> ';
                    }
                    $out_middle .= '<span class="attribute-value">' . esc_html($dimensions) . '</span></' . esc_attr($element) . '>';
                    if ('span' == $element) {
                        $out_middle .= '<br />';
                    }
                }

                if ($out_middle) {
                    $out = ('li' == $element) ? '<ul ' : '<span ';
                    $out .= 'class="custom-attributes">' . $out_middle;
                    $out .= ('li' == $element) ? '</ul>' : '</span>';
                }

            }
        }

        $attribute_array = trim(get_option('settings_gpls_woo_rfq_product_custom_fields', ''));

        if (!isset($attribute_array)) return;

        $attribute_array = explode(',', $attribute_array);

        if (count($attribute_array) == 0 || !is_array($attribute_array)) return;

        $out .= '<ul>';

        foreach ($attribute_array as $attrib) {

            $tmp = get_post_meta($product->get_id(), $attrib, true);


            if ($tmp != '' && !is_array($tmp)) {
                $out .= '<li>' . $attrib . ': ' . $tmp . '</li>';
            }


        }
        $out .= '</ul>';
        return $out;
    }


    function gpls_woo_rfq_set_order_item_attributes($item_id, $item, $order_id)
    {

        $attribute_array = trim(get_option('settings_gpls_woo_rfq_product_attributes', ''));

        if (!isset($attribute_array)) return;

        $attribute_array = explode(',', $attribute_array);

        if (count($attribute_array) == 0 || !is_array($attribute_array)) return;

        $pf = new WC_Product_Factory();

        $of = new WC_Order_Factory();

        $order = $of::get_order($order_id);


        if (!is_callable(array($item, 'get_product'))) return;


        $_product = apply_filters('woocommerce_order_item_product', $item->get_product(), $item);

        if (!is_object($_product)) $_product = wc_get_product(get_the_ID());

        //if (!is_object($product)) $product = WC()->product_factory->get_product(get_the_ID());

        if (!isset($_product) || !is_object($_product)) {
            return;
        }


        $attributes = $_product->get_attributes();

        if (!isset($attributes)) return;

        // echo '<br /><br />';

        if (!$attributes) {
            return;
        }

        foreach ($attributes as $attribute) {
            if (!is_a($attribute, 'WC_Product_Attribute')) {
                continue;
            }

            //echo wc_attribute_label($attribute->get_name()).' '.$attribute->get_name().'<br />';
            if (!is_a($attribute, 'WC_Product_Attribute')) continue;
            if (!in_array(wc_attribute_label($attribute->get_name()), $attribute_array) && !in_array(($attribute->get_name()), $attribute_array)) continue;

            $values = array();

            if ($attribute->is_taxonomy()) {
                $attribute_taxonomy = $attribute->get_taxonomy_object();
                $attribute_values = wc_get_product_terms($_product->get_id(), $attribute->get_name(), array('fields' => 'all'));

                foreach ($attribute_values as $attribute_value) {
                    $value_name = esc_html($attribute_value->name);

                    if ($attribute_taxonomy->attribute_public) {
                        $values[] = '<a href="' . esc_url(get_term_link($attribute_value->term_id, $attribute->get_name())) . '" rel="tag">' . $value_name . '</a>';
                    } else {
                        $values[] = $value_name;
                    }
                }
            } else {
                $values = $attribute->get_options();

                foreach ($values as &$value) {
                    $value = esc_html($value);
                }
            }
            wc_add_order_item_meta($item_id, '_' . $attribute->get_name(), $values);

        }




    }


    if (!function_exists('add_gpls_rfq_toolkit_meta_boxes')) {
        function add_gpls_rfq_toolkit_meta_boxes()
        {

            add_meta_box('woocommerce-gpls_woo_rfq_plus_display_in_admin', __('RFQ-ToolKit'), 'gpls_woo_rfq_plus_display_in_admin', 'shop_order', 'normal', 'default');

        }
    }


    if (!function_exists('gpls_woo_rfq_plus_display_in_admin')) {
        function gpls_woo_rfq_plus_display_in_admin($object)
        {


            wp_nonce_field('meta-box-nonce', "meta-box-nonce");

            $post = $object;
            $order = wc_get_order($post->ID);

            echo '<div style="width:auto">';

            if (function_exists('rfqtk_display_proposal_in_admin')) {
                rfqtk_display_proposal_in_admin($order);
            }


            if (function_exists('rfqtk_display_offer_in_admin')) {
                rfqtk_display_offer_in_admin($order);
            }


            if (function_exists('rfqtk_display_ninja_in_admin')) {
                rfqtk_display_ninja_in_admin($order);
            }

            if (function_exists('rfqtk_display_files_in_admin')) {
                rfqtk_display_files_in_admin($order);
            }
            echo '</div>';

        }

    }


    function gpls_woo_rfq_add_custom_order_status_icon()
    {

        $url_quote_image = gpls_woo_rfq_plus_URL . 'assets/img/gplsquote_req.png';
        $url_sent_image = gpls_woo_rfq_plus_URL . 'assets/img/gplsquote_sent.png';
        $custom_css = <<<TAG
<style> 

 
.widefat .column-order_status mark.gplsquote-sent{
font-size: 1.1em !important;
background: 0 0;
}

.widefat .column-order_status mark.gplsquote-sent:after {
content: '\\e008';

color: #ffba00;
font-family: WooCommerce;
speak: none;
font-weight: 400;
font-size: 1.1em;
font-variant: normal;
text-transform: none;
line-height: 1;
-webkit-font-smoothing: antialiased;
margin: 0;
text-indent: 0;
position: absolute;
top: 0;
left: 0;
width: 100%;
height: 100%;
text-align: center;
font-size: 1.1em;
}

.widefat .column-order_status mark.gplsquote-req{
 
background: 0 0;
font-size: 1.1em !important;
}
.widefat .column-order_status mark.gplsquote-req:after {
 
 content: '\\e018';
   color: #1E7790;
   font-family: WooCommerce;
speak: none;
font-weight: 400;
font-variant: normal;
text-transform: none;
line-height: 1;
-webkit-font-smoothing: antialiased;
margin: 0;
text-indent: 0;
position: absolute;
top: 0;
left: 0;
width: 100%;
height: 100%;
text-align: center;
font-size: 1.1em !important;
}

</style>
TAG;


        echo $custom_css;
    }


    function gpls_woo_rfq_quote_button_shortcode($atts, $content = null)
    {


        if (count($_POST) != 0) {
            return;
        }

//'shop_thumbnail', 'shop_catalog', 'shop_single'
        // Attributes
        extract(shortcode_atts(array(
            'product_id' => '',
            'show_image' => 'no',
            'image_size' => 'thumbnail',
            'div_style' => '200px',
            'show_title' => 'yes',
            'button_style' => '',
            'button_class' => '',

        ), $atts));


        if ($product_id == null) return '';

        // Query
        //$the_query = new WP_Query( array ( 'posts_per_page' => $atts['posts'] ) );


        $pf = new WC_Product_Factory();

        $product = $pf->get_product($product_id);


        if (gpls_empty($product)) return;


        $form_label = gpls_woo_rfq_INQUIRE_TEXT;

        $rfq_product_script = "";

        $rfq_enable = get_post_meta($product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
        ?>
        <?php if ($rfq_enable == 'yes' && $GLOBALS["gpls_woo_rfq_checkout_option"] != "rfq") : ?>

        <?php

        $rfq_check = false;
        $normal_check = false;

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {
            if (get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'no') {
                $rfq_check = true;
                $normal_check = false;
            }
        }


        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "normal_checkout") {
            //  if (get_option('settings_gpls_woo_rfq_normal_checkout_show_prices','no') == 'no' )
            {
                $normal_check = true;
                $rfq_check = false;
            }
        }

        if (function_exists('wp_get_current_user')) {
            if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
                $rfq_check = true;
                $normal_check = false;
            }
        }

        if ($rfq_check) {
            $rfq_product_script = "";
        }


        $rfq_id = $product->get_id();

        global $rfq_cart;

        global $rfq_variations;

        $in_rfq = false;


        $gpls_woo_rfq_cart = gpls_woo_rfq_get_item(gpls_woo_rfq_cart_tran_key() . '_' . 'gpls_woo_rfq_cart');

        if (($gpls_woo_rfq_cart != false)) {

            foreach ($gpls_woo_rfq_cart as $cart_item_key => $values) {
                $product_id = $values['product_id'];


                if (get_the_ID() == $product_id && $values['rfq'] == "yes" && $values['restore'] == 'yes') {
                    $in_rfq = true;
                }
            }

        }

        if (($in_rfq == true && $product->get_type() != 'variable' && $product->get_type() != 'bundle')) {

            $request_quote = get_option('rfq_cart_wordings_in_rfq', __('In Quote List', 'rfqtk'));//"In RFQ"
            $request_quote = __($request_quote, 'rfqtk');

            $request_quote = apply_filters('gpls_woo_rfq_in_rfq_text', $request_quote);

        } else {
            $request_quote = get_option('rfq_cart_wordings_add_to_rfq', __('Add To Quote', 'rfqtk'));// "Request Quote"
            $request_quote = __($request_quote, 'rfqtk');

            $request_quote = apply_filters('gpls_woo_rfq_request_quote_text', $request_quote);

        }


        if ($normal_check) {

            $gpls_woo_rfq_file_add_to_quote_styles = array();

            $gpls_woo_rfq_file_add_to_quote_styles = apply_filters('gpls_woo_rfq_add_to_quote_styles', $gpls_woo_rfq_file_add_to_quote_styles);

        }


        $link_to_rfq_page = pls_woo_rfq_get_link_to_rfq();

        $view_your_cart_text = get_option('rfq_cart_wordings_view_rfq_cart', __('VIEW LIST', 'rfqtk'));
        $view_your_cart_text = __($view_your_cart_text, 'rfqtk');
        $proceed = apply_filters('gpls_woo_rfq_after_after_shop_loop_item_proceed', true);

        if ($proceed == false) return;
        ?>


        <?php
        ob_start();

        $thumbnail = "";
        $product_permalink = false;
        $prod_title = "";

        If ($show_title == 'yes') {
            $prod_title = $product->get_title();
        }

        If ($show_image == 'yes') {

            //  $thumbnail = $product->get_image();
            $thumbnail = $product->get_image($image_size);

            $product_permalink = $product->is_visible() ? $product->get_permalink() : '';
        }

        $data_var = "no";
        if ($product->get_type() == 'variable') {
            $data_var = "yes";
        }
        ?>

        <div class="add_to_quote_sc" style="width:<?php echo $div_style ?> !important">
            <?php
            $image = $thumbnail;
            if (!$product_permalink) {
                echo $image;
            } else {
                printf('<a class="woocommerce-LoopProduct-link woocommerce-loop-product__link" href="%s">%s</a>', esc_url($product_permalink), $image);
            }
            echo '<h2 class="woocommerce-loop-product__title">' . $product->get_title() . '</h2>'
            ?>
            <?php
            $gpls_woo_rfq_file_add_to_quote_styles = array();
            $gpls_woo_rfq_file_add_to_quote_styles['gpls_woo_rfq_page_button_styles'] = '';
            $gpls_woo_rfq_file_add_to_quote_styles['gpls_woo_rfq_page_button_onmouseover'] = '';
            $gpls_woo_rfq_file_add_to_quote_styles['gpls_woo_rfq_page_button_background_onmouseover'] = '';
            $gpls_woo_rfq_file_add_to_quote_styles['gpls_woo_rfq_page_button_onmouseout'] = '';
            $gpls_woo_rfq_file_add_to_quote_styles['gpls_woo_rfq_page_button_background_onmouseout'] = '';

            $gpls_woo_rfq_file_add_to_quote_styles = apply_filters('gpls_woo_rfq_add_to_quote_styles', $gpls_woo_rfq_file_add_to_quote_styles);

            wc_get_template('woo-rfq/add-to-quote-short.php',
                array('rfq_id' => $rfq_id,
                    'product' => $product,
                    'rfq_check' => $rfq_check,
                    'data_var' => $data_var,
                    'request_quote' => $request_quote,
                    'button_style' => $button_style,
                    'button_class' => $button_class,
                    'gpls_woo_rfq_file_add_to_quote_styles' => $gpls_woo_rfq_file_add_to_quote_styles,
                ))
            ?>


        </div>

        <?php

        $single_add_to_cart_after_shop_loop_button = ob_get_clean();

        $single_add_to_cart_after_shop_loop_button = apply_filters('gpls_woo_rfq_after_shop_loop_button', $single_add_to_cart_after_shop_loop_button, $in_rfq, $rfq_check, $normal_check, $rfq_enable, $product);
        return $single_add_to_cart_after_shop_loop_button;

        ?>


    <?php endif; ?>


        <?php
        // Return code


    }


    function gpls_woo_rfq_plus_capture_order_id($order_id)
    {
        global $wp_session;
        $wp_session['cart_items'] = $order_id;

    }


    function rfqtk_display_proposal_in_admin($order)
    {

        $content = get_post_meta($order->get_id(), '_quote_sent_note', true);

        $setting = array('textarea_rows' => 10, 'textarea_name' => 'quote_sent_note_editor');

        echo '<div  style="clear: both; margin-top:5px; display:block;;font-weight: bold"><h1>Proposal To Customer</h1></div>';

        wp_editor($content, 'quote_sent_note_editor', $setting);

        echo '<div style="clear: both"></div>';

        $include_pay_link = get_post_meta($order->get_id(), '_include_proposal_pay_link', true);
        $include_pay_link_checked = "";
        if ($include_pay_link == 'yes') {
            $include_pay_link_checked = "checked";
        }
        echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">Insert a "Pay" link in the proposal email <input type="checkbox" name="include_proposal_pay_link" id="include_proposal_pay_link" ' . $include_pay_link_checked . '></h2></span>';

        $include_respond_link = get_post_meta($order->get_id(), '_include_respond_link', true);
        $include_respond_link_checked = "";
        if ($include_respond_link == 'yes') {
            $include_respond_link_checked = "checked";
        }
        echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">Insert a "Respond to Offer" link in the proposal email <input type="checkbox" name="include_respond_link" id="include_respond_link" ' . $include_respond_link_checked . '></h2></span>';


        $include_accept_link = get_post_meta($order->get_id(), '_include_accept_link', true);
        $include_accept_link_checked = "";
        if ($include_accept_link == 'yes') {
            $include_accept_link_checked = "checked";
        }
        echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">Insert an "Accept" link in the proposal email <input type="checkbox" name="include_accept_link" id="include_respond_link" ' . $include_accept_link_checked . '></h2></span>';


        $gpls_woo_rfq_no_expire = get_post_meta($order->get_id(), '_gpls_woo_rfq_no_expire', true);
        $gpls_woo_rfq_no_expire_checked = "";
        if ($gpls_woo_rfq_no_expire == 'yes') {
            $gpls_woo_rfq_no_expire_checked = "checked";
        }
        echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">Don\'t expire this quote <input type="checkbox" name="gpls_woo_rfq_no_expire" id="gpls_woo_rfq_no_expire" ' . $gpls_woo_rfq_no_expire_checked . '></h2></span>';


        $gpls_woo_rfq_email_sender = get_post_meta($order->get_id(), '_gpls_woo_rfq_email_sender', true);

        echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">Change "From" in the email <input style="width:300px" name="gpls_woo_rfq_email_sender" id="gpls_woo_rfq_email_sender" value="' . $gpls_woo_rfq_email_sender . '"></h2></span>';


        $gpls_woo_rfq_email_reply = get_post_meta($order->get_id(), '_gpls_woo_rfq_email_reply', true);

        echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">Change "Reply To" in the email <input style="width:300px" name="gpls_woo_rfq_email_reply" id="gpls_woo_rfq_email_sender" value="' . $gpls_woo_rfq_email_reply . '"></h2></span>';


        $gpls_woo_rfq_email_cc = get_post_meta($order->get_id(), '_gpls_woo_rfq_email_cc', true);

        echo '<span  ><h2 style="clear: both; margin-top:5px; display:block;;font-weight: bold">CC this email to <input style="width:600px" name="gpls_woo_rfq_email_cc" id="gpls_woo_rfq_email_cc" value="' . $gpls_woo_rfq_email_cc . '"></h2>You can put multiple emails speperated by commas</span>';


    }


    if (!function_exists('gpls_woo_rfq_plus_startsWith')) {
        function gpls_woo_rfq_plus_startsWith($haystack, $needle)
        {
            $length = strlen($needle);
            return (substr($haystack, 0, $length) === $needle);
        }
    }

    if (!function_exists('gpls_woo_rfq_plus_endsWith')) {
        function gpls_woo_rfq_plus_endsWith($haystack, $needle)
        {
            $length = strlen($needle);
            if ($length == 0) {
                return true;
            }

            return (substr($haystack, -$length) === $needle);
        }
    }


    function gpls_woo_rfq_request_page_output_top_html()
    {

        $settings_gpls_woo_rfq_page_desc_top = get_option('settings_gpls_woo_rfq_page_desc_top', '');
        $settings_gpls_woo_rfq_page_desc_top = __($settings_gpls_woo_rfq_page_desc_top, 'rfqtk');


        echo '<div style="padding:10px; margin-top:25px;margin-bottom:25px;">' . $settings_gpls_woo_rfq_page_desc_top . '</div>';
    }


    function gpls_woo_rfq_request_page_output_bottom_html()
    {

        $settings_gpls_woo_rfq_page_desc_bottom = get_option('settings_gpls_woo_rfq_page_desc_bottom', '');
        $settings_gpls_woo_rfq_page_desc_bottom = __($settings_gpls_woo_rfq_page_desc_bottom, 'rfqtk');

        echo '<div style="padding:10px; margin-top:25px;margin-bottom:25px;">' . $settings_gpls_woo_rfq_page_desc_bottom . '</div>';
    }


    function gpls_woo_add_rfq_custom_rfq_page_css_js()
    {

        if (!is_admin()) {

            $enable = get_option('rfq_cart_sc_section_rfq_page_apply_style', 'no');

            if ($enable != 'yes') {
                // return;
            }

            $url_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk.js';
            $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk.js';
            wp_enqueue_script('gpls_woo_rfq_plus_js', $url_js, array(), filemtime($url_js_path), true);


            $gpls_woo_rfq_page_add_js = '';

            $gpls_woo_rfq_page_add_js .= 'jQuery(".gpls_woo_rfq_request_page td.actions").css({"border-top-width": "1px"});';
            $value0 = get_option('gpls_woo_rfq_request_page_background', '');

            if ($value0 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".gpls_woo_rfq_request_page").css({"background-color": "' . $value0 . '"});';
                $gpls_woo_rfq_page_add_js .= 'jQuery(".gpls_woo_rfq_request_page td.actions").css({"border-top-color": "' . $value0 . '"});';
            }


            $value1 = get_option('rfq_cart_sc_section_rfq_page_cart_header_background', '');

            if ($value1 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".cart_th").css({"background-color": "' . $value1 . '"});';
            }


            $value2 = get_option('rfq_cart_sc_section_rfq_page_cart_header_color', '');

            if ($value2 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".cart_th").css({"color": "' . $value2 . '"});';
            }

            $value3 = get_option('rfq_cart_sc_section_rfq_page_cart_row_background', '');


            if ($value3 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".cart_td,.cart_tr").css({"background-color": "' . $value3 . '"});';

            }

            $value4 = get_option('rfq_cart_sc_section_rfq_page_cart_font_color', '');

            if ($value4 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".cart_td").css({"color": "' . $value4 . '"});';
            }

            $value5 = get_option('rfq_cart_sc_section_rfq_page_cart_link_color', '');

            if ($value5 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".cart_td a").css({"color": "' . $value5 . '"});';

            }


            $value6 = get_option('rfq_cart_sc_section_rfq_page_cart_background', '');

            if ($value6 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".cart_th,.cart_td,.cart_tr").css({"color": "' . $value6 . '"});';

            }

            $value7 = get_option('rfq_cart_sc_section_rfq_page_cart_image_size', '');

            if ($value7 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".cart_td img").css({"max-width": "' . $value7 . '"});';
            }


            $value8 = get_option('rfq_cart_sc_section_rfq_cust_info_header_background', '');

            if ($value8 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".info_th").css({"background": "' . $value8 . '"});';
            }


            $value9 = get_option('rfq_cart_sc_section_rfq_cust_info_header_color', '');

            if ($value9 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".info_th").css({"color": "' . $value9 . '"});';

            }

            $value10 = get_option('rfq_cart_sc_section_rfq_cust_info_row_background', '');

            if ($value10 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".info_td,.info_tr").css({"background-color": "' . $value10 . '"});';

            }


            $value11 = get_option('rfq_cart_sc_section_rfq_cust_info_font_color', '');

            if ($value11 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".info_td").css({"color": "' . $value11 . '"});';
            }


            $value12 = get_option('rfq_cart_sc_section_rfq_woo_rfq_customer_info_header_color', '');

            if ($value12 != '') {


                $gpls_woo_rfq_page_add_js .= 'jQuery(".woo-rfq-customer-info-header").css({"color": "' . $value12 . '"});';

            }

            $value13 = get_option('rfq_cart_sc_section_rfq_woo_rfq_customer_info_header_color', '');

            if ($value13 != '') {


                $gpls_woo_rfq_page_add_js .= 'jQuery(".woo-rfq-customer-info-header").css({"color": "' . $value13 . '"});';
            }


            $value14 = get_option('rfq_cart_sc_section_rfq_cust_info_background', '');

            if ($value14 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".info_th,.info_td,.info_tr").css({"color": "' . $value14 . '"});';
            }


            $value15 = get_option('rfq_cart_sc_section_rfq_woo_rfq_customer_info_input_background', '');

            if ($value15 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".info_td .input-text, input[type=text], input[type=email], input[type=url], input[type=password], input[type=search], textarea").css({"background": "' . $value15 . '"});';
            }


            $value16 = get_option('rfq_cart_sc_section_rfq_woo_rfq_customer_info_border_color', '');

            if ($value16 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".rfq-shop-table_customer_info td").css({"border-color": "' . $value16 . '"});';
            }


            $value17 = get_option('rfq_cart_sc_section_rfq_page_cart_border_size', '');

            if ($value17 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".rfq-shop-table_customer_info td").css({"border-width": "' . $value17 . '"});';

            }


            $value18 = get_option('rfq_cart_sc_section_rfq_page_cart_border_style', '');

            if ($value18 != '') {

                $gpls_woo_rfq_page_add_js .= 'jQuery(".rfq-shop-table_customer_info td").css({"border-style": "' . $value18 . '"});';
            }


            if ($gpls_woo_rfq_page_add_js != '') {


                wp_add_inline_script('gpls_woo_rfq_plus_js', $gpls_woo_rfq_page_add_js);

            }

//required
            $custom_js_load = gpls_woo_on_load_custom_js();
            $custom_js_click = gpls_woo_on_click_custom_js();

            wp_add_inline_script('gpls_woo_rfq_plus_js', $custom_js_load . ' ' . $custom_js_click);
        }

    }

    /**
     * @return string
     */


    function gpls_woo_add_rfq_custom_rfq_page_css()
    {


        if (!is_admin()) {


            $gpls_woo_rfq_page_custom_css = get_option('rfq_cart_sc_section_rfq_page_custom_css');

            if ($gpls_woo_rfq_page_custom_css != '') {
                $gpls_woo_rfq_page_custom_css = '<style>' . $gpls_woo_rfq_page_custom_css . '</style>';

                echo $gpls_woo_rfq_page_custom_css;

            }


        }

    }


    function gpls_woo_on_click_custom_js()
    {
        $custom_js = "jQuery('.gpls-woo-rfq_checkout_button').on('click', function(){";

        $phone_required = get_option('rfq_cart_sc_section_rfq_page_phone_required');

        if ($phone_required == 'yes') {
//jQuery('#rfq_phone').attr("required",false);
            $custom_js .=
                "if ( jQuery( '#rfq_phone' ).length && jQuery( '#rfq_phone' ).is(':visible')) {jQuery('#rfq_phone').attr('required',true);}";

        }

        $rfq_cart_sc_section_rfq_page_company_required = get_option('rfq_cart_sc_section_rfq_page_company_required');

        if ($rfq_cart_sc_section_rfq_page_company_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_company' ).length && jQuery( '#rfq_company' ).is(':visible')) {jQuery('#rfq_company').attr('required',true);}";

        }

        $rfq_cart_sc_section_rfq_page_country_required = get_option('rfq_cart_sc_section_rfq_page_country_required');

        if ($rfq_cart_sc_section_rfq_page_country_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_billing_country' ).length && jQuery( '#rfq_billing_country' ).is(':visible')) {jQuery('#rfq_billing_country').attr('required',true);}";


        }


        $rfq_cart_sc_section_rfq_page_state_required = get_option('rfq_cart_sc_section_rfq_page_state_required');

        if ($rfq_cart_sc_section_rfq_page_state_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_state_select' ).length && jQuery( '#rfq_state_select' ).is(':visible')) {jQuery('#rfq_state_select').attr('required',true);}";


        }

        $rfq_cart_sc_section_rfq_page_address_required = get_option('rfq_cart_sc_section_rfq_page_address_required');

        if ($rfq_cart_sc_section_rfq_page_address_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_address' ).length && jQuery( '#rfq_address' ).is(':visible')) {jQuery('#rfq_address').attr('required',true);}";

        }

        $rfq_cart_sc_section_rfq_page_city_required = get_option('rfq_cart_sc_section_rfq_page_city_required');

        if ($rfq_cart_sc_section_rfq_page_city_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_city' ).length && jQuery( '#rfq_city' ).is(':visible')) {jQuery('#rfq_city').attr('required',true);}";

        }


        $rfq_cart_sc_section_rfq_page_zip_required = get_option('rfq_cart_sc_section_rfq_page_zip_required');

        if ($rfq_cart_sc_section_rfq_page_zip_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_zip' ).length && jQuery( '#rfq_zip' ).is(':visible')) {jQuery('#rfq_zip').attr('required',true);}";

        }

        $rfq_cart_sc_section_rfq_page_comment_required = get_option('rfq_cart_sc_section_rfq_page_comment_required');

        if ($rfq_cart_sc_section_rfq_page_comment_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_message' ).length && jQuery( '#rfq_message' ).is(':visible')) {jQuery('#rfq_message').attr('required',true);}";

        }

        $custom_js .= " });";
        return $custom_js;
    }

    function gpls_woo_on_load_custom_js()
    {
        $custom_js = "jQuery( document ).ready( function() {";

        $phone_required = get_option('rfq_cart_sc_section_rfq_page_phone_required');

        if ($phone_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_phone_label' ).length && jQuery( '#rfq_phone_label' ).is(':visible')) {jQuery('#rfq_phone_label').addClass('required');}";

        }

        $rfq_cart_sc_section_rfq_page_company_required = get_option('rfq_cart_sc_section_rfq_page_company_required');

        if ($rfq_cart_sc_section_rfq_page_company_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_company_label' ).length && jQuery( '#rfq_company_label' ).is(':visible')) {jQuery('#rfq_company_label').addClass('required');}";

        }

        $rfq_cart_sc_section_rfq_page_country_required = get_option('rfq_cart_sc_section_rfq_page_country_required');

        if ($rfq_cart_sc_section_rfq_page_country_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_billing_country_label' ).length && jQuery( '#rfq_billing_country_label' ).is(':visible')) {jQuery('#rfq_billing_country_label').addClass('required');}";


        }


        $rfq_cart_sc_section_rfq_page_country_required = get_option('rfq_cart_sc_section_rfq_page_country_required');

        if ($rfq_cart_sc_section_rfq_page_country_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_billing_country_label' ).length && jQuery( '#rfq_billing_country_label' ).is(':visible')) {jQuery('#rfq_billing_country_label').addClass('required');}";


        }

        $rfq_cart_sc_section_rfq_page_state_required = get_option('rfq_cart_sc_section_rfq_page_state_required');

        if ($rfq_cart_sc_section_rfq_page_state_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_state_select_label' ).length && jQuery( '#rfq_state_select_label' ).is(':visible')) {jQuery('#rfq_state_select_label').addClass('required');}";


        }

        $rfq_cart_sc_section_rfq_page_address_required = get_option('rfq_cart_sc_section_rfq_page_address_required');

        if ($rfq_cart_sc_section_rfq_page_address_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_address_label' ).length && jQuery( '#rfq_address_label' ).is(':visible')) {jQuery('#rfq_address_label').addClass('required');}";

        }

        $rfq_cart_sc_section_rfq_page_city_required = get_option('rfq_cart_sc_section_rfq_page_city_required');

        if ($rfq_cart_sc_section_rfq_page_city_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_city_label' ).length && jQuery( '#rfq_city_label' ).is(':visible')) {jQuery('#rfq_city_label').addClass('required');}";

        }


        $rfq_cart_sc_section_rfq_page_zip_required = get_option('rfq_cart_sc_section_rfq_page_zip_required');

        if ($rfq_cart_sc_section_rfq_page_zip_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_zip_label' ).length && jQuery( '#rfq_zip_label' ).is(':visible')) {jQuery('#rfq_zip_label').addClass('required');}";

        }

        $rfq_cart_sc_section_rfq_page_comment_required = get_option('rfq_cart_sc_section_rfq_page_comment_required');

        if ($rfq_cart_sc_section_rfq_page_comment_required == 'yes') {

            $custom_js .=
                "if ( jQuery( '#rfq_message_label' ).length && jQuery( '#rfq_message_label' ).is(':visible')) {jQuery('#rfq_message_label').addClass('required');}";
        }

        $custom_js .= "} );";
        return $custom_js;
    }


    function gpls_woo_add_rfq_custom_rfq_page_js()
    {

        if (!is_admin()) {

            $gpls_woo_rfq_page_custom_js = get_option('rfq_cart_sc_section_rfq_page_custom_js');

            if ($gpls_woo_rfq_page_custom_js != '') {

                echo '<script type="application/javascript">' . $gpls_woo_rfq_page_custom_js . '</script>';

            }
        }

    }


    function gpls_woo_rfq_my_account_my_orders_actions($actions, $order)
    {


        return $actions;
    }


    function gpls_woo_rfq_valid_order_statuses_for_payment($array, $order)
    {

        array_push($array, 'gplsquote-sent');

        return $array;
    }


    function gpls_woo_rfq_before_cart_gpls_woo_rfq_create_styles($gpls_woo_rfq_styles)
    {
        $enable = get_option('rfq_cart_sc_section_rfq_page_apply_style', 'no');

        if ($enable != 'yes') {
            return;
        }

        $gpls_woo_rfq_page_update_button_styles = '';

        $gpls_woo_rfq_page_update_button_onmouseover_color = '';
        $gpls_woo_rfq_page_update_button_background_onmouseover = '';
        $gpls_woo_rfq_page_update_button_onmouseover = '';

        $gpls_woo_rfq_page_update_button_onmouseout_color = '';
        $gpls_woo_rfq_page_update_button_background_onmouseout = '';


        $gpls_woo_rfq_page_submit_button_styles = '';

        $gpls_woo_rfq_page_submit_button_onmouseover = '';
        $gpls_woo_rfq_page_submit_button_background_onmouseover = '';

        $gpls_woo_rfq_page_submit_button_onmouseout = '';
        $gpls_woo_rfq_page_submit_button_background_onmouseout = '';

        $gpls_woo_rfq_page_update_button_onmouseout = '';


        $rfq_cart_sc_section_rfq_page_update_cart_button_background = get_option('rfq_cart_sc_section_rfq_page_update_cart_button_background', '');

        if (($rfq_cart_sc_section_rfq_page_update_cart_button_background) != '') {

            $gpls_woo_rfq_page_update_button_styles .= "background-color:" . $rfq_cart_sc_section_rfq_page_update_cart_button_background . " !important;";

        }


        $rfq_cart_sc_section_rfq_page_update_cart_button_color = get_option('rfq_cart_sc_section_rfq_page_update_cart_button_color', '');

        if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_color) != '') {

            $gpls_woo_rfq_page_update_button_styles .= "color:" . $rfq_cart_sc_section_rfq_page_update_cart_button_color . " !important;";

        }

        $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background = get_option('rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background', '');
        // echo $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background;

        if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background) != '') {

            $gpls_woo_rfq_page_update_button_background_onmouseover .= "this.style.background='" . $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background . "';";
            $gpls_woo_rfq_page_update_button_background_onmouseout .= "this.style.background='" . $rfq_cart_sc_section_rfq_page_update_cart_button_background . "';";

        }

        $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color = get_option('rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color', '');

        if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color) != '') {

            $gpls_woo_rfq_page_update_button_onmouseover .= "this.style.color='" . $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color . "';";
            $gpls_woo_rfq_page_update_button_onmouseout .= "this.style.color='" . $rfq_cart_sc_section_rfq_page_update_cart_button_color . "';";

        }

        $rfq_cart_sc_section_rfq_page_submit_cart_button_background = get_option('rfq_cart_sc_section_rfq_page_submit_quote_button_background', '');


        if (trim($rfq_cart_sc_section_rfq_page_submit_cart_button_background) != '') {

            $gpls_woo_rfq_page_submit_button_styles .= "background-color:" . $rfq_cart_sc_section_rfq_page_submit_cart_button_background . " !important;";

        }

        $rfq_cart_sc_section_rfq_page_submit_cart_button_color = get_option('rfq_cart_sc_section_rfq_page_submit_quote_button_color', '');

        if (trim($rfq_cart_sc_section_rfq_page_submit_cart_button_color) != '') {

            $gpls_woo_rfq_page_submit_button_styles .= "color:" . $rfq_cart_sc_section_rfq_page_submit_cart_button_color . " !important;";

        }


        $rfq_cart_sc_section_rfq_page_submit_cart_button_mouse_over_background = get_option('rfq_cart_sc_section_rfq_page_submit_quote_button_mouse_over_background', '');

        if (trim($rfq_cart_sc_section_rfq_page_submit_cart_button_mouse_over_background) != '') {


            $gpls_woo_rfq_page_submit_button_background_onmouseover .= "this.style.background='" . $rfq_cart_sc_section_rfq_page_submit_cart_button_mouse_over_background . "';";
            $gpls_woo_rfq_page_submit_button_background_onmouseout .= "this.style.background='" . $rfq_cart_sc_section_rfq_page_submit_cart_button_background . "';";

        }

        $rfq_cart_sc_section_rfq_page_submit_cart_button_mouse_over_color = get_option('rfq_cart_sc_section_rfq_page_submit_quote_button_mouse_over_color', '');

        if (trim($rfq_cart_sc_section_rfq_page_submit_cart_button_mouse_over_color) != '') {

            $gpls_woo_rfq_page_submit_button_onmouseover .= "this.style.color='" . $rfq_cart_sc_section_rfq_page_submit_cart_button_mouse_over_color . "';";
            $gpls_woo_rfq_page_submit_button_onmouseout .= "this.style.color='" . $rfq_cart_sc_section_rfq_page_submit_cart_button_color . "';";

        }


        $gpls_woo_rfq_styles = array(

            'gpls_woo_rfq_page_update_button_styles' => $gpls_woo_rfq_page_update_button_styles,

            'gpls_woo_rfq_page_update_button_onmouseover_color' => $gpls_woo_rfq_page_update_button_onmouseover_color,
            'gpls_woo_rfq_page_update_button_onmouseout_color' => $gpls_woo_rfq_page_update_button_onmouseout_color,
            'gpls_woo_rfq_page_update_button_background_onmouseover' => $gpls_woo_rfq_page_update_button_background_onmouseover,
            'gpls_woo_rfq_page_update_button_background_onmouseout' => $gpls_woo_rfq_page_update_button_background_onmouseout,
            'gpls_woo_rfq_page_update_button_onmouseover' => $gpls_woo_rfq_page_update_button_onmouseover,
            'gpls_woo_rfq_page_update_button_onmouseout' => $gpls_woo_rfq_page_update_button_onmouseout,

            'gpls_woo_rfq_page_submit_button_styles' => $gpls_woo_rfq_page_submit_button_styles,

            'gpls_woo_rfq_page_submit_button_onmouseover' => $gpls_woo_rfq_page_submit_button_onmouseover,
            'gpls_woo_rfq_page_submit_button_onmouseout' => $gpls_woo_rfq_page_submit_button_onmouseout,


            'gpls_woo_rfq_page_submit_button_background_onmouseover' => $gpls_woo_rfq_page_submit_button_background_onmouseover,
            'gpls_woo_rfq_page_submit_button_background_onmouseout' => $gpls_woo_rfq_page_submit_button_background_onmouseout,


        );

        return $gpls_woo_rfq_styles;

    }


    function gpls_woo_rfq_add_to_quote_create_styles($gpls_woo_rfq_upload_styles)
    {


        $gpls_woo_rfq_page_update_button_styles = '';

        $gpls_woo_rfq_page_update_button_onmouseover_color = '';
        $gpls_woo_rfq_page_update_button_background_onmouseover = '';
        $gpls_woo_rfq_page_update_button_onmouseover = '';

        $gpls_woo_rfq_page_update_button_onmouseout_color = '';
        $gpls_woo_rfq_page_update_button_background_onmouseout = '';


        $gpls_woo_rfq_page_submit_button_styles = '';

        $gpls_woo_rfq_page_submit_button_onmouseover = '';
        $gpls_woo_rfq_page_submit_button_background_onmouseover = '';

        $gpls_woo_rfq_page_submit_button_onmouseout = '';
        $gpls_woo_rfq_page_submit_button_background_onmouseout = '';

        $gpls_woo_rfq_page_update_button_onmouseout = '';


        $rfq_cart_sc_section_rfq_page_update_cart_button_background = get_option('rfq_cart_sc_section_rfq_page_add_to_quote_button_background', '');

        if (($rfq_cart_sc_section_rfq_page_update_cart_button_background) != '') {

            $gpls_woo_rfq_page_update_button_styles .= "background-color:" . $rfq_cart_sc_section_rfq_page_update_cart_button_background . " !important;";

        }


        $rfq_cart_sc_section_rfq_page_update_cart_button_color = get_option('rfq_cart_sc_section_rfq_page_add_to_quote_button_color', '');

        if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_color) != '') {

            $gpls_woo_rfq_page_update_button_styles .= "color:" . $rfq_cart_sc_section_rfq_page_update_cart_button_color . " !important;";

        }


        $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background = get_option('rfq_cart_sc_section_rfq_page_add_to_quote_button_mouse_over_background', '');
        // echo $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background;

        if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background) != '') {

            $gpls_woo_rfq_page_update_button_background_onmouseover .= "this.style.background='" . $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background . "';";
            $gpls_woo_rfq_page_update_button_background_onmouseout .= "this.style.background='" . $rfq_cart_sc_section_rfq_page_update_cart_button_background . "';";

        }


        $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color = get_option('rfq_cart_sc_section_rfq_page_add_to_quote_button_mouse_over_color', '');

        if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color) != '') {

            $gpls_woo_rfq_page_update_button_onmouseover .= "this.style.color='" . $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color . "';";
            $gpls_woo_rfq_page_update_button_onmouseout .= "this.style.color='" . $rfq_cart_sc_section_rfq_page_update_cart_button_color . "';";

        }


        $gpls_woo_rfq_upload_styles = array(

            'gpls_woo_rfq_page_button_styles' => $gpls_woo_rfq_page_update_button_styles,

            'gpls_woo_rfq_page_button_onmouseover_color' => $gpls_woo_rfq_page_update_button_onmouseover_color,
            'gpls_woo_rfq_page_button_background_onmouseover' => $gpls_woo_rfq_page_update_button_background_onmouseover,

            'gpls_woo_rfq_page_button_onmouseout_color' => $gpls_woo_rfq_page_update_button_onmouseout_color,
            'gpls_woo_rfq_page_button_background_onmouseout' => $gpls_woo_rfq_page_update_button_background_onmouseout,

            'gpls_woo_rfq_page_button_onmouseover' => $gpls_woo_rfq_page_update_button_onmouseover,
            'gpls_woo_rfq_page_button_onmouseout' => $gpls_woo_rfq_page_update_button_onmouseout,


        );

        return $gpls_woo_rfq_upload_styles;


    }


    function gpls_woo_rfqtk_recursive($array)
    {
        foreach ($array as $key => $value) {
            //If $value is an array.
            if (is_array($value)) {
                //We need to loop through it.
                gpls_woo_rfqtk_recursive($value);
            } else {
                //It is not an array, so print it out.
                echo $key . ": " . $value, '<br>';
            }
        }
    }


    /**
     */
    function rfqtk_quotes_rfqtk_quotes_cleanup()
    {
        if (defined('WP_SETUP_CONFIG')) {
            return;
        }

        if (!defined('WP_INSTALLING')) {
            /**
             * Determine the size of each batch for deletion.
             *
             * @param int
             */

            // Delete a batch of old sessions
            $expire_days = get_option('settings_gpls_woo_rfq_expire_days', 30);
            $option = get_option('settings_gpls_woo_rfq_expire_method', 'wc-cancelled');


            if ($expire_days == "" || strval($expire_days) < 1) {
                return;
            }

            if ($option == 'no') {
                return;
            }


            global $wpdb;


            $pageposts = $wpdb->get_results(" SELECT * FROM " . $wpdb->posts . "   
      WHERE post_type='shop_order' AND post_status IN('wc-gplsquote-req','wc-gplsquote-sent')       
       AND DATEDIFF(NOW(), post_date) > " . $expire_days);

            if ($pageposts == null) {

                return;
            }

            foreach ($pageposts as $post) {

                $postid = $post->ID;
                $order = WC_Order_Factory::get_order($postid);

                $no_expire = $order->get_meta('_gpls_woo_rfq_no_expire', true);



                if ($no_expire == 'yes') {
                    continue;
                }


                if ($option == "wc-cancelled") {
                    if ($order != false) {
                        $order->update_status($option, __('Order status changed by RFQ-ToolKit:', 'woocommerce'), true);
                        $order->save();
                    }
                }

                if ($option == "trash") {
                    $order->add_order_note(__("Order moved to trash by RFQ-ToolKit", "rftk"));
                    wp_trash_post($postid, true);
                }
            }
        }

        // Allow other plugins to hook in to the garbage collection process.
        do_action('rfqtk_quotes_cleanup');
    }


    add_action('rfqtk_quotes_garbage_collection', 'rfqtk_quotes_rfqtk_quotes_cleanup');


    function RFQTK_quotes_register_garbage_collection()
    {
        if (!wp_next_scheduled('rfqtk_quotes_garbage_collection')) {
            wp_schedule_event(current_time('timestamp'), 'daily', 'rfqtk_quotes_garbage_collection');
        }
    }

    add_action('wp', 'RFQTK_quotes_register_garbage_collection');


    function rftk_cat_has_meta($product_id, $meta_key, $single = true)
    {
        $meta_value = get_post_meta($product_id, $meta_key, true);
       // $product = wc_get_product($product_id);
      //  $meta_value = apply_filters('rftk_cat_has_meta_filter',$meta_value,$product, $meta_key);

        return $meta_value;
    }


    function rftk_cat_has_rfq_enabled_meta($rfq_enable, $product_id)
    {
        $rfq_enable = get_post_meta($product_id, '_gpls_woo_rfq_rfq_enable', true);

        if ($rfq_enable == "yes") {

            return "yes";

        } else {

            $product = wc_get_product($product_id);

            $category_ids = $product->get_category_ids('');

            $last_valid_cat = false;

            foreach ($category_ids as $category_id) {

                $meta_val = get_term_meta($category_id, '_gpls_woo_rfq_rfq_enable', true);

                if ($meta_val != false) {

                    $last_valid_cat = $meta_val;
                }


            }

            if ($last_valid_cat != false) {

                return "yes";
            }
        }

        return $rfq_enable;
    }


}



