<?php
/*
Plugin Name: NP Quote Request WooCommerce Plus
Description: NP Quote Request WooCommerce Plus adds many features and functionalities to the free version of NP WooCommerce Quote Request.
Version: 1.3.172
Contributors: Neah Plugins
Author: Neah Plugins
Author URI: http://www.neahplugins.com/
Donate link: http://www.neahplugins.com/
Requires at least: 4.1
Tested up to: 5.0.3
WC tested up to: 3.5
Text Domain: rfqtk
Copyright: � 2017-2019 Neah Plugins.
License: GNU General Public License v2.0
License URI: http://www.gnu.org/licenses/gpl-2.0.html
*/

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;


/**
 * Required functions
 */
//set_site_transient('update_plugins', null);

function gpls_woo_rfq_plus_admin_notice_nobasic()
{
    ?>
    <div id="message" class="error">
        <h3 class="error"><?php _e('NP Quote Request WooCommerce Plus requires <a href="http://downloads.wordpress.org/plugin/woo-rfq-for-woocommerce.latest-stable.zip?utm_source=home&utm_medium=button_2&utm_campaign=Download+Button" >NP Quote Request WooCommerce Free Version.</a>', 'rfqtk'); ?></h3>
    </div>
    <?php
}


if (!defined('gpls_woo_rfq_plus_DIR')) {
    DEFINE('gpls_woo_rfq_plus_DIR', plugin_dir_path(__FILE__));
    DEFINE('gpls_woo_rfq_plus_URL', plugin_dir_url(__FILE__));
    DEFINE('gpls_woo_rfq_plus_FILE_NAME', (__FILE__));
    DEFINE('gpls_woo_rfq_plus_PLUGIN_PATH', untrailingslashit(plugin_basename(__FILE__)));
    DEFINE('gpls_woo_rfq_plus_TEMPLATE_PATH', untrailingslashit(plugin_dir_path(__FILE__)) . '/templates/');
    DEFINE('gpls_woo_rfq_plus_WOO_PATH', untrailingslashit(plugin_dir_path(__FILE__)) . '/woocommerce/');
    DEFINE('gpls_woo_rfq_plus_AME_DATA_KEY', 'RFQ_ToolKit_Plus');
}
if (!function_exists('gpls_woo_rfq_get_item')) {
   // require_once(gpls_woo_rfq_plus_DIR . 'wp-session-manager/wp-session-manager.php');
   // require_once(ABSPATH . 'wp-includes/class-phpass.php');
}
require_once(plugin_dir_path(__FILE__) . '/woo-rfq-includes/woo-rfq-functions.php');


if (!is_admin()) {

    if (rfqtk_first()) {

        do_action('woocommerce_loaded', 'rfqtk_first_scripts', 1000);

        return;
    }
}


function rfqtk_first_scripts()
{
    $url_css = gpls_woo_rfq_plus_URL . 'assets/css/rfqtk.css';
    $url_css_path = gpls_woo_rfq_plus_DIR . 'assets/css/rfqtk.css';
    wp_enqueue_style('gpls_woo_rfq_plus_css', $url_css, array(), filemtime($url_css_path));

    $url_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk.js';
    $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk.js';
    wp_enqueue_script('gpls_woo_rfq_plus_js', $url_js, array(), filemtime($url_js_path), true);

}

/**
 * Required functions
 */


//add_action('plugins_loaded','gpls_woo_rfq_plus_activate',1000);
DEFINE('gpls_woo_rfq_plus_License_URL', plugins_url('/', __FILE__));


if (!function_exists('gpls_woo_rfq_plus_admin_notice_nolicense')) {

    function gpls_woo_rfq_plus_admin_notice_nolicense()
    {
        ?>

        <?php if (isset($_GET['page']) && 'wc_api_manager_rfqtk_plus_dashboard' == $_GET['page']) return; ?>
        <div id="message" class="error">
            <p><?php printf(__('NP Quote Request WooCommerce Plus License Key has not been activated. %sClick here%s to activate the license key for automatic updates and full functionality.', 'rfqtk'), '<a href="' . esc_url(admin_url('options-general.php?page=wc_api_manager_rfqtk_plus_dashboard')) . '">', '</a>'); ?></p>
        </div>
        <?php
    }
}



add_action('plugins_loaded', 'GPLS_WOO_RFQ_PLUS', 1000);

//set_site_transient('update_plugins', null);

//GPLS_WOO_RFQ_PLUS();

function GPLS_WOO_RFQ_PLUS()
{
    return GPLS_WOO_RFQ_PLUS::instance();

}

// Initialize the class instance only once


class GPLS_WOO_RFQ_PLUS
{


    public $upgrade_url = 'https://www.neahplugins.com/'; // URL to access the Update API Manager.

    /**
     * @var string
     */
    public $version = '1.3.172';

    /**
     * @var string
     * This version is saved after an upgrade to compare this db version to $version
     */
    public $api_manager_version_name = 'RFQ_ToolKit_Plus_Version';

    /**
     * @var string
     */
    public $plugin_url = gpls_woo_rfq_plus_License_URL;


    public $text_domain = 'rfqtk';

    /**
     * Data defaults
     * @var mixed
     */
    public $ame_software_product_id;

    public $ame_data_key = 'RFQ_ToolKit_Plus';
    public $ame_api_key = 'api_key';
    public $ame_activation_email = 'activation_email';
    public $ame_product_id_key;
    public $ame_instance_key;
    public $ame_deactivate_checkbox_key;
    public $ame_activated_key = 'api_manager_rfqtk_plus_activated';

    public $ame_deactivate_checkbox;
    public $ame_activation_tab_key;
    public $ame_deactivation_tab_key;
    public $ame_settings_menu_title;
    public $ame_settings_title;
    public $ame_menu_tab_activation_title;
    public $ame_menu_tab_deactivation_title;

    public $ame_options;
    public $ame_plugin_name;
    public $ame_product_id;
    public $ame_renew_license_url;
    public $ame_instance_id;
    public $ame_domain;
    public $ame_software_version;
    public $ame_plugin_or_theme;

    public $ame_update_version;

    public $ame_update_check = 'rfq_toolkit_plus_update_check';

    public $api_manager_key;

    /**
     * Used to send any extra information.
     * @var mixed array, object, string, etc.
     */
    public $ame_extra;
    public $isvalid = true;
    protected static $_instance = null;

    public static function instance()
    {

        if (is_null(self::$_instance))
            self::$_instance = new self();

        return self::$_instance;
    }


    public function __construct()
    {


        $this->gpls_woo_rfq_plus_setup_constants();
        $this->setup_email();
        $this->gpls_woo_rfq_plus_setup_includes();

        if (is_admin()) {
           // $this->license_init();

            if(!has_action('wp_loaded', array($this, 'license_init'))) {
            add_action('wp_loaded', array($this, 'license_init'), 1000);
            }

        }


        // if (!has_action('init', array($this, 'gpls_woo_rfq_plus_wp_init')))
        {
            add_action('init', array($this, 'gpls_woo_rfq_plus_wp_init'), 100);
        add_filter('plugin_row_meta', array(__CLASS__, 'plugin_row_meta'), 10, 2);
        }


        if (get_option($this->ame_activated_key) != 'Activated') {

            //  add_action('admin_notices', 'GPLS_WOO_RFQ_PLUS::inactive_notice');
            add_action('admin_notices', 'gpls_woo_rfq_plus_admin_notice_nolicense');
        }


        if (!is_admin()) {
            //   if (!has_action('plugins_loaded', array($this, 'gpls_woo_rfq_fields_init')))
            {
                add_action('plugins_loaded', array($this, 'gpls_woo_rfq_fields_init'), 10000);
            }
        } else {
            // if (!has_action('wp_loaded', array($this, 'gpls_woo_rfq_fields_init')))
            {
                add_action('wp_loaded', array($this, 'gpls_woo_rfq_fields_init'), 10000);
            }
        }

        //if (!has_action('plugins_loaded', array($this, 'gpls_woo_rfq_plus_plugins_loaded')))
        {
            add_action('plugins_loaded', array($this, 'gpls_woo_rfq_plus_plugins_loaded'), 10000);
        }

        //  if (!has_action('admin_head', array($this, 'gpls_woo_rfq_plus_enqueue_admin_css')))
        {
            add_action('admin_head', array($this, 'gpls_woo_rfq_plus_enqueue_admin_css'));
        }
        //  if (!has_action('admin_enqueue_scripts', array($this, 'gpls_woo_rfq_plus_enqueue_admin_scripts')))
        {
            add_action('admin_enqueue_scripts', array($this, 'gpls_woo_rfq_plus_enqueue_admin_scripts'));
        }

        // if (!has_action('wp_loaded', array($this, 'gpls_woo_rfq_plus_wp_loaded')))
        {
            // add_action('wp_loaded', array($this, 'gpls_woo_rfq_plus_wp_loaded'), 1000);
        }
        add_filter('gpls_woo_rfq_add_to_quote_styles', 'gpls_woo_rfq_add_to_quote_create_styles', 1000, 1);
        //  if (!has_action('wc_order_statuses', array($this, 'gpls_rfq_add_quote_request_to_order_statuses')))
        {
            add_filter('wc_order_statuses', array($this, 'gpls_rfq_add_quote_request_to_order_statuses'), 100, 1);
        }

        // if (!has_action('woocommerce_after_dashboard_status_widget', array($this, 'gpls_rfq_add_to_status_widget')))
        {
            add_action('woocommerce_after_dashboard_status_widget', array($this, 'gpls_rfq_add_to_status_widget'), 100, 1);
        }

        add_action('init', array($this, 'gpls_woo_rfq_setup_customer_cookie'), 1000);

        add_filter('init', function ($template) {
            if (isset($_GET['rfq_widget'])) {

                wc_get_template('woo-rfq/mini-rfq-cart.php');
                // die;
                //echo mt_rand();
                die();
            }
        });

    }


    public function gpls_woo_rfq_setup_customer_cookie()
    {

        if (!is_admin())
        {

            if (!function_exists('gpls_woo_rfq_get_item')) {
                require_once(gpls_woo_rfq_plus_DIR . 'wp-session-manager/wp-session-manager.php');
                require_once(ABSPATH . 'wp-includes/class-phpass.php');

                add_filter('_rfqtk_wp_session_expiration_variant', array($this, 'gpls_woo_rfq_set_expiration_time'), 24 * 60);
                add_filter('_rfqtk_wp_session_expiration', array($this, 'gpls_woo_rfq_set_expiration_variant_time'), 30 * 60);

                $wp_session = RFQTK_WP_Session::get_instance();
            }


        }
        }



    public function gpls_woo_rfq_set_expiration_variant_time($exp)
    {
        return 60 * 30;
    }


    public function gpls_woo_rfq_set_expiration_time($exp)
    {
        return 60 * 24;
    }


    public function gpls_woo_rfq_plus_wp_init()
    {

        // $this->setup_email();
        $status_label = get_option('settings_gpls_woo_rfq_quote_sent_label', 'Quotes Sent');
        $status_label = __($status_label, 'rfqtk');

        if ($status_label == '') {
            $status_label = __('Quotes Sent', 'rfqtk');
        }

        register_post_status('wc-gplsquote-sent', array(
            'label' => 'Quote Sent',
            'public' => true,
            'exclude_from_search' => false,
            'show_in_admin_all_list' => true,
            'show_in_admin_status_list' => true,
            'label_count' => _n_noop($status_label . '<span class="count">(%s)</span>', $status_label . ' <span class="count">(%s)</span>')
        ));


        $status_label = get_option('settings_gpls_woo_rfq_quote_request_label', 'Quote Requests');
        $status_label = __($status_label, 'rfqtk');

        if ($status_label == '') {
            $status_label = __('Quote Requests', 'rfqtk');
        }

        register_post_status('wc-gplsquote-req', array(
            'label' => $status_label,
            'public' => true,
            'exclude_from_search' => false,
            'show_in_admin_all_list' => true,
            'show_in_admin_status_list' => true,
            'label_count' => _n_noop($status_label . '<span class="count">(%s)</span>', $status_label . ' <span class="count">(%s)</span>')
        ));

        $show_prices = get_option('settings_gpls_woo_rfq_show_prices_customer_confirmation_email', 'no');

        if ($show_prices == 'yes') {

            add_filter('gpls_woo_rfq_show_prices_customer_email', 'gpls_woo_rfq_plus_show_email_prices');

        }

        $GLOBALS["gpls_4woo_quote_current_url"] = preg_replace('{/$}', '', $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);

        $link_to_rfq_page = preg_replace('{/$}', '', gpls_woo_rfq_remove_http(pls_woo_rfq_get_link_to_rfq()));

        if (trim(substr(trim($GLOBALS["gpls_4woo_quote_current_url"]), 0, strlen($link_to_rfq_page))) == trim($link_to_rfq_page) && isset($_REQUEST['order_id'])) {

            add_filter('woocommerce_is_order_received_page', array($this, 'gpls_rfq_woocommerce_is_order_received_page'), 100, 1);

        }


    }


    public function gpls_rfq_woocommerce_is_order_received_page($is_order_received)
    {

        return true;
    }


    public function gpls_rfq_add_to_status_widget($reports)
    {
        if (!current_user_can('edit_shop_orders')) {
            return;
        }
        $quote_request_count = 0;
        $quote_request_label = get_option('settings_gpls_woo_rfq_quote_request_label', 'Quote Requests');
        $quote_request_label = __($quote_request_label, 'rfqtk');

        if ($quote_request_label == '') {
            $on_hold_label = __('Quote Requests', 'rfqtk');
        }

        $quote_sent_count = 0;
        $quote_sent_label = get_option('settings_gpls_woo_rfq_quote_sent_label', 'Quotes Sent');
        $quote_request_label = __($quote_request_label, 'rfqtk');

        if ($quote_sent_label == '') {
            $quote_sent_label = __('Quotes Sent', 'rfqtk');
        }


        foreach (wc_get_order_types('order-count') as $type) {
            $counts = (array)wp_count_posts($type);
            $quote_request_count += isset($counts['wc-gplsquote-req']) ? $counts['wc-gplsquote-req'] : 0;
            $quote_sent_count += isset($counts['wc-gplsquote-sent']) ? $counts['wc-gplsquote-sent'] : 0;
        }
        ?>
        <li class="gplsquote-sent">
            <a href="<?php echo admin_url('edit.php?post_status=wc-gplsquote-sent&post_type=shop_order'); ?>">
                <?php
                /* translators: %s: order count */
                printf(
                    _n('<strong>%s order</strong> ' . $quote_sent_label, '<strong>%s orders</strong> ' . $quote_sent_label, $quote_sent_count, 'woocommerce'),
                    $quote_sent_count
                );
                ?>
            </a>
        </li>
        <li class="gplsquote-req">
            <a href="<?php echo admin_url('edit.php?post_status=wc-gplsquote-req&post_type=shop_order'); ?>">
                <?php
                /* translators: %s: order count */
                printf(
                    _n('<strong>%s order</strong> ' . $quote_request_label, '<strong>%s orders</strong> ' . $quote_request_label, $quote_request_count, 'woocommerce'),
                    $quote_request_count
                );
                ?>
            </a>
        </li>
        <?php
    }


    // Add to list of WC Order statuses
    public function gpls_rfq_add_quote_request_to_order_statuses($order_statuses)
    {


        $order_statuses = array_reverse($order_statuses, True);


        $status_label = get_option('settings_gpls_woo_rfq_quote_sent_label', 'Quotes Sent');
        $status_label = __($status_label, 'rfqtk');

        if ($status_label == '') {
            $status_label = __('Quotes Sent', 'rfqtk');
        }

        $order_statuses["wc-gplsquote-sent"] = $status_label;
        $order_statuses["wc-gplsquote-req"] = $status_label;


        $order_statuses = array_reverse($order_statuses, True);


        $status_label = get_option('settings_gpls_woo_rfq_quote_request_label', 'Quote Requests');
        $status_label = __($status_label, 'rfqtk');

        if ($status_label == '') {
            $status_label = __('Quote Requests', 'rfqtk');
        }
        return $order_statuses;
    }


    public function gpls_woo_rfq_plus_wp_loaded()
    {

        //add_filter('gpls_woo_rfq_add_to_quote_styles', 'gpls_woo_rfq_add_to_quote_create_styles', 1000, 1);
    }

    public function gpls_woo_rfq_fields_init()
    {

        add_action('plugins_loaded', array($this, 'gpls_woo_rfq_load_plus_textdomain'));


        if (!is_admin()) {
            $this->gpls_woo_rfq_plus_css_js();
        }

        $this->setup_gateway();

        $plugin = plugin_basename(__FILE__);

        add_filter("plugin_action_links_$plugin", array($this, 'rfqtk_plugin_settings_link'));

        // $this->gpls_woo_rfq_plus_settings();


    }


    public function gpls_woo_rfq_plus_deactivation()
    {
        // actions to perform once on plugin deactivation go here

    }

    public function gpls_woo_rfq_plus_uninstall()
    {

        //actions to perform once on plugin uninstall go here

        $this->uninstall();

    }

    public function rfqtk_plugin_settings_link($links)
    {
        if (!defined('setting_link_set')) {
            DEFINE('setting_link_set', true);
            $settings_link = admin_url('admin.php?page=wc-settings&tab=settings_gpls_woo_rfq&section=');
            $settings_link = '<a href="' . $settings_link . '">Settings</a>';
            array_unshift($links, $settings_link);

        }
        return $links;
    }

    public function setup_gateway()
    {
        require_once(gpls_woo_rfq_plus_DIR . 'includes/gateway/rfqtk-gateway.php');
        $wc_gateway_frq_plus = new WC_Gateway_RFQ_Plus();

    }

    public function gpls_woo_rfq_plus_settings()
    {

        if (is_admin()) {
            require_once(gpls_woo_rfq_plus_DIR . 'includes/admin/rfqtk_admin.php');
            gpls_woo_rfq_plus_Admin::init();
        }

    }

    public function gpls_woo_rfq_load_plus_textdomain()
    {
        load_plugin_textdomain('rfqtk', false, dirname(plugin_basename(__FILE__)) . '/languages/');

    }

    public static function plugin_row_meta($links, $file)
    {
        if (gpls_woo_rfq_plus_PLUGIN_PATH === $file) {
            $row_meta = array(
                'trial' => '<a href="' . esc_url('https://www.neahplugins.com/product/rfq-toolkit-plus/') . '" aria-label="' . esc_attr__('Product Page', 'rfqtk') . '">' . esc_html__('Home', 'rfqtk') . '</a>',
                'Support'    => '<a href="' . esc_url(  'https://www.neahplugins.com/contact/'  ) . '" aria-label="' . esc_attr__( 'Support', 'rfqtk' ) . '">' . esc_html__( 'Support', 'woocommerce' ) . '</a>',
            );

            return array_merge($links, $row_meta);
        }

        return (array)$links;
    }


    public function gpls_woo_rfq_plus_setup_includes()
    {

        if (class_exists('GPLS_WOO_RFQ')) {
            //return;

            if (!function_exists('gpls_woo_rfq_get_item'))
            {
                require_once(gpls_woo_rfq_plus_DIR . 'wp-session-manager/wp-session-manager.php');
                require_once(ABSPATH . 'wp-includes/class-phpass.php');
            }


            require_once(gpls_woo_rfq_plus_DIR . 'includes/rfqtk_functions.php');
            $gpls_woo_rfq_plus_functions = new gpls_woo_rfq_plus_functions();


            require_once(gpls_woo_rfq_plus_DIR . 'includes/form/form_functions.php');
            $rfqtk_form_functions = new rfqtk_form_functions();

            require_once(gpls_woo_rfq_plus_DIR . 'includes/stock/stock_functions.php');
            $rfqtk_stock_functions = new rfqtk_stock_functions();

            require_once(gpls_woo_rfq_plus_DIR . 'includes/notes/notes_functions.php');
            $rfqtk_notes_functions = new rfqtk_notes_functions();

            require_once(gpls_woo_rfq_plus_DIR . 'includes/emails/customer-confirm.php');
            $class_customer_confirmations_rfq_plus = new class_customer_confirmations_rfq_plus();


            require_once(gpls_woo_rfq_plus_DIR . 'includes/emails/email_functions.php');
            $rfqtk_email_functions = new rfqtk_email_functions();

            require_once(gpls_woo_rfq_plus_DIR . 'includes/rfq_page/class-rfq-page-plus.php');
            $class_rfq_page_plus = new class_rfq_page_plus();

            require_once(gpls_woo_rfq_plus_DIR . 'includes/offer/offer_functions.php');
            $rfqtk_offer_functions = new rfqtk_offer_functions();

            if(class_exists('GPLS_WOO_RFQ')){
            require_once(gpls_woo_rfq_plus_DIR . 'includes/rfq_page/class-rfq_page-plus-widget.php');
            $rfq_page_plus_Widget = new rfq_page_plus_Widget();
            }

        }
    }

    public function gpls_woo_rfq_plus_email_confirm_includes()
    {

    }


    public function gpls_woo_rfq_plus_plugins_loaded()
    {

        if (!class_exists('GPLS_WOO_RFQ')) {

            add_action('admin_notices', 'gpls_woo_rfq_plus_admin_notice_nobasic');
            return;

        }

        $this->gpls_woo_rfq_plus_settings();
        $this->setup_email();



    }

    public function gpls_woo_rfq_plus_enqueue_admin_css()
    {
        if (is_admin()) {
            $url_css = gpls_woo_rfq_plus_URL . 'assets/css/rfqtk_admin.css';

            $url_css_path = gpls_woo_rfq_plus_DIR . 'assets/css/rfqtk_admin.css';
            wp_enqueue_style('gpls_woo_rfq_plus_css_admin', $url_css, array(), filemtime($url_css_path));

        }
    }

    public function gpls_woo_rfq_plus_enqueue_admin_scripts($hook_suffix)
    {


        if (is_admin()) {
            $gpls_woo_rfq_plus_admin_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk_admin.js';
            $gpls_woo_rfq_plus_admin_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk_admin.js';
            wp_enqueue_script('gpls_woo_rfq_plus_admin_js', $gpls_woo_rfq_plus_admin_js, array('wp-color-picker'), filemtime($gpls_woo_rfq_plus_admin_js_path), true);

        }
    }


    public function gpls_woo_rfq_plus_enqueue_scripts()
    {

        if (!is_admin()) {


            $is_quote_page = false;

            $GLOBALS["gpls_4woo_quote_current_url"] = preg_replace('{/$}', '', $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);

            $link_to_rfq_page = preg_replace('{/$}', '', gpls_woo_rfq_remove_http(pls_woo_rfq_get_link_to_rfq()));

            if (trim(substr(trim($GLOBALS["gpls_4woo_quote_current_url"]), 0, strlen($link_to_rfq_page))) == trim($link_to_rfq_page)) {
                $is_quote_page = true;
            }

            if (is_checkout() || $is_quote_page == true) {

                $url_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk_checkout_form.js';
                $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk_checkout_form.js';
                wp_enqueue_script('gpls_woo_rfq_plus_checkout_form_js', $url_js, array('jquery'), filemtime($url_js_path), true);

            }


            $url_css = gpls_woo_rfq_plus_URL . 'assets/css/rfqtk.css';
            $url_css_path = gpls_woo_rfq_plus_DIR . 'assets/css/rfqtk.css';
            wp_enqueue_style('gpls_woo_rfq_plus_css', $url_css, array(), filemtime($url_css_path));

            $list = 'enqueued';


            $url_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk.js';
            $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk.js';
            wp_enqueue_script('gpls_woo_rfq_plus_js', $url_js, array('jquery'), filemtime($url_js_path), true);


            if ($is_quote_page == true) {
                $custom_js = "";
                if ($GLOBALS["gpls_woo_rfq_show_prices"] == "yes") {
                    $custom_js =
                        "jQuery(document ).ready( function() { jQuery( '.tm-custom-price-totals' ).show();jQuery( '.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2,.xcp-ctotal .amount,.xcp-totxt' ).show();jQuery( '.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2, .xcp-ctotal .amount,.xcp-totxt' ).show();} );";
                } else {
                    $custom_js = "jQuery(document ).ready( function() { jQuery( '.tm-custom-price-totals').hide();jQuery( '.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2,.xcp-ctotal .amount,.xcp-totxt' ).hide();jQuery( '.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2,.xcp-ctotal .amount,.xcp-totxt' ).hide();});";
                }

                //custom js will fire with jQuery(window).load(function () { //alert(1); });
                $custom_js = apply_filters('gpls_woo_rfq_plus_custom_js', $custom_js);

                wp_add_inline_script('gpls_woo_rfq_plus_js', $custom_js);

                $custom_css = "";
                if ($GLOBALS["gpls_woo_rfq_show_prices"] == "yes") {
                    $custom_css = ".tm-custom-price-totals ,.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2,.xcp-ctotal .amount,.xcp-totxt' ).show();jQuery( '.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2,.xcp-ctotal .amount,.xcp-totxt {display:block !important;}";
                } else {
                    $custom_css = ".tm-custom-price-totals ,.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2,.xcp-ctotal .amount,.xcp-totxt' ).hide();jQuery( '.amount,.bundle_price,.woocommerce-Price-amount,.from, .price,.total, .bundle_price,.wc-pao-col2,.xcp-ctotal .amount,.xcp-totxt {display:none !important;}";
                }

                // $custom_css .='.single_add_to_cart_button {display:none;}#woo_pp_ec_button_product {display:none !important;}.gpls_rfq_set{display:block !important;}';


                $custom_css = apply_filters("gpls_woo_rfq_plus_custom_css", $custom_css);

                wp_add_inline_style('gpls_woo_rfq_plus_css', $custom_css);
            }

            $qp_upload = get_option("settings_gpls_woo_rfq_remove_update_cart_in_rfq_cart", "no");

            if ($qp_upload == "yes") {

                $url_qp_upload_css = gpls_woo_rfq_plus_URL . 'assets/css/qp_upload.css';
                $url_qp_upload_css_path = gpls_woo_rfq_plus_DIR . 'assets/css/qp_upload.css';
                wp_enqueue_style('gpls_woo_rfq_qp_upload_css', $url_qp_upload_css, array(), filemtime($url_qp_upload_css_path));

                $url_qp_upload_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk_qp_upload.js';
                $url_qp_upload_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk_qp_upload.js';
                wp_enqueue_script('gpls_woo_rfq_qp_upload_js', $url_js, array('jquery'), filemtime($url_qp_upload_js_path), true);

            }


        }
    }

    public function gpls_woo_rfq_plus_css_js()
    {
        if (!is_admin()) {

            add_action('wp_enqueue_scripts', array($this, 'gpls_woo_rfq_plus_enqueue_scripts'), 2000);


        }
    }

    public function gpls_woo_rfq_plus_setup_constants()
    {
        if (!defined('gpls_woo_rfq_plus_DIR')) {
            DEFINE('gpls_woo_rfq_plus_DIR', plugin_dir_path(__FILE__));
            DEFINE('gpls_woo_rfq_plus_URL', plugin_dir_url(__FILE__));
            DEFINE('gpls_woo_rfq_plus_FILE_NAME', (__FILE__));
            DEFINE('gpls_woo_rfq_plus_PLUGIN_PATH', untrailingslashit(plugin_basename(__FILE__)));
            DEFINE('gpls_woo_rfq_plus_TEMPLATE_PATH', untrailingslashit(plugin_dir_path(__FILE__)) . '/templates/');
            DEFINE('gpls_woo_rfq_plus_WOO_PATH', untrailingslashit(plugin_dir_path(__FILE__)) . '/woocommerce/');
        }
    }


    public function gpls_woo_rfq_plus_no_price_enqueue_scripts()
    {

    }


    public function setup_email()
    {
        require_once(gpls_woo_rfq_plus_DIR . 'includes/emails/rfqtk-email.php');
        // $wc_email_rfq_plus = new WC_Email_RFQ_PLUS();

    }

    function footer_action()
    {


    }


//license

    public function plugin_url()
    {

        return $this->plugin_url = gpls_woo_rfq_plus_License_URL;
    }




    /**
     * Deactivates the license on the API server
     * @return void
     */
    public function license_key_deactivation()
    {
        //update_option('api_manager_rfqtk_plus_activated', 'no');

        $activation_status = get_option($this->ame_activated_key);

        $api_email = $this->ame_options[$this->ame_activation_email];
        $api_key = $this->ame_options[$this->ame_api_key];

        $args = array(
            'email' => $api_email,
            'licence_key' => $api_key,
            'api_key' => $api_key,

        );



        //if ($activation_status == 'Activated' && $api_key != '' && $api_email != '') {

        if ( $api_key != '' && $api_email != '') {

             $this->api_manager_key = new Api_Manager_Woo_RFQ_Key();
            $this->api_manager_key->deactivate($args); // reset license key activation
        }


        //ini_set('display_errors', 0);


    }

    /**
     * Displays an inactive notice when the software is inactive.
     */
    public static function inactive_notice()
    { ?>
        <?php if (!current_user_can('manage_options')) return; ?>
        <?php if (isset($_GET['page']) && 'wc_api_manager_rfqtk_plus_dashboard' == $_GET['page']) return; ?>
        <div id="message" class="error">
            <p><?php printf(__('NP Quote Request WooCommerce Plus License Key has not been activated. %sClick here%s to activate the license key for automatic updates and full functionality.', 'rfqtk'), '<a href="' . esc_url(admin_url('options-general.php?page=wc_api_manager_rfqtk_plus_dashboard')) . '">', '</a>'); ?></p>
        </div>
        <?php
    }

    public function license_init()
    {

        $this->ame_software_product_id = 'RFQ_ToolKit_Plus';

        /**
         * Set all data defaults here
         */
        $this->ame_data_key = 'RFQ_ToolKit_Plus';
        $this->ame_api_key = 'api_key';
        $this->ame_activation_email = 'activation_email';
        $this->ame_product_id_key = 'RFQ_ToolKit_Plus';
        $this->ame_product_id = 'RFQ_ToolKit_Plus';
        $this->ame_instance_key = 'api_manager_rfqtk_plus_instance';
        $this->ame_deactivate_checkbox_key = 'api_manager_rfqtk_plus_deactivate_checkbox';
        $this->ame_activated_key = 'api_manager_rfqtk_plus_activated';

        /**
         * Set all admin menu data
         */
        $this->ame_deactivate_checkbox = 'api_manager_deactivate_checkbox';
        $this->ame_activation_tab_key = 'wc_api_manager_rfqtk_plus_dashboard';
        $this->ame_deactivation_tab_key = 'api_manager_deactivation';
        $this->ame_settings_menu_title = 'RFQ ToolKit Plus';
        $this->ame_settings_title = 'RFQ_ToolKit_Plus';
        $this->ame_menu_tab_activation_title = __('License Activation', 'rfqtk');
        $this->ame_menu_tab_deactivation_title = __('License Deactivation', 'rfqtk');

        /**
         * Set all software update data here
         */
        $this->ame_options = get_option($this->ame_data_key);
        $this->ame_plugin_name = gpls_woo_rfq_plus_PLUGIN_PATH; // same as plugin slug. if a theme use a theme name like 'twentyeleven'
        //$this->ame_product_id = get_option($this->ame_product_id_key); // Software Title
        $this->ame_renew_license_url = 'https://www.neahplugins.com/my-account'; // URL to renew a license
        $this->ame_instance_id = get_option($this->ame_instance_key); // Instance ID (unique to each blog activation)
        $this->ame_domain = site_url(); // blog domain name
        $this->ame_software_version = $this->version; // The software version
        $this->ame_plugin_or_theme = 'plugin'; // 'theme' or 'plugin'

        // Performs activations and deactivations of API License Keys
        require_once(gpls_woo_rfq_plus_DIR . 'includes/am/classes/class-wc-key-api.php');
        $this->api_manager_key = new Api_Manager_Woo_RFQ_Key();

        // Checks for software updatess
        require_once(gpls_woo_rfq_plus_DIR . 'includes/am/classes/class-wc-plugin-update.php');

        // Admin menu with the license key and license email form
        require_once(gpls_woo_rfq_plus_DIR . 'includes/am/admin/class-wc-api-manager-menu.php');

        //$API_Manager_RFQ_MENU = new API_Manager_RFQ_MENU();


        $options = get_option($this->ame_data_key);

        /**
         * Check for software updates
         */
        if (isset($options) && $options !== false) {

            $API_Manager_Woo_RFQ_Update_API_Check = new API_Manager_Woo_RFQ_Update_API_Check(
                $this->upgrade_url,
                $this->ame_plugin_name,
                $this->ame_product_id,
                $this->ame_options[$this->ame_api_key],
                $this->ame_options[$this->ame_activation_email],
                $this->ame_renew_license_url,
                $this->ame_instance_id,
                $this->ame_domain,
                $this->ame_software_version,
                $this->ame_plugin_or_theme,
                $this->text_domain
            );

            //$API_Manager_Woo_RFQ_Update_API_Check->check_license();


        }

    }


}
register_activation_hook(__FILE__, 'rfqtk_activation');

function rfqtk_activation()
{
    $this_plugin = GPLS_WOO_RFQ_PLUS::instance();

    global $wpdb;

    $global_options = array(
        $this_plugin->ame_api_key => '',
        $this_plugin->ame_activation_email => '',
    );

    update_option($this_plugin->ame_data_key, $global_options);

    require_once(gpls_woo_rfq_plus_DIR . 'includes/am/classes/class-wc-api-manager-passwords.php');

    $api_manager_Password_Management = new API_Manager_Woo_RFQ_Password_Management();

    // Generate a unique installation $instance id
    $instance = $api_manager_Password_Management->generate_password(12, false);

    $activation_status = get_option($this_plugin->ame_activated_key);

    if ($activation_status == false || $activation_status == null) {
        $single_options = array(
            $this_plugin->ame_product_id_key => $this_plugin->ame_software_product_id,
            $this_plugin->ame_instance_key => $instance,
            $this_plugin->ame_deactivate_checkbox_key => __('on', 'rfqtk'),
            $this_plugin->ame_activated_key => __('Deactivated', 'rfqtk'),
        );
    } else {
        $single_options = array(
            $this_plugin->ame_product_id_key => $this_plugin->ame_software_product_id,
            $this_plugin->ame_instance_key => $instance,
            $this_plugin->ame_deactivate_checkbox_key => __('on', 'rfqtk'),
            //   $this->ame_activated_key => __('Deactivated', 'rfqtk'),
        );
    }

    foreach ($single_options as $key => $value) {
        update_option($key, $value);
    }

    $curr_ver = get_option($this_plugin->api_manager_version_name);

    // checks if the current plugin version is lower than the version being installed
    if (version_compare($this_plugin->version, $curr_ver, '>')) {
        // update the version
        update_option($this_plugin->api_manager_version_name, $this_plugin->version);
    }

    set_site_transient('update_plugins', null);



}


register_deactivation_hook(__FILE__, 'rfqtk_uninstall');

register_uninstall_hook(__FILE__, 'rfqtk_uninstall');

function rfqtk_uninstall()
{

    $this_plugin = GPLS_WOO_RFQ_PLUS::instance();
    //update_option('api_manager_rfqtk_plus_activated', 'no');
    //ini_set('display_errors', 0);

    global $wpdb, $blog_id;


    $this_plugin->license_key_deactivation();

    // Remove options
    if (is_multisite()) {

        switch_to_blog($blog_id);

        foreach (array(
                     $this_plugin->ame_data_key,
                     $this_plugin->ame_product_id_key,
                     $this_plugin->ame_instance_key,
                     $this_plugin->ame_deactivate_checkbox_key,
                     $this_plugin->ame_activated_key,
                 ) as $option) {

            delete_option($option);
        }
        delete_option('api_manager_rfqtk_plus_instance');
        restore_current_blog();

    } else {

        foreach (array(
                     $this_plugin->ame_data_key,
                     $this_plugin->ame_product_id_key,
                     $this_plugin->ame_instance_key,
                     $this_plugin->ame_deactivate_checkbox_key,
                     $this_plugin->ame_activated_key
                 ) as $option) {

            delete_option($option);

        }

        delete_option('api_manager_rfqtk_plus_instance');

    }


}








?>