<?php
/**
 * Functions used by plugins
 */


if (!function_exists('gpls_woo_rfq_get_item')) {
    require_once(gpls_woo_rfq_plus_DIR . 'wp-session-manager/wp-session-manager.php');
    require_once(ABSPATH . 'wp-includes/class-phpass.php');
}


add_filter('woocommerce_valid_order_statuses_for_payment', 'rfqtk1_statuses_for_payment', 100, 2);
add_filter('woocommerce_valid_order_statuses_for_payment_complete', 'rfqtk1_statuses_for_payment', 100, 2);

add_filter( 'woocommerce_product_get_stock_quantity' ,'custom_get_stock_quantity', 1000, 2 );
add_filter( 'woocommerce_product_variation_get_stock_quantity' ,'custom_get_stock_quantity', 1000, 2 );
add_filter( 'woocommerce_product_bundle_get_stock_quantity' ,'custom_get_stock_quantity', 1000, 2 );
add_filter( 'woocommerce_pay_order_product_in_stock','custom_pay_order_product_in_stock', 1000,3 );





//add_action('woo_rfq_delay_marketing_content_hours_event', 'gplsrfq_send_product_marketing_content', 10, 1);
//add_action('woo_rfq_delay_quote_hours_event', 'gplsrfq_change_to_sent_old', 10, 4);

if (!function_exists('custom_pay_order_product_in_stock')) {
    function custom_pay_order_product_in_stock($is_in_stock, $product, $order)
    {

        if (!rfqtk_managing_stock($product) || $order->has_status( 'gplsquote-sent' )
    || !$order->has_status( 'wc-gplsquote-sent' )) {
            $is_in_stock = true;
        }
        return $is_in_stock;
    }
}


if (!function_exists('custom_get_stock_quantity')) {
    function custom_get_stock_quantity($value, $product)
    {

        $url = $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
        $template_name = '/order-pay/';

        if (strpos($url, $template_name) !== false) {
            $start = strpos($url, $template_name);
            $first_part = substr($url, $start + strlen($template_name));
            $order_id = substr($first_part, 0, strpos($first_part, '/'));

            if (isset($_GET['pay_for_order'], $_GET['key']) && $order_id) {
                $order_key = $_GET['key'];
                $order = wc_get_order($order_id);

            }

            if ( $order->has_status( 'gplsquote-sent' )
                || $order->has_status( 'wc-gplsquote-sent' )
                || $order->has_status( 'pending' )
                || $order->has_status( 'wc-gplsquote-req' ) ) {
                $value = 10000;
            }
        }

        if (!rfqtk_managing_stock($product)  )
        {
            $value = 10000;
        }
        return $value;
    }
}

if (!function_exists('rfqtk_managing_stock')) {
    function rfqtk_managing_stock($product)
    {
        $manage = false;

        if ('yes' === get_option('woocommerce_manage_stock')) {
            $manage = true;
        }

        if ('yes' === get_option('woocommerce_manage_stock') && $product->get_manage_stock()) {
            $manage = true;
        }
        return $manage;
    }
}


if (!function_exists('rfqtk_first')) {
    function rfqtk_first()
    {
        gpls_woo_rfq_plus_check_staff_mode();

        if (isset($_REQUEST['pay_for_order']) && strpos($_REQUEST['key'], 'wc_order_', 0) === 0) {
            $GLOBALS["gpls_woo_rfq_show_prices"] = "yes";
            $GLOBALS["hide_for_visitor"] = "no";
            return true;
        }
    }
}


if (!function_exists('rfqtk1_statuses_for_payment')) {

    function rfqtk1_statuses_for_payment($array, $order)
    {
        array_push($array, 'gplsquote-sent');
        array_push($array, 'wc-gplsquote-sent');
        return $array;
    }
}



add_action('wp_print_footer_scripts', 'gpls_woo_rfq_addresses_js_print_script', 1000);

function gpls_woo_rfq_addresses_js_print_script()
{
    ?>
    <script type="application/javascript">

        if (jQuery('#rfq_billing_country').val() != 'US') {
            jQuery('#rfq_state_select').val("");
            jQuery('#rfq_state_select').hide();
            jQuery('#rfq_state_text').show();
            jQuery('#rfq_state_select').attr("required", false);
            jQuery('#rfq_state_text').attr("required", true);
        } else {
            jQuery('#rfq_state_text').val("");
            jQuery('#rfq_state_text').hide();
            jQuery('#rfq_state_select').show();
            jQuery('#rfq_state_select').attr("required", true);
            jQuery('#rfq_state_text').attr("required", false);

        }

        jQuery('.rfq_billing_country').on('change', function () {

            if (jQuery('#rfq_billing_country').val() != 'US') {
                jQuery('#rfq_state_select').val("");
                jQuery('#rfq_state_select').hide();
                jQuery('#rfq_state_select').attr("required", false);
                jQuery('#rfq_state_text').show();
                jQuery('#rfq_state_text').attr("required", true);
            } else {
                jQuery('#rfq_state_text').val("");
                jQuery('#rfq_state_text').hide();
                jQuery('#rfq_state_text').attr("required", false);
                jQuery('#rfq_state_select').show();
                jQuery('#rfq_state_select').attr("required", true);
            }

        });
        jQuery( document ).ready( function() {




            jQuery('form.checkout').on('click', function(){
                jQuery('form.checkout').removeAttr( 'novalidate');
            });

        });


    </script>

    <?php
}


add_action('woocommerce_before_pay_action', 'gpls_before_pay_action', 1000);

function gpls_before_pay_action($order)
{

    if (isset($_POST['gpls_address_at_payorder'])) {

        if (isset($_POST['rfq_state_select'])) {
            if ($_POST['rfq_state_select'] == "") {
                $billing_state = sanitize_text_field($_POST['rfq_state_text']);
            } else {
                $billing_state = sanitize_text_field($_POST['rfq_state_select']);
            }
        } else {
            $billing_state = "";
        }

        // $order = wc_get_order(1);
        $order->set_billing_company($_POST['rfq_company']);
        $order->set_billing_country($_POST['rfq_billing_country']);
        $order->set_billing_state($billing_state);
        $order->set_billing_city($_POST['rfq_city']);
        $order->set_billing_address_1($_POST['rfq_address']);
        $order->set_billing_address_2($_POST['rfq_address2']);
        $order->set_billing_postcode($_POST['rfq_zip']);

        $order->set_shipping_company($_POST['rfq_company']);
        $order->set_shipping_country($_POST['rfq_billing_country']);
        $order->set_shipping_state($billing_state);
        $order->set_shipping_address_1($_POST['rfq_address']);
        $order->set_shipping_address_2($_POST['rfq_address2']);
        $order->set_shipping_city($_POST['rfq_city']);
        $order->set_shipping_postcode($_POST['rfq_zip']);

        if (isset($_POST['rfq_phone'])) {
            $order->set_billing_phone($_POST['rfq_phone']);
        }
        $order->save();

    }
}




add_action('woocommerce_pay_order_before_submit', 'rftk_plus_panon_pay_order', 1000);

function rftk_plus_panon_pay_order()
{
     include(gpls_woo_rfq_plus_DIR.'woocommerce/woo-rfq/checkout/pay-address.php');
}









if(!function_exists('gpls_woo_rfq_remove_http')) {
    function gpls_woo_rfq_remove_http($url)
    {
        $disallowed = array('http://', 'https://');
        foreach ($disallowed as $d) {
            if (strpos($url, $d) === 0) {
                return str_replace($d, '', $url);
            }
        }
        return $url;
    }
}
if(!function_exists('pls_woo_rfq_get_link_to_rfq')) {
    function pls_woo_rfq_get_link_to_rfq()
    {


        $home = home_url() . '/quote-request/';

        $rfq_page = get_option('rfq_cart_sc_section_show_link_to_rfq_page', $home);

        if (is_ssl()) {

            $rfq_page = preg_replace("/^http:/i", "https:", $rfq_page);

        }

        return $rfq_page;


    }
}


if(get_option('settings_gpls_plus_allow_anon_at_pay_order', "no")=="yes") {
    add_action('before_woocommerce_pay', 'rftk_plus_npanon_pay_order', 1000);
}

function rftk_plus_npanon_pay_order()
{
    // $order_id=0;
    $url = $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
    $template_name = '/order-pay/';
    if (strpos($url, $template_name) !== false) {
        $start = strpos($url, $template_name);
        $first_part = substr($url, $start + strlen($template_name));
        $order_id = substr($first_part, 0, strpos($first_part, '/'));
    }

    if ($order_id == false) return;

    $order_key = $_GET['key'];
    $order = wc_get_order($order_id);

    if($order->get_user()==false){
        return;
    }

    wc_print_notices();


    // Pay for existing order.
    if (isset($_GET['pay_for_order'], $_GET['key']) && $order_id) {
        try {
            $order_key = $_GET['key'];
            $order = wc_get_order($order_id);

            if($order->get_user()==false){
                return;
            }

            // Order or payment link is invalid.
            if (!$order || $order->get_id() != $order_id || $order->get_order_key() !== $order_key) {
                //throw new Exception(__('Sorry, this order is invalid and cannot be paid for.', 'np_anon'));
                // wc_add_notice(sprintf(__('Sorry, this order is invalid and cannot be paid for.', 'np_anon')),"error");
                return;

            }


            if (!is_user_logged_in() ) {

                $options = get_option('np_anon_payorder_settings');

                $allow_anon = $options['np_anon_payorder_allow_visitor_pay'];

                if ($allow_anon == false) {
                    return;
                }
            }


            if (is_user_logged_in() ) {
                return;
            }


            // Does not need payment.
            if (!$order->needs_payment()) {
                wc_add_notice(sprintf(__('This order&rsquo;s status is &ldquo;%s&rdquo;&mdash;it cannot be paid for. Please contact us if you need assistance.', 'np_anon'), wc_get_order_status_name($order->get_status())),"error");
                //$exception =  new Exception(sprintf(__('This order&rsquo;s status is &ldquo;%s&rdquo;&mdash;it cannot be paid for. Please contact us if you need assistance.', 'np_anon'), wc_get_order_status_name($order->get_status())));
                // sprintf($exception);
                return;

            }

            // Ensure order items are still stocked.
            if ( ! $order->has_status( 'pending' ) && !$order->has_status( 'gplsquote-sent' )
                && !$order->has_status( 'wc-gplsquote-sent' )
                && !$order->has_status( 'wc-gplsquote-req' ) ) {
                $quantities = array();

                foreach ( $order->get_items() as $item_key => $item ) {
                    if ( $item && is_callable( array( $item, 'get_product' ) ) ) {
                        $product = $item->get_product();

                        if ( ! $product ) {
                            continue;
                        }

                        $quantities[ $product->get_stock_managed_by_id() ] = isset( $quantities[ $product->get_stock_managed_by_id() ] ) ? $quantities[ $product->get_stock_managed_by_id() ] + $item->get_quantity() : $item->get_quantity();
                    }
                }

                foreach ( $order->get_items() as $item_key => $item ) {
                    if ( $item && is_callable( array( $item, 'get_product' ) ) ) {
                        $product = $item->get_product();

                        if ( ! $product ) {
                            continue;
                        }



                        if ( ! apply_filters( 'woocommerce_pay_order_product_in_stock', $product->is_in_stock(), $product, $order ) ) {
                            /* translators: %s: product name */
                            throw new Exception( sprintf( __( 'Sorry, "%s" is no longer in stock so this order cannot be paid for. We apologize for any inconvenience caused.', 'woocommerce' ), $product->get_name() ) );
                        }

                        // Check stock based on all items in the cart and consider any held stock within pending orders.
                        $held_stock     = wc_get_held_stock_quantity( $product, $order->get_id() );
                        $required_stock = $quantities[ $product->get_stock_managed_by_id() ];

                        if ( $product->get_stock_quantity() < ( $held_stock + $required_stock ) ) {
                            /* translators: 1: product name 2: quantity in stock */
                            throw new Exception( sprintf( __( 'Sorry, we do not have enough "%1$s" in stock to fulfill your order (%2$s available). We apologize for any inconvenience caused.', 'woocommerce' ), $product->get_name(), wc_format_stock_quantity_for_display( $product->get_stock_quantity() - $held_stock, $product ) ) );
                        }
                    }
                }
            }



            $available_gateways = WC()->payment_gateways->get_available_payment_gateways();

            if (sizeof($available_gateways)) {
                current($available_gateways)->set_current();
            }

            echo '<div style="background: #0B6121;color: white;margin:20px; padding: 20px ">';

            $options = get_option( 'np_anon_payorder_settings' );

            $visitor_message = __($options['np_anon_payorder_visitor_message'],'np_anon');

            if(trim($visitor_message) ==""){
                $visitor_message = __("You can pay for this invoice here or log in below before continuing with payment.","np_anon");
            }

            echo(__($visitor_message, 'np_anon'));
            echo '</div>';



            wc_get_template('checkout/form-pay.php', array(
                'order' => $order,
                'available_gateways' => $available_gateways,
                'order_button_text' => apply_filters('woocommerce_pay_order_button_text', __('Pay for order', 'np_anon')),
            ));

        } catch (Exception $e) {
            wc_add_notice($e->getMessage(), 'error');
        }
    } else {
        wc_add_notice(__('Invalid order.', 'np_anon'), 'error');
    }

    wc_clear_notices();

    rftk_plus_npanon_payorderfor_payment_css_js();

    do_action('after_woocommerce_pay');

}

function rftk_plus_npanon_payorderfor_payment_css_js()
{
    if (!is_admin()) {
        add_action('wp_enqueue_scripts', 'rftk_plus_npanon_payorderfor_payment_scripts', -10);
        add_action('wp_print_footer_scripts', 'rftk_plus_npanon_payorderfor_payment_scripts', -10);
        add_action('wp_add_inline_script', 'rftk_plus_npanon_payorderfor_payment_scripts', -10);

    }
}

function rftk_plus_npanon_payorderfor_payment_scripts()
{

    if (!is_admin()) {


        $url_css = gpls_woo_rfq_plus_URL . 'assets/css/rfqtk_anonpay.css';
        $url_css_path = gpls_woo_rfq_plus_DIR . 'assets/css/rfqtk_anonpay.css';
        wp_enqueue_style('npanon_payordercss', $url_css, array(), filemtime($url_css_path));

        $list = 'enqueued';


        $url_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk_anonpay.js';
        $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk_anonpay.js';
        wp_enqueue_script('npanon_payorderjs', $url_js, array('jquery'), filemtime($url_js_path), true);

        if (!is_admin()) {

            $custom_js = "";

            $custom_js = "jQuery(document ).ready( function() { jQuery( '.woocommerce-info' ).hide();
            jQuery( '.woocommerce-SavedPaymentMethods-saveNew' ).hide();
            jQuery( '#wc-stripe-payment-token-new').click();} );
            jQuery( '.woocommerce-SavedPaymentMethods' ).hide();
            ";

//$("input[name=background][value='some value']").prop("checked",true)
            wp_add_inline_script('npanon_payorderjs', $custom_js);

            $custom_css = "";

            $custom_css = ".woocommerce-SavedPaymentMethods, .woocommerce-info,.woocommerce-SavedPaymentMethods-saveNew {display:none !important;}";

            wp_add_inline_style('npanon_payordercss', $custom_css);

            echo '<script>'.$custom_css.'</script>';
            echo '<style>'.$custom_js.'</style>';



        }

    }

    if(!function_exists('remove_filters_with_method_name')) {
        function remove_filters_with_method_name($hook_name = '', $method_name = '', $priority = 0)
        {
            global $wp_filter;
            // Take only filters on right hook name and priority
            if (!isset($wp_filter[$hook_name][$priority]) || !is_array($wp_filter[$hook_name][$priority])) {
                return false;
            }
            // Loop on filters registered
            foreach ((array)$wp_filter[$hook_name][$priority] as $unique_id => $filter_array) {
                // Test if filter is an array ! (always for class/method)
                if (isset($filter_array['function']) && is_array($filter_array['function'])) {
                    // Test if object is a class and method is equal to param !
                    if (is_object($filter_array['function'][0]) && get_class($filter_array['function'][0]) && $filter_array['function'][1] == $method_name) {
                        // Test for WordPress >= 4.7 WP_Hook class (https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/)
                        if (is_a($wp_filter[$hook_name], 'WP_Hook')) {
                            unset($wp_filter[$hook_name]->callbacks[$priority][$unique_id]);
                        } else {
                            unset($wp_filter[$hook_name][$priority][$unique_id]);
                        }
                    }
                }
            }
            return false;
        }
    }


    if(!function_exists('remove_filters_for_anonymous_class')) {
        function remove_filters_for_anonymous_class($hook_name = '', $class_name = '', $method_name = '', $priority = 0)
        {
            global $wp_filter;
            // Take only filters on right hook name and priority
            if (!isset($wp_filter[$hook_name][$priority]) || !is_array($wp_filter[$hook_name][$priority])) {
                return false;
            }
            // Loop on filters registered
            foreach ((array)$wp_filter[$hook_name][$priority] as $unique_id => $filter_array) {
                // Test if filter is an array ! (always for class/method)
                if (isset($filter_array['function']) && is_array($filter_array['function'])) {
                    // Test if object is a class, class and method is equal to param !
                    if (is_object($filter_array['function'][0]) && get_class($filter_array['function'][0]) && get_class($filter_array['function'][0]) == $class_name && $filter_array['function'][1] == $method_name) {
                        // Test for WordPress >= 4.7 WP_Hook class (https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/)
                        if (is_a($wp_filter[$hook_name], 'WP_Hook')) {
                            unset($wp_filter[$hook_name]->callbacks[$priority][$unique_id]);
                        } else {
                            unset($wp_filter[$hook_name][$priority][$unique_id]);
                        }
                    }
                }
            }
            return false;
        }
    }


}


if (!function_exists('gpls_woo_rfq_get_mode')) {
    function gpls_woo_rfq_get_mode(&$rfq_check, &$normal_check)
    {
        $rfq_check = false;
        $normal_check = false;

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {
            add_filter('woocommerce_cart_needs_payment', 'gpls_woo_rfq_cart_needs_payment', 1000, 2);
            $rfq_check = true;
            $normal_check = false;
        }

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "normal_checkout") {
            $rfq_check = false;
            $normal_check = true;
        }

        if(function_exists('wp_get_current_user')) {
            if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
                $rfq_check = true;
                $normal_check = false;

            }
        }

    }
}

if (!function_exists('gpls_woo_wc_price')) {
    function gpls_woo_wc_price($return, $price, $args)
    {
        if ($GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq") {

            if (trim($price) === '') {
                return ' ';
            }
        }

    }
}

if (!function_exists('gpls_woo_rfq_woocommerce_empty_price_html')) {
    function gpls_woo_rfq_woocommerce_empty_price_html($html, $product=null)
    {
        if (isset($product) && is_object($product)) {

            if ($GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq") {


                $data = $product->get_data();

                $this_price = $data["price"];

                if (trim($data["sale_price"]) != '') {
                    $this_price = $data["sale_price"];
                }
                if (trim($this_price) === '') {

                    return ' ';
                }
            }
        }
        return $html;
    }
}


if(!function_exists('gpls_woo_rfq_plus_startsWith')) {
    function gpls_woo_rfq_plus_startsWith($haystack, $needle)
    {
        $length = strlen($needle);
        return (substr($haystack, 0, $length) === $needle);
    }
}

if(!function_exists('gpls_woo_rfq_plus_endsWith')) {
    function gpls_woo_rfq_plus_endsWith($haystack, $needle)
    {
        $length = strlen($needle);
        if ($length == 0) {
            return true;
        }

        return (substr($haystack, -$length) === $needle);
    }
}

if (!function_exists('gpls_empty')) {
    function gpls_empty($var)
    {
        if(!isset($var) || $var == false){
            return true;
        }else{
            return false;
        }

    }
}

if (!function_exists('write_log')) {
    function write_log($log)
    {

        if (is_array($log) || is_object($log)) {
            error_log(print_r($log, true));
        } else {
            error_log($log);
        }
    }
}


if(!function_exists('gpls_woo_rfq_add_notice')) {
    function gpls_woo_rfq_add_notice($message, $type = 'info')
    {
        //$all_notices  = array();
        $notice = array('message' => $message, 'type' => $type, 'expired' => false);
        // set_transient('gpls_woo_rfq_cart_notices', $notice, 5);
        $gpls_woo_rfq_cart_notices = gpls_woo_rfq_get_item('gpls_woo_rfq_cart_notices');

        if(is_array($gpls_woo_rfq_cart_notices)){
            array_push($gpls_woo_rfq_cart_notices,$gpls_woo_rfq_cart_notices);
        }

        gpls_woo_rfq_cart_set('gpls_woo_rfq_cart_notices',$notice);

    }
}

if(!function_exists('gpls_woo_rfq_print_notices')) {
    function gpls_woo_rfq_print_notices()
    {

        $notice = gpls_woo_rfq_get_item('gpls_woo_rfq_cart_notices');

        // $notice = get_transient('gpls_woo_rfq_cart_notices');

//d($all_notices);
        if (isset($notice['type']) && trim($notice['message']) != "") {
            ?>

            <?php if ($notice['type'] == 'error') : ?>
                <div class="woocommerce-error">
                    <?php echo trim(wp_kses_post($notice['message'])); ?>
                </div>
            <?php endif; ?>
            <?php if ($notice['type'] == 'info') : ?>
                <div class="woocommerce-info">
                    <?php echo trim(wp_kses_post($notice['message'])); ?>
                </div>
            <?php endif; ?>
            <?php if ($notice['type'] == 'notice') : ?>
                <div class="woocommerce-notice">
                    <?php echo trim(wp_kses_post($notice['message'])); ?>
                </div>
            <?php endif; ?>


            <?php
        }

        gpls_woo_rfq_cart_delete('gpls_woo_rfq_cart_notices');

        // d($all_notices);
    }
}


function ip_based_options()
{


    add_filter("pre_option_settings_gpls_woo_rfq_show_prices", 'gpls_woo_rfq_plus_ip_yes_option', 10000);
    add_filter("pre_option_settings_gpls_woo_rfq_normal_checkout_show_prices", 'gpls_woo_rfq_plus_ip_yes_option', 10000);
    add_filter("pre_option_settings_gpls_woo_rfq_plus_normal_checkout", 'gpls_woo_rfq_plus_ip_yes_option', 10000);


    add_filter("pre_option_settings_gpls_woo_rfq_hide_visitor_prices", 'gpls_woo_rfq_plus_ip_no_option', 10000);
    add_filter("pre_option_settings_gpls_woo_rfq_plus_role_based_visible", 'gpls_woo_rfq_plus_ip_no_option', 10000);
    add_filter("pre_option_settings_gpls_woo_rfq_limit_to_rfq_only", 'gpls_woo_rfq_plus_ip_no_option', 10000);
    add_filter("pre_option_settings_gpls_woo_rfq_global_no_add_to_cart", 'gpls_woo_rfq_plus_ip_no_option', 10000);


}

function gpls_woo_rfq_plus_ip_checkout_option($option)
{
    return get_option("sales_staff_checkout_option","rfq");
}


//settings_gpls_woo_rfq_global_no_add_to_cart

function gpls_woo_rfq_plus_ip_yes_option($option)
{
    return "yes";
}

function gpls_woo_rfq_plus_ip_no_option($option)
{
    return "no";
}

/*
 * Copyright 2008: Paul Gregg <pgregg@pgregg.com>
 * 10 January 2008
 * Version: 1.2
 * Source website: http://www.pgregg.com/projects/php/ip_in_range/
 */


Function gpls_woo_rfq_plus_ip_in_range($ip, $range) {

    if($ip == $range){
        return true;
    }

    if (strpos($range, '/') !== false) {
        // $range is in IP/NETMASK format
        list($range, $netmask) = explode('/', $range, 2);
        if (strpos($netmask, '.') !== false) {
            // $netmask is a 255.255.0.0 format
            $netmask = str_replace('*', '0', $netmask);
            $netmask_dec = ip2long($netmask);
            return ( (ip2long($ip) & $netmask_dec) == (ip2long($range) & $netmask_dec) );
        } else {
            // $netmask is a CIDR size block
            // fix the range argument
            $x = explode('.', $range);
            while(count($x)<4) $x[] = '0';
            list($a,$b,$c,$d) = $x;
            $range = sprintf("%u.%u.%u.%u", empty($a)?'0':$a, empty($b)?'0':$b,empty($c)?'0':$c,empty($d)?'0':$d);
            $range_dec = ip2long($range);
            $ip_dec = ip2long($ip);

            # Strategy 1 - Create the netmask with 'netmask' 1s and then fill it to 32 with 0s
            #$netmask_dec = bindec(str_pad('', $netmask, '1') . str_pad('', 32-$netmask, '0'));

            # Strategy 2 - Use math to create it
            $wildcard_dec = pow(2, (32-$netmask)) - 1;
            $netmask_dec = ~ $wildcard_dec;

            return (($ip_dec & $netmask_dec) == ($range_dec & $netmask_dec));
        }
    } else {
        // range might be 255.255.*.* or 1.2.3.0-1.2.3.255
        if (strpos($range, '*') !==false) { // a.b.*.* format
            // Just convert to A-B format by setting * to 0 for A and 255 for B
            $lower = str_replace('*', '0', $range);
            $upper = str_replace('*', '255', $range);
            $range = "$lower-$upper";
        }

        if (strpos($range, '-')!==false) { // A-B format
            list($lower, $upper) = explode('-', $range, 2);
            $lower_dec = (float)sprintf("%u",ip2long($lower));
            $upper_dec = (float)sprintf("%u",ip2long($upper));
            $ip_dec = (float)sprintf("%u",ip2long($ip));
            return ( ($ip_dec>=$lower_dec) && ($ip_dec<=$upper_dec) );
        }

        // echo 'Range argument is not in 1.2.3.4/24 or 1.2.3.4/255.255.255.0 format';
        return false;
    }

}




function gpls_woo_rfq_plus_check_staff_mode(){

$ip_enabled = get_option('settings_gpls_woo_rfq_allow_sales_staff_ip_filter', "no");

    $staff="no";

if($ip_enabled=="yes") {

    $ip_list_array = trim(strtolower(get_option('settings_gpls_woo_sales_staff_ips', "")));

    $ip_list_array = explode(',', $ip_list_array);

    if (is_array($ip_list_array)) {
        $ip_list_array = array_map('trim', $ip_list_array);
        $ip_list_array = array_map('strtolower', $ip_list_array);
    } else {
        $ip_list_array = array("");
    }


    foreach ($ip_list_array as $ip_range) {
        if (gpls_woo_rfq_plus_ip_in_range($_SERVER['REMOTE_ADDR'], $ip_range)) {
            ip_based_options();
            $staff="yes";
            break;
        }
    }

}
    return $staff;
}





add_filter('gpls_woo_rfq_skip_ajax_add_to_quote','gpls_woo_rfq_redirect_add_to_quote' ,10,1);

function gpls_woo_rfq_redirect_add_to_quote($return)
{
    $redirect = get_option('rfq_cart_sc_redirect_to_single', 'no');

    return $redirect;
}


add_filter('woocommerce_add_to_cart_validation', 'gpls_woo_rfqtk_validate_add_item_validation', 1000, 5);

function gpls_woo_rfqtk_validate_add_item_validation($passed, $product_id, $quantity, $variation_id = '', $variations = '')
{


    if (isset($_REQUEST['rfq_product_formvalue'])) {
        return $passed;
    }

    if (isset($_REQUEST['rfq_files'])) {
        return $passed;
    }

    if (isset($_REQUEST['single'])) {
        //  return $passed;

    }
    if (isset($_REQUEST['add-to-cart']) && !isset($_GET['add-to-cart'])) {
        return $passed;

    }

    $redirect = get_option('rfq_cart_sc_redirect_to_single', 'no');

    if ($redirect == "yes") {

        if (isset($_REQUEST['rfq_id'])) {
            wp_redirect(get_permalink($product_id));
            exit;
        }

        if (isset($_GET['wc-ajax']) && $_GET['wc-ajax'] == "add_to_cart") {
            return false;
        }

    }

    return $passed;

}


