<?php
/**
 * Customer note email
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/customer-note.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @author        WooThemes
 * @package    WooCommerce/Templates/Emails
 * @version     2.5.0
 */

if (!defined('ABSPATH')) {
    exit;
}

$show_prices = true;

add_filter('woocommerce_email_order_items_args', 'filter_gpls_woo_rfq_add_show_prices_to_wc_emails', 100, 1);

gpls_woo_rfq_remove_filters_normal_checkout();

$customer_offer = get_post_meta($order->get_id(), '_woo_rfq_customer_bid', true);

/**
 * @hooked WC_Emails::email_header() Output the email header
 */

do_action('woocommerce_email_header', $email_heading, $email);



?>

<?php do_action('woocommerce_email_before_order_table', $order, $sent_to_admin, $plain_text); ?>

    <p>
    <h2><a class="link"
           href="<?php echo admin_url('post.php?post=' . $order->get_id() . '&action=edit'); ?>"><?php printf(__('Order #%s', 'rfqtk'), $order->get_order_number()); ?></a>
        (<?php printf('<time datetime="%s">%s</time>', date_i18n('c', strtotime($order->get_date_created())), date_i18n(wc_date_format(), strtotime($order->get_date_created()))); ?>
        )</h2>
<?php printf(__("A note has just been added to order: #" . $order->get_order_number(), 'rfqtk')); ?></p>
<?php printf('By %s :', $order->get_billing_first_name() . ' ' . $order->get_billing_last_name() . ' ' . $order->get_billing_email()); ?></h2>

    <

    <blockquote><h2><?php echo wptexturize($customer_note) ?></h2></blockquote>

<?php do_action('gpls_woo_add_rfq_after_customer_note', $order, $sent_to_admin, $plain_text); ?>


    <table class="td" cellspacing="0" cellpadding="6"
           style="width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;" border="1">
        <thead>
        <tr>
            <th class="td" scope="col" style="text-align:left;"><?php _e('Product', 'rfqtk'); ?></th>
            <th class="td" scope="col" style="text-align:left;"><?php _e('Quantity', 'rfqtk'); ?></th>
            <th class="td" scope="col" style="text-align:left;"><?php _e('Price', 'rfqtk'); ?></th>


        </tr>
        </thead>
        <tbody>
        <?php

        $show_prices = false;
        echo wc_get_email_order_items($order, array(
            'show_sku' => true,
            'show_image' => true,
            'image_size' => array(128, 128),
            'plain_text' => $plain_text,
            'show_prices' => $show_prices,
            'sent_to_admin' => true

        )); ?>

        </tbody>
        <tfoot>
        <?php

        if ($totals = $order->get_order_item_totals()) {
            $i = 0;
            foreach ($totals as $total) {
                $i++;
                ?>
                <tr>
                <th class="td" scope="row" colspan="2"
                    style="text-align:left; <?php if ($i == 1) echo 'border-top-width: 4px;'; ?>"><?php echo $total['label']; ?></th>
                <td class="td"
                    style="text-align:left; <?php if ($i == 1) echo 'border-top-width: 4px;'; ?>"><?php echo $total['value']; ?></td>
                </tr><?php
            }
        }

        ?>
        </tfoot>
    </table>

<?php


?>
<?php

/**
 * @hooked WC_Emails::order_details() Shows the order details table.
 * @hooked WC_Emails::order_schema_markup() Adds Schema.org markup.
 * @since 2.5.0
 */


/**
 * @hooked WC_Emails::order_meta() Shows order meta data.
 */
do_action('woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email);

/**
 * @hooked WC_Emails::customer_details() Shows customer details
 * @hooked WC_Emails::email_address() Shows email address
 */
do_action('woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email);

/**
 * @hooked WC_Emails::email_footer() Output the email footer
 */
do_action('woocommerce_email_footer', $email);
