<?php
/**
 * WOO-RFQ-List
 *
 * @author  Neah Plugins
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;

}
global $woocommerce;

global $wp;
$order_id = $wp->query_vars['order-pay'];
if ($order_id == false) return;
$order = wc_get_order($order_id);


?>
    <table>
        <?php

        $require_address = get_option('settings_gpls_woo_rfq_address_at_pay_order', "no");
        $require_phone = get_option('settings_gpls_woo_rfq_phone_at_pay_order', "no");
        $auth = true;

        /*$only_anon_at_pay = get_option('settings_gpls_woo_rfq_only_anon_at_pay_order', "no");
        $auth = true;

        if($only_anon_at_pay == "yes" && !is_user_logged_in()){
            $auth=false;
        }*/

        $address_billing = array(
            'company' => sanitize_text_field($order->get_billing_company()),
            'phone' => sanitize_text_field($order->get_billing_phone()),
            'address_1' => sanitize_text_field($order->get_billing_address_1()),
            'address_2' => sanitize_text_field($order->get_billing_address_2()),
            'city' => sanitize_text_field($order->get_billing_city()),
            'state' => sanitize_text_field($order->get_billing_state()),
            'postcode' => sanitize_text_field($order->get_billing_postcode()),
            'country' => sanitize_text_field($order->get_billing_country())
        );

        if ( $require_address == "yes" && $auth == true) {

            ?>
            <input type="hidden" name="gpls_address_at_payorder" id="gpls_address_at_payorder">
            <tr>
                <td colspan="2" style="padding:10px"><strong><?php _e('Confirm Address', 'rfqtk'); ?></strong></td>
            </tr>

            <tr class="">
                <td colspan="2" class="company "><?php printf(__('Company', 'rfqtk')); ?> <abbr
                            id="rfq_company_label"></abbr></td>

            </tr>
            <tr class="">
                <td colspan="2" class="company ">
                    <input style="  " type="text" id="rfq_company" name="rfq_company" placeholder=""
                           class="rfq_cart_address" value="<?php echo $address_billing['company'] ?>"
                    />
                </td>

            </tr>

            <tr >
                <td colspan="2" class="country "
                    style="padding-top:10px"><?php echo(__('Country', 'rfqtk')); ?><span
                            class="required">*</span></td>
            </tr>

            <tr >
                <td colspan="2" style="padding:15px;" class="rfq_state_select ">
                    <?php
                    $countries = new WC_Countries();
                    $allowed_countries = $countries->get_allowed_countries();
                    //$allowed_countries = $countries->get_countries();
                    ?>
                    <select name="rfq_billing_country" id="rfq_billing_country" required="required"
                            class="rfq_billing_country" style=""
                            data-msg="<?php echo(__('Required', 'rfqtk')); ?>">
                        <option value="">Select a country&hellip;</option>

                        <?php
                        foreach ($allowed_countries as $key => $value) { ?>
                            <option value="<?php echo $key; ?>"><?php echo $value; ?></option>
                            <?php
                        }
                        ?>

                    </select>

                </td>

            </tr>

            <tr >

                <td class="" style=""><?php echo __('State', 'rfqtk'); ?><span class="required">*</span>
                </td>


            </tr>

            <tr >

                <td colspan="2" style="padding:15px;" class="">
                    <select name="rfq_state_select" id="rfq_state_select" style="" required="required"
                            class="rfq_state_select" placeholder="<?php echo(__('State/County', 'rfqtk')) ?>"
                            style="vertical-align: top">
                        <option value="">Select an option…</option>
                        <option value="AL">Alabama</option>
                        <option value="AK">Alaska</option>
                        <option value="AZ">Arizona</option>
                        <option value="AR">Arkansas</option>
                        <option value="CA">California</option>
                        <option value="CO">Colorado</option>
                        <option value="CT">Connecticut</option>
                        <option value="DE">Delaware</option>
                        <option value="DC">District Of Columbia</option>
                        <option value="FL">Florida</option>
                        <option value="GA">Georgia</option>
                        <option value="HI">Hawaii</option>
                        <option value="ID">Idaho</option>
                        <option value="IL">Illinois</option>
                        <option value="IN">Indiana</option>
                        <option value="IA">Iowa</option>
                        <option value="KS">Kansas</option>
                        <option value="KY">Kentucky</option>
                        <option value="LA">Louisiana</option>
                        <option value="ME">Maine</option>
                        <option value="MD">Maryland</option>
                        <option value="MA">Massachusetts</option>
                        <option value="MI">Michigan</option>
                        <option value="MN">Minnesota</option>
                        <option value="MS">Mississippi</option>
                        <option value="MO">Missouri</option>
                        <option value="MT">Montana</option>
                        <option value="NE">Nebraska</option>
                        <option value="NV">Nevada</option>
                        <option value="NH">New Hampshire</option>
                        <option value="NJ">New Jersey</option>
                        <option value="NM">New Mexico</option>
                        <option value="NY">New York</option>
                        <option value="NC">North Carolina</option>
                        <option value="ND">North Dakota</option>
                        <option value="OH">Ohio</option>
                        <option value="OK">Oklahoma</option>
                        <option value="OR">Oregon</option>
                        <option value="PA">Pennsylvania</option>
                        <option value="RI">Rhode Island</option>
                        <option value="SC">South Carolina</option>
                        <option value="SD">South Dakota</option>
                        <option value="TN">Tennessee</option>
                        <option value="TX">Texas</option>
                        <option value="UT">Utah</option>
                        <option value="VT">Vermont</option>
                        <option value="VA">Virginia</option>
                        <option value="WA">Washington</option>
                        <option value="WV">West Virginia</option>
                        <option value="WI">Wisconsin</option>
                        <option value="WY">Wyoming</option>
                        <option value="AA">Armed Forces (AA)</option>
                        <option value="AE">Armed Forces (AE)</option>
                        <option value="AP">Armed Forces (AP)</option>
                        <option value="AS">American Samoa</option>
                        <option value="GU">Guam</option>
                        <option value="MP">Northern Mariana Islands</option>
                        <option value="PR">Puerto Rico</option>
                        <option value="UM">US Minor Outlying Islands</option>
                        <option value="VI">US Virgin Islands</option>
                    </select>
                    <input style="  " class="form-control" name="rfq_state_text" id="rfq_state_text" type="text"
                           required="required"
                           placeholder="<?php echo(__('State/County', 'rfqtk')); ?>"/>
                </td>

            </tr>


            <tr >
                <td colspan="2" ><?php echo(__('Address', 'rfqtk')); ?><span
                            class="required">*</span>
                </td>

            </tr>
            <tr >
                <td colspan="2" >
                    <input style="  " type="text" id="rfq_address" name="rfq_address" placeholder=""
                           required="required" value="<?php echo $address_billing['address_1'] ?>"
                           class="rfq_cart_address"/>
                </td>

            </tr>

            <tr >
                <td colspan="2" class="address  "
                    required="required"><?php echo(__('Address 2', 'rfqtk')); ?></td>

            </tr>
            <tr >
                <td colspan="2" >
                    <input style="  " type="text" id="rfq_address2" name="rfq_address2"
                           placeholder="Apartment, suite, etc." value="<?php echo $address_billing['address_2'] ?>"
                           class="rfq_cart_address"/>
                </td>

            </tr>


            <tr >

                <td class=""><?php echo(__('City', 'rfqtk')); ?><span class="required">*</span></td>

            </tr>


            <tr >

                <td ><input style="  " class="form-control" type="text" id="rfq_city"
                            name="rfq_city"
                            required="required" value="<?php echo $address_billing['city'] ?>"
                            placeholder=""/></td>
            </tr>
            <tr >

                <td class=""><?php echo(__('Zip', 'rfqtk')); ?><span class="required">*</span></td>

            </tr>
            <tr >
                <td class="">
                    <input style="  " class="form-control" name="rfq_zip" id="rfq_zip" type="text"
                           placeholder=""
                           required="required" value="<?php echo $address_billing['postcode'] ?>"
                    />
                </td>
            </tr>
            <?php

            if ($require_phone == "yes" ) {
                ?>
                <tr class="">
                    <td class=""><?php printf(__('Phone', 'rfqtk')); ?> <span class="required">*</span>
                    </td>


                </tr>
                <tr >
                    <td class=""><input style="" id="rfq_phone" name="rfq_phone" required="required"
                                        value="<?php echo $address_billing['phone'] ?>"           placeholder="" type="text"/></td>

                </tr>
                <?php
            }

        }

        ?>
    </table>

<?php
$script = "<script type='application/javascript'>

            jQuery('#rfq_billing_country').val('".$address_billing['country']."');
            jQuery('#rfq_state_select').val('".$address_billing['state']."');   
            jQuery('#rfq_state_text').val('".$address_billing['state']."');   
            
             if (jQuery('#rfq_billing_country').val() != 'US') {
            jQuery('#rfq_state_select').val(\"\");
            jQuery('#rfq_state_select').hide();
            jQuery('#rfq_state_text').show();
            jQuery('#rfq_state_select').attr(\"required\", false);
            jQuery('#rfq_state_text').attr(\"required\", true);
        } else {
            jQuery('#rfq_state_text').val(\"\");
            jQuery('#rfq_state_text').hide();
            jQuery('#rfq_state_select').show();
            jQuery('#rfq_state_select').attr(\"required\", true);
            jQuery('#rfq_state_text').attr(\"required\", false);

        }
        
    jQuery('.rfq_billing_country').on('change', function(){

       if (jQuery('#rfq_billing_country').val() != 'US') {
            jQuery('#rfq_state_select').val(\"\");
            jQuery('#rfq_state_select').hide();
            jQuery('#rfq_state_text').show();
            jQuery('#rfq_state_select').attr(\"required\", false);
            jQuery('#rfq_state_text').attr(\"required\", true);
        } else {
            jQuery('#rfq_state_text').val(\"\");
            jQuery('#rfq_state_text').hide();
            jQuery('#rfq_state_select').show();
            jQuery('#rfq_state_select').attr(\"required\", true);
            jQuery('#rfq_state_text').attr(\"required\", false);

        }
    });
</script>";
echo $script;