<?php
/**
 * WOO-RFQ-List
 *
 * @author  Neah Plugins
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;

}
error_reporting(0);

?>

<div class="woocommerce gpls_woo_rfq_request_mini_page">
<?php do_action( 'woocommerce_before_rfq_mini_cart' ); ?>
<?php

//$gpls_woo_rfq_cart = get_transient(gpls_woo_rfq_cart_tran_key() . '_' . 'gpls_woo_rfq_cart');
$wp_session = RFQTK_WP_Session::get_instance();

$gpls_woo_rfq_cart = gpls_woo_rfq_get_item(gpls_woo_rfq_cart_tran_key() . '_' . 'gpls_woo_rfq_cart');

$nonce = wp_create_nonce('gpls_woo_rfq_handle_rfq_cart_nonce');
?>
<?php if ( $gpls_woo_rfq_cart ) : ?>

<?php


    ?>

    <div style="clear: both; "></div>

    <?php do_action( 'woocommerce_before_mini_cart' );?>

    <div class="cart_list product_list_widget <?php echo esc_attr( $args['list_class'] ); ?>">

        <?php if ( $gpls_woo_rfq_cart ) : ?>

            <?php do_action( 'woocommerce_before_rfq_mini_cart_contents' );?>

            <?php
            foreach ($gpls_woo_rfq_cart as $cart_item_key => $cart_item ) {
                $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

                if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
                    $product_name      = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );
                    $thumbnail         = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
                    $product_price     = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
                    $times='&times;';
                    if (get_option('settings_gpls_woo_rfq_normal_checkout_show_prices', 'no') == 'no') {
                        // echo 'individual_price_hidden $price = 0'.'<br />';
                        $product_price = ' ';
                        $times='';
                    }


                    $product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
                    ?>
                    <li class="<?php echo esc_attr( apply_filters( 'woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key ) ); ?>">
                        <?php
                        if (isset($cart_item['bundled_by']) && isset($cart_item['bundled_by'])) {
                            echo '';
                        } else {
                            $url = esc_url($wc_get_update_url) . "?remove_rfq_item=" . $cart_item_key;
                            echo apply_filters('woocommerce_cart_item_remove_link', sprintf(
                                '<a href="%s" type="submit" class="remove" title="%s" data-product_id="%s" data-product_sku="%s">'.$times.'</a>',
                                $url . '&man-deleted=' . $cart_item_key."&gpls_woo_rfq_nonce=".$nonce,
                                __('Remove this item', 'rfqtk'),
                                esc_attr($product_id),
                                esc_attr($_product->get_sku())
                            ), $cart_item_key);

                        }
                        ?>
                        <?php if ( ! $_product->is_visible() ) : ?>
                            <?php echo str_replace( array( 'http:', 'https:' ), '', $thumbnail ) . $product_name . '&nbsp;'; ?>
                        <?php else : ?>
                            <a href="<?php echo esc_url( $product_permalink ); ?>">
                                <?php echo str_replace( array( 'http:', 'https:' ), '', $thumbnail ) . $product_name . '&nbsp;'; ?>
                            </a>
                        <?php endif; ?>
                        <?php echo WC()->cart->get_item_data( $cart_item ); ?>

                        <?php echo apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf( '%s '.$times.' %s', $cart_item['quantity'], $product_price ) . '</span>', $cart_item, $cart_item_key ); ?>
                    </li>
                    <?php
                }
            }
            ?>

            <?php do_action( 'woocommerce_mini_cart_contents' ); ?>

        <?php else : ?>

            <li class="empty"><?php _e( 'No products in the cart.', 'rfqtk' ); ?></li>

        <?php endif; ?>

    </div>


    <?php
    $button_text = get_option('rfq_cart_wordings_submit_your_rfq_text', 'Submit Your Request For Quote');
    $button_text = __($button_text,'rfqtk');

    $link_to_rfq_page = pls_woo_rfq_get_link_to_rfq();

    $view_your_cart_text = get_option('rfq_cart_wordings_view_rfq_cart', __('View List', 'rfqtk'));
    $view_your_cart_text = __($view_your_cart_text,'rfqtk');

    ?>
<form   action="<?php echo $link_to_rfq_page; ?>" method="get" >
    <div class="rfq_proceed-to-checkout" style="float: none !important;margin-left: 30% !important; margin-right: auto !important;" >
        <input  name="gpls-woo-rfq_checkout_button"   type="submit" class="button alt gpls-woo-rfq_checkout_button"
                style="<?php echo $gpls_woo_rfq_styles['gpls_woo_rfq_page_submit_button_styles'] ?>
                        padding-top: .6180469716em  !important;padding-right: 1.41575em  !important;padding-bottom:.6180469716em  !important;padding-right: 1.41575em !important;" value="<?php echo $view_your_cart_text ?>"
                onmouseover="<?php echo $gpls_woo_rfq_styles['gpls_woo_rfq_page_submit_button_background_onmouseover'].';'.$gpls_woo_rfq_styles['gpls_woo_rfq_page_submit_button_onmouseover'] ?>"
                onmouseout="<?php echo $gpls_woo_rfq_styles['gpls_woo_rfq_page_submit_button_onmouseout'].';'.$gpls_woo_rfq_styles['gpls_woo_rfq_page_submit_button_background_onmouseout'] ?>"

        />

    </div>
</form>


<?php else : ?>

    <li class="empty"><?php _e( 'No products in the quote list.', 'rfqtk' ); ?></li>

<?php endif; ?>

<?php do_action( 'woocommerce_after_rfq_mini_cart' ); ?>
</div>
</div>