<?php
/**
 * Customer Notes
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/woo-rfq/myacct/cust-notes.php.
 * @author  Neah Plugins
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>

<?php
do_action('gpls_woo_rfq_before_customer_note_form');


$gpls_woo_rfq_upload_styles = array();

$gpls_woo_rfq_upload_styles = apply_filters('gpls_woo_rfq_customer_notes_styles', $gpls_woo_rfq_upload_styles);

$of = new WC_Order_Factory();
$order = $of::get_order($order_id);
$status = $order->get_status();
$order_total = $order->get_formatted_order_total();


$gpls_accepted_offer = get_post_meta($order_id, '_gpls_accepted_offer', true);

if ($gpls_accepted_offer == '') {
    $gpls_accepted_offer = false;
}

$gpls_accepted_offer_date = get_post_meta($order_id, '_gpls_accepted_offer_date', true);

if ($gpls_accepted_offer_date == '') {
    $gpls_accepted_offer_date = false;
}

$show_accept_offer = get_option('settings_gpls_woo_rfq_show_accept_offer');





?>
<div style="text-align: left;inline-block;">


    <div style="float:left;margin-top:20px;margin-bottom:20px; display:block; ">
        <form id="gpls_woo_rfq_Plus_customer_note_form" class="gpls_woo_rfq_Plus_customer_note_form"
              method="post" action="" enctype="multipart/form-data">

            <?php wp_nonce_field('gpls_woo_rfq_Plus_customer_note_form_nonce'); ?>

            <?php

            ?>


            <?php if ($show_accept_offer == 'yes'): ?>

                <?php if ($status == 'gplsquote-sent' && !$gpls_accepted_offer && $order->needs_payment()): ?>


                    <?php

                    if (get_option('settings_gpls_woo_rfq_allow_customer_offer', 'no') == 'yes') {
                        wc_get_template('woo-rfq/bid/bid-rfq.php');
                    }

                    ?>


                    <h2>
                        <input type="checkbox" name="accept_offer" class="accept_offer"
                               style="width:20px; height:20px;"/>&nbsp;<?php echo __('Check here to accept the quoted price', 'rfqtk') ?>
                    </h2>


                <?php endif; ?>

                <?php if ($gpls_accepted_offer && $order->needs_payment()): ?>

                    <h3>
                        <?php
                        echo __('Quote accepted on ', 'rfqtk') . date_i18n(get_option('date_format'), $gpls_accepted_offer_date) . '.</br>';
                        printf(__('You can pay by using the following link: %s', 'rfqtk'), '<a href="' . esc_url($order->get_checkout_payment_url()) . '">' . __('pay', 'rfqtk') . '</a>');

                        ?>
                    </h3>


                <?php endif; ?>

            <?php else: ?>

                <?php if ($status == 'gplsquote-sent' && $order->needs_payment()): ?>
                    <h2><?php echo __('Total: ', 'rfqtk') . $order_total; ?></h2>

                    <h2>
                        <?php

                        printf(__('You can pay by using the following link: %s', 'rfqtk'), '<a href="' . esc_url($order->get_checkout_payment_url()) . '"><strong>' . __('pay', 'rfqtk') . '</strong></a>');

                        ?>
                    </h2>

                <?php endif; ?>

            <?php endif; ?>

            <?php

            $customer_note_text = get_option('settings_gpls_woo_rfq_customer_note_text', __('Add Note', 'rfqtk'));
            $customer_note_text = __($customer_note_text, 'rfqtk');

            ?>
            <?php
            $settings_gpls_woo_rfq_customer_note_desc = get_option('settings_gpls_woo_rfq_customer_note_desc', __('You can send us a message regarding your order/request for quote.', 'rfqtk'));
            $settings_gpls_woo_rfq_customer_note_desc = __($settings_gpls_woo_rfq_customer_note_desc, 'rfqtk');
            ?>
            <br/>
            <label><strong><?php echo $settings_gpls_woo_rfq_customer_note_desc; ?></strong></label>


            <textarea id="gpls_woo_rfq_customer_note"  name="gpls_woo_rfq_customer_note"
                      rows="2" cols="60" style="width:100%; display: block; margin-bottom: 10px"></textarea>

            <input type="hidden" name="order_id" value="<?php echo $order_id ?>"/>&nbsp;&nbsp;&nbsp;&nbsp;
            <div style="text-align:center ">
                <input type="submit" id="gpls_woo_rfq_customer_note_submit"
                       name="gpls_woo_rfq_customer_note_submit"
                       value="<?php echo $customer_note_text ?>"
                       style="<?php echo $gpls_woo_rfq_upload_styles['gpls_woo_rfq_page_button_styles'] ?>;"
                       onmouseover="<?php echo $gpls_woo_rfq_upload_styles['gpls_woo_rfq_page_button_onmouseover'] . ';' . $gpls_woo_rfq_upload_styles['gpls_woo_rfq_page_button_background_onmouseover'] ?>"
                       onmouseout="<?php echo $gpls_woo_rfq_upload_styles['gpls_woo_rfq_page_button_onmouseout'] . ';' . $gpls_woo_rfq_upload_styles['gpls_woo_rfq_page_button_background_onmouseout'] ?>"

                >
            </div>


        </form>
    </div>
    <div style="clear: both; margin-top:20px;margin-bottom:20px; display:block;"><p/></div>

    <?php
    do_action('gpls_woo_rfq_after_customer_note_form');
    ?>


</div>