<?php
/**
 * Functions used by plugins
 */




add_filter('woocommerce_valid_order_statuses_for_payment_complete','rfqtk_statuses_for_payment',100,2);
add_filter('woocommerce_valid_order_statuses_for_payment','rfqtk_statuses_for_payment',100,2);
//apply_filters( 'woocommerce_data_get_stock_quantity', $value, 'WC_Data' );




if (!function_exists('rfqtk_first_main')) {

    function rfqtk_first_main()
    {
        if (isset($_REQUEST['pay_for_order']) && strpos($_REQUEST['key'], 'wc_order_', 0) === 0) {

            $GLOBALS["gpls_woo_rfq_show_prices"] = "yes";
            $GLOBALS["hide_for_visitor"] = "no";

            return true;
        }


    }
}



if (!function_exists('rfqtk_statuses_for_payment')) {

    function rfqtk_statuses_for_payment($array, $order)
    {

        array_push($array, 'gplsquote-sent');
        array_push($array, 'wc-gplsquote-sent');
        return $array;
    }
}


if (!function_exists('gpls_woo_rfq_get_mode')) {
    function gpls_woo_rfq_get_mode(&$rfq_check, &$normal_check)
    {
        $rfq_check = false;
        $normal_check = false;

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {
            add_filter('woocommerce_cart_needs_payment', 'gpls_woo_rfq_cart_needs_payment', 1000, 2);
            $rfq_check = true;
            $normal_check = false;
        }

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "normal_checkout") {
            $rfq_check = false;
            $normal_check = true;
        }

        if(function_exists('wp_get_current_user')) {
            if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
                $rfq_check = true;
                $normal_check = false;

            }
        }

    }
}

if (!function_exists('gpls_woo_wc_price')) {
        function gpls_woo_wc_price($return, $price, $args)
        {
            if ($GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq") {

                if (trim($price) === '') {
                    return ' ';
                }
            }

        }
    }

if (!function_exists('gpls_woo_rfq_woocommerce_empty_price_html')) {
        function gpls_woo_rfq_woocommerce_empty_price_html($html, $product=null)
        {
            if (isset($product) && is_object($product)) {

                if ($GLOBALS["gpls_woo_rfq_checkout_option"] == "rfq") {


                    $data = $product->get_data();

                    $this_price = $data["price"];

                    if (trim($data["sale_price"]) != '') {
                        $this_price = $data["sale_price"];
                    }
                    if (trim($this_price) === '') {

                        return ' ';
                    }
                }
            }
            return $html;
        }
    }


if(!function_exists('gpls_woo_rfq_plus_startsWith')) {
    function gpls_woo_rfq_plus_startsWith($haystack, $needle)
    {
        $length = strlen($needle);
        return (substr($haystack, 0, $length) === $needle);
    }
}

if(!function_exists('gpls_woo_rfq_plus_endsWith')) {
    function gpls_woo_rfq_plus_endsWith($haystack, $needle)
    {
        $length = strlen($needle);
        if ($length == 0) {
            return true;
        }

        return (substr($haystack, -$length) === $needle);
    }
}

if (!function_exists('gpls_empty')) {
    function gpls_empty($var)
    {
        if(!isset($var) || $var == false){
            return true;
        }else{
            return false;
        }

    }
}

if(!function_exists('gpls_woo_rfq_add_notice')) {
    function gpls_woo_rfq_add_notice($message, $type = 'info')
    {
        //$all_notices  = array();
        $notice = array('message' => $message, 'type' => $type, 'expired' => false);
       // set_transient('gpls_woo_rfq_cart_notices', $notice, 5);
        $gpls_woo_rfq_cart_notices = gpls_woo_rfq_get_item('gpls_woo_rfq_cart_notices');

        if(is_array($gpls_woo_rfq_cart_notices)){
            array_push($gpls_woo_rfq_cart_notices,$gpls_woo_rfq_cart_notices);
        }

        gpls_woo_rfq_cart_set('gpls_woo_rfq_cart_notices',$notice);

    }
}

if(!function_exists('gpls_woo_rfq_print_notices')) {
    function gpls_woo_rfq_print_notices()
    {

        $notice = gpls_woo_rfq_get_item('gpls_woo_rfq_cart_notices');

       // $notice = get_transient('gpls_woo_rfq_cart_notices');

//d($all_notices);
        if (isset($notice['type']) && trim($notice['message']) != "") {
            ?>

            <?php if ($notice['type'] == 'error') : ?>
                <div class="woocommerce-error">
                    <?php echo trim(wp_kses_post($notice['message'])); ?>
                </div>
            <?php endif; ?>
            <?php if ($notice['type'] == 'info') : ?>
                <div class="woocommerce-info">
                    <?php echo trim(wp_kses_post($notice['message'])); ?>
                </div>
            <?php endif; ?>
            <?php if ($notice['type'] == 'notice') : ?>
                <div class="woocommerce-notice">
                    <?php echo trim(wp_kses_post($notice['message'])); ?>
                </div>
            <?php endif; ?>


            <?php

        }
        gpls_woo_rfq_cart_delete('gpls_woo_rfq_cart_notices');

    }
}

if(!function_exists('rfq_cart_get_item_data')) {
    function rfq_cart_get_item_data($cart_item, $flat = false)
    {
        $item_data = array();

        // Variation data
        if (isset($cart_item['data']->variation_id) && is_array($cart_item['variation'])) {

            foreach ($cart_item['variation'] as $name => $value) {

                if ('' === $value)
                    continue;

                $taxonomy = wc_attribute_taxonomy_name(str_replace('attribute_pa_', '', urldecode($name)));

                // If this is a term slug, get the term's nice name
                if (taxonomy_exists($taxonomy)) {
                    $term = get_term_by('slug', $value, $taxonomy);
                    if (!is_wp_error($term) && $term && $term->name) {
                        $value = $term->name;
                    }
                    $label = wc_attribute_label($taxonomy);

                    // If this is a custom option slug, get the options name
                } else {
                    $value = apply_filters('woocommerce_variation_option_name', $value);
                    $label = wc_attribute_label(str_replace('attribute_', '', $name), $cart_item['data']);
                }

                $item_data[] = array(
                    'key' => $label,
                    'value' => $value
                );
            }
        }

        // Filter item data to allow 3rd parties to add more to the array
        $item_data = apply_filters('woocommerce_get_item_data', $item_data, $cart_item);



        // Format item data ready to display
        foreach ($item_data as $key => $data) {
                // Set hidden to true to not display meta on cart.
                if (isset($data['hidden'])) {
                    unset($item_data[$key]);
                    continue;
                }

                $item_data[$key]['key'] = isset($data['key']) && $data['key'] !=""  ? $data['key'] : $data['name'];
                $item_data[$key]['display'] = isset($data['display']) && $data['display'] !="" ? $data['display'] : $data['value'];
        }

        // Output flat or in list format
        if (sizeof($item_data) > 0) {
            //ob_start();

            if ($flat) {
                foreach ($item_data as $data) {

                    echo esc_html($data['key']) . ': ' . wp_kses_post($data['display'])   . "\n";
                }
            } else {
                wc_get_template('cart/cart-item-data.php', array('item_data' => $item_data));

                return;
            }

            //return ob_get_clean();
        }

        return '';




    }
}