<?php


$cookie_append=get_option('settings_gpls_woo_rfq_cookie',false);

if ($cookie_append == false) {

    require_once( ABSPATH . 'wp-includes/class-phpass.php' );
    $hash = new \PasswordHash( 8, false );

    $cookie_append = md5( $hash->get_random_bytes( 1 ) );

    update_option('settings_gpls_woo_rfq_cookie',$cookie_append);

}


if (!defined('RFQTK_WP_SESSION_COOKIE')) {

    define('RFQTK_WP_SESSION_COOKIE', 'rfqtk_wp_session_'.$cookie_append);
}



if (!class_exists('RFQTK_Recursive_ArrayAccess')) {
    include 'includes/class-recursive-arrayaccess.php';
}

// Include utilities class
if (!class_exists('RFQTK_WP_Session_Utils')) {
    include 'includes/class-wp-session-utils.php';
}

// Include WP_CLI routines early
if (defined('RFQTK_WP_CLI') && WP_CLI) {
    include 'includes/wp-cli.php';
}

// Only include the functionality if it's not pre-defined.
if (!class_exists('RFQTK_WP_Session')) {
    include 'includes/class-wp-session.php';
    include 'includes/wp-session.php';
}



if(!function_exists('gpls_woo_rfq_cart_tran_key')) {

    function gpls_woo_rfq_cart_tran_key()
    {

        $wp_session = RFQTK_WP_Session::get_instance();

        $tran_key = apply_filters('set_gpls_rfq_cart_tran_key', $wp_session->session_id);

        return $wp_session->session_id;

    }
}


if(!function_exists('gpls_woo_rfq_get_item')) {

    function gpls_woo_rfq_get_item($key)
    {

        $wp_session = RFQTK_WP_Session::get_instance();

        $key = sanitize_key($key);


        return isset($wp_session[$key]) ? maybe_unserialize($wp_session[$key]) : false;


    }
}


if(!function_exists('gpls_woo_rfq_cart_set')) {

    function gpls_woo_rfq_cart_set($key, $value)
    {


        $wp_session = RFQTK_WP_Session::get_instance();

        $key = sanitize_key($key);

        if (is_array($value)) {
            $wp_session[$key] = serialize($value);
        } else {
            $wp_session[$key] = $value;
        }

        $wp_session->write_data();

        return isset($wp_session[$key]) ? maybe_unserialize($wp_session[$key]) : false;
    }
}

if(!function_exists('gpls_woo_rfq_cart_delete')) {

    function gpls_woo_rfq_cart_delete($key)
    {
        $wp_session = RFQTK_WP_Session::get_instance();

        $key = sanitize_key($key);

        unset($wp_session[$key]);

        $wp_session->write_data();

        return $wp_session[$key];
    }
}
