<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WCPBC_Exchange_Rates_Provider' ) ) :

/**
 *
 * @class WCPBC_Exchange_Rates_Provider
 * @version	2.3.0
 */
abstract class WCPBC_Exchange_Rates_Provider {	
	
	/**
	 * Exchange rates provider name.
	 *
	 * @var $name
	 */
	protected $name = '';

	/**	
	 *
	 * @var $from_currency
	 */
	protected $from_currency = false;

	/**	
	 *
	 * @var $from_currency
	 */
	protected $to_currency = array();

	/**
	 * Return provider name
	 *
	 * @return string
	 */
	public function get_name() {
		return $this->name;
	}

	/**
	 * Return API endpoint
	 *
	 * @param  string $from_currency
	 * @param  array $to_currency	 
	 * @return string
	 */
	abstract protected function get_api_endpoint();

	/**
	 * Return rates array from response
	 *
	 * @param string $data
	 * @return array
	 */
	abstract protected function parse_response( $data );

	/**
	 * Do request to enpoint
	 *	 
	 * @return array
	 */
	protected function do_request() {
		$api_endpoint 	= esc_url_raw( $this->get_api_endpoint() );
		$cache_key 		= 'wcpbc_request_' . md5( $api_endpoint );

		if ( false === ( $data = get_transient( $cache_key ) ) ) {

			$response 	  = wp_safe_remote_get( $api_endpoint, array(
				'timeout' => 15
			) );

			if ( is_wp_error( $response ) ) {
				$data = $response;
			}elseif ( empty( $response['response']['code'] ) || $response['response']['code'] != '200' ) {
				$data = new WP_Error( 'fail', $response['body'] );
			} else {
				$data = $response['body'];
				set_transient( $cache_key, $data, 2 * HOUR_IN_SECONDS );				
			}
		} 

		if ( $data && ! is_wp_error( $data ) ) {
			$data = $this->parse_response( $data );
		}
		
		return $data;
	}

	/**
	 * Return exchage rates array
	 *
	 * @param  string $from_currency
	 * @param  array $to_currency	 
	 * @return array
	 */
	public function get_exchange_rates( $from_currency, $to_currency ){

		$this->from_currency = $from_currency;
		$this->to_currency 	 = $to_currency;

		$rates = $this->do_request();

		if ( is_wp_error( $rates ) ) {		

			$logger = new WC_Logger();			
			$logger->add( 'wc_price_based_country', sprintf( __( 'Unable to update exchange rate from API: %s', 'wc-price-based-country-pro' ) , $rates->get_error_message() ) );

			return array();
		}

		return $rates;
	}	
}

endif;