<?php
/**
 * Integrations
 *
 * Handle integrations between PBC and 3rd-Party plugins
 *
 * @class  WCPBC_Integrations_Pro
 * @version 2.4.8
 * @package WCPBC
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'WCPBC_Integrations_Pro' ) ) :

	/**
	 * WCPBC_Integrations_Pro Class
	 */
	class WCPBC_Integrations_Pro {

		/**
		 * Add built-in integrations
		 */
		public static function init() {

			$integrations = array(
				'WC_Subscriptions'                 => dirname( __FILE__ ) . '/integrations/woocommerce-subscriptions/class-wcpbc-subscriptions.php',
				'WC_Bundles'                       => dirname( __FILE__ ) . '/integrations/class-wcpbc-bundles.php',
				'WC_Product_Addons'                => dirname( __FILE__ ) . '/integrations/class-wcpbc-product-addons.php',
				'WC_Bookings'                      => dirname( __FILE__ ) . '/integrations/class-wcpbc-bookings.php',
				'WC_Accommodation_Bookings_Plugin' => dirname( __FILE__ ) . '/integrations/class-wcpbc-bookings-accommodation.php',
				'WC_Composite_Products'            => dirname( __FILE__ ) . '/integrations/class-wcpbc-composite.php',
				'Affiliate_WP'                     => dirname( __FILE__ ) . '/integrations/class-wcpbc-affiliate-wp.php',
				'WooCommerce_Customer_History'     => dirname( __FILE__ ) . '/integrations/class-wcpbc-customer-history.php',
				'Woocommerce_German_Market'        => dirname( __FILE__ ) . '/integrations/class-wcpbc-german-market.php',
				'WC_Name_Your_Price'               => dirname( __FILE__ ) . '/integrations/class-wcpbc-name-your-price.php',
				'WC_Product_Job_Package'           => dirname( __FILE__ ) . '/integrations/class-wcpbc-job-package.php',
				'WooCommerce_Germanized'           => dirname( __FILE__ ) . '/integrations/class-wcpbc-germanized.php',
				'WC_Smart_Coupons'                 => dirname( __FILE__ ) . '/integrations/class-wcpbc-smart-coupons.php',
				'wc_add_fees_load_plugin_version'  => dirname( __FILE__ ) . '/integrations/class-wcpbc-additional-fees.php',
			);

			foreach ( $integrations as $class => $integration_file ) {
				if ( class_exists( $class ) || function_exists( $class ) ) {
					include_once $integration_file;
				}
			}
		}
	}
endif;
