<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WCPBC_XRates' ) ) :

/** 
 * @class WCPBC_XRates
 * @see https://www.x-rates.com/
 * @version	2.3.0
 */
class WCPBC_XRates extends WCPBC_Exchange_Rates_Provider {

	/**
	 * Constructor
	 */
	public function __construct() {		
		$this->name = 'X-Rates';
	}
	
	/**
	 * Return API endpoint
	 *	 
	 * @return string
	 */
	protected function get_api_endpoint(){
		return 'https://www.x-rates.com/table/?from=' . strtoupper( $this->from_currency ) . '&amount=1';
	}

	/**
	 * Return rates array from response
	 *
	 * @param string $data
	 * @return array
	 */
	protected function parse_response( $data ){		
		$rates 		= array();		
		$fpattern 	= "/<a href='http:\/\/www.x-rates.com\/graph\/\?from=%s&amp;to=%s'>(.+)<\/a>/";
		foreach ( $this->to_currency as $to_currency ) {
			$pattern = sprintf( $fpattern, $this->from_currency, $to_currency);			
			if ( preg_match( $pattern, $data, $matches ) && count( $matches ) > 0 ) {
				$rates[ $to_currency ] = $matches[1];				
			}			
		}
		if ( empty( $rates ) ) {
			$rates = new WP_Error( 'fail', 'Empty exchange rates from X-Rates.' );
		}
		return $rates;
	}
}

endif;

return new WCPBC_XRates();
