<?php
/**
 * @todo add description
 *
 * @package BuddyBoss\Search
 * @since BuddyBoss 1.0.0
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if (!class_exists('Bp_Search_bbPress_Forums')):

	/**
	 * BuddyPress Global Search  - search bbpress forums class
	 */
	class Bp_Search_bbPress_Forums extends Bp_Search_bbPress {
		public $type = 'forum';

		function sql( $search_term, $only_totalrow_count=false ){
			global $wpdb;

			$bp_prefix = bp_core_get_table_prefix();

			$query_placeholder = array();

			if( $only_totalrow_count ){
				$columns = " COUNT( DISTINCT id ) ";
			} else {
				$columns = " DISTINCT id , '{$this->type}' as type, post_title LIKE %s AS relevance, post_date as entry_date  ";
				$query_placeholder[] = '%'. $search_term .'%';
			}

			$from = "{$wpdb->posts} p LEFT JOIN {$wpdb->postmeta} pm ON pm.post_id = p.ID AND pm.meta_key = '_bbp_group_ids'";

			$where = array();
			$where[] = "1=1";
			$where[] = "(post_title LIKE %s OR ExtractValue(post_content, '//text()') LIKE %s)";
			$where[] = "post_type = '{$this->type}'";

			if ( current_user_can( 'read_hidden_forums' ) ) {
				$post_status = [ 'publish', 'private', 'hidden' ];
			} elseif ( current_user_can( 'read_private_forums' ) ) {
				$post_status = [ 'publish', 'private' ];
			} else {
				$post_status = [ 'publish' ];
			}

			$in = '0';

			if ( ! bp_is_search_groups_enable() ) {
				$group_memberships = '';
				if ( bp_is_active( 'groups' ) ) {
					$group_memberships = bp_get_user_groups( get_current_user_id(),
						array(
							'is_admin' => null,
							'is_mod'   => null,
						) );
				}

				if ( ! empty( $group_memberships ) ) {
					$in = array_reduce( array_keys( $group_memberships ), function ( $carry, $group_id ) {
						return $carry . ',\'' . maybe_serialize( [ $group_id ] ) . '\'';
					} );
				}
			} else {
				$where[] = 'pm.post_id IS NULL';
			}

			$where[] = '( post_status IN (\'' . join( '\',\'', $post_status ) . '\') OR pm.meta_value IN ('. trim( $in, ',' ) .') )';

			$query_placeholder[] = '%'. $search_term .'%';
			$query_placeholder[] = '%'. $search_term .'%';

			$sql = 'SELECT '. $columns . ' FROM ' . $from .' WHERE ' . implode( ' AND ', $where );
			$query = $wpdb->prepare( $sql, $query_placeholder );

			return apply_filters(
				'Bp_Search_Forums_sql',
				$query,
				array(
					'search_term'           => $search_term,
					'only_totalrow_count'   => $only_totalrow_count,
				)
			);
		}

		/**
		 * Insures that only one instance of Class exists in memory at any
		 * one time. Also prevents needing to define globals all over the place.
		 *
		 * @since BuddyBoss 1.0.0
		 *
		 * @return object Bp_Search_Forums
		 */
		public static function instance() {
			// Store the instance locally to avoid private static replication
			static $instance = null;

			// Only run these methods if they haven't been run previously
			if (null === $instance) {
				$instance = new Bp_Search_bbPress_Forums();
			}

			// Always return the instance
			return $instance;
		}

		/**
		 * A dummy constructor to prevent this class from being loaded more than once.
		 *
		 * @since BuddyBoss 1.0.0
		 */
		private function __construct() { /* Do nothing here */
		}

	}

// End class Bp_Search_Posts

endif;
?>
